/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp.scripting;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.Interpreter;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.scripting.AbclScriptEngineFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbclScriptEngine
extends AbstractScriptEngine
implements Invocable,
Compilable {
    private Interpreter interpreter = Interpreter.getInstance();
    private Function evalScript;
    private Function evalFunction;
    private Function compileScript;
    Function evalCompiledScript;

    protected AbclScriptEngine() {
        if (this.interpreter == null) {
            this.interpreter = Interpreter.createInstance();
        }
        this.loadFromClasspath("/org/armedbear/lisp/scripting/lisp/packages.lisp");
        this.loadFromClasspath("/org/armedbear/lisp/scripting/lisp/abcl-script.lisp");
        this.loadFromClasspath("/org/armedbear/lisp/scripting/lisp/config.lisp");
        if (this.getClass().getResource("/abcl-script-config.lisp") != null) {
            this.loadFromClasspath("/abcl-script-config.lisp");
        }
        ((Function)this.interpreter.eval("#'abcl-script:configure-abcl")).execute(new JavaObject(this));
        this.evalScript = (Function)this.findSymbol("EVAL-SCRIPT", "ABCL-SCRIPT").getSymbolFunction();
        this.compileScript = (Function)this.findSymbol("COMPILE-SCRIPT", "ABCL-SCRIPT").getSymbolFunction();
        this.evalCompiledScript = (Function)this.findSymbol("EVAL-COMPILED-SCRIPT", "ABCL-SCRIPT").getSymbolFunction();
        this.evalFunction = (Function)this.findSymbol("EVAL-FUNCTION", "ABCL-SCRIPT").getSymbolFunction();
    }

    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    public void setStandardInput(InputStream stream, LispThread thread) {
        thread.setSpecialVariable(Symbol.STANDARD_INPUT, new Stream(Symbol.SYSTEM_STREAM, stream, (LispObject)Symbol.CHARACTER, true));
    }

    public void setStandardInput(InputStream stream) {
        this.setStandardInput(stream, LispThread.currentThread());
    }

    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public static String escape(String s) {
        StringBuffer b = new StringBuffer();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                b.append('\\');
            }
            b.append(c);
        }
        return b.toString();
    }

    public LispObject loadFromClasspath(String classpathResource) {
        InputStream istream = this.getClass().getResourceAsStream(classpathResource);
        Stream stream = new Stream(Symbol.SYSTEM_STREAM, istream, (LispObject)Symbol.CHARACTER);
        return this.load(stream);
    }

    public LispObject load(Stream stream) {
        Symbol keyword_verbose = Lisp.internKeyword("VERBOSE");
        Symbol keyword_print = Lisp.internKeyword("PRINT");
        return Symbol.LOAD.getSymbolFunction().execute(new LispObject[]{stream, keyword_verbose, Lisp.NIL, keyword_print, Lisp.NIL, Keyword.IF_DOES_NOT_EXIST, Lisp.T, Keyword.EXTERNAL_FORMAT, Keyword.DEFAULT});
    }

    public LispObject load(String filespec) {
        return this.load(filespec, true);
    }

    public LispObject load(String filespec, boolean compileIfNecessary) {
        if (AbclScriptEngine.isCompiled(filespec) || !compileIfNecessary) {
            return this.interpreter.eval("(load \"" + AbclScriptEngine.escape(filespec) + "\")");
        }
        return this.compileAndLoad(filespec);
    }

    public static boolean isCompiled(String filespec) {
        File compiled;
        File source2;
        if (filespec.endsWith(".abcl")) {
            return true;
        }
        if (filespec.endsWith(".lisp")) {
            source2 = new File(filespec);
            compiled = new File(filespec.substring(0, filespec.length() - 5) + ".abcl");
        } else {
            source2 = new File(filespec + ".lisp");
            compiled = new File(filespec + ".abcl");
        }
        if (!source2.exists()) {
            throw new IllegalArgumentException("The source file " + filespec + " cannot be found");
        }
        return compiled.exists() && compiled.lastModified() >= source2.lastModified();
    }

    public LispObject compileFile(String filespec) {
        return this.interpreter.eval("(compile-file \"" + AbclScriptEngine.escape(filespec) + "\")");
    }

    public LispObject compileAndLoad(String filespec) {
        return this.interpreter.eval("(load (compile-file \"" + AbclScriptEngine.escape(filespec) + "\"))");
    }

    public static boolean functionp(LispObject obj) {
        return obj instanceof Function;
    }

    public JavaObject jsetq(String symbol, Object value) {
        Symbol s = this.findSymbol(symbol);
        JavaObject jo = value instanceof JavaObject ? (JavaObject)value : new JavaObject(value);
        s.setSymbolValue(jo);
        return jo;
    }

    public Symbol findSymbol(String name, String pkg) {
        Cons values = (Cons)this.interpreter.eval("(cl:multiple-value-list (find-symbol (symbol-name '#:" + AbclScriptEngine.escape(name) + ")" + (pkg == null ? "" : " :" + AbclScriptEngine.escape(pkg)) + "))");
        if (values.cadr() == Lisp.NIL) {
            return null;
        }
        return (Symbol)values.car();
    }

    public Symbol findSymbol(String name) {
        int i = name.indexOf(58);
        if (i < 0) {
            return this.findSymbol(name, null);
        }
        if (i < name.length() - 1 && name.charAt(i + 1) == ':') {
            return this.findSymbol(name.substring(i + 2), name.substring(0, i));
        }
        return this.findSymbol(name.substring(i + 1), name.substring(0, i));
    }

    public Function findFunction(String name) {
        return (Function)this.interpreter.eval("#'" + name);
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    private static LispObject makeBindings(Bindings bindings) {
        if (bindings == null || bindings.size() == 0) {
            return Lisp.NIL;
        }
        LispObject[] argList = new LispObject[bindings.size()];
        int i = 0;
        for (Map.Entry entry : bindings.entrySet()) {
            argList[i++] = Symbol.CONS.execute((LispObject)new SimpleString((String)entry.getKey()), JavaObject.getInstance(entry.getValue(), true));
        }
        return Symbol.LIST.getSymbolFunction().execute(argList);
    }

    Object eval(Function evaluator, LispObject code, ScriptContext ctx) throws ScriptException {
        LispObject retVal = null;
        Stream outStream = new Stream(Symbol.SYSTEM_STREAM, ctx.getWriter());
        Stream inStream = new Stream(Symbol.SYSTEM_STREAM, ctx.getReader());
        retVal = evaluator.execute(AbclScriptEngine.makeBindings(ctx.getBindings(200)), AbclScriptEngine.makeBindings(ctx.getBindings(100)), inStream, outStream, code, new JavaObject(ctx));
        return retVal.javaInstance();
    }

    @Override
    public Object eval(String code, ScriptContext ctx) throws ScriptException {
        return this.eval(this.evalScript, new SimpleString(code), ctx);
    }

    private static String toString(Reader reader) throws IOException {
        StringWriter w = new StringWriter();
        int i = reader.read();
        while (i != -1) {
            w.write(i);
            i = reader.read();
        }
        return w.toString();
    }

    @Override
    public Object eval(Reader code, ScriptContext ctx) throws ScriptException {
        try {
            return this.eval(AbclScriptEngine.toString(code), ctx);
        }
        catch (IOException e) {
            return new ScriptException(e);
        }
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return new AbclScriptEngineFactory();
    }

    @Override
    public <T> T getInterface(Class<T> clasz) {
        try {
            return this.getInterface(this.eval("(cl:find-package '#:ABCL-SCRIPT-USER)"), clasz);
        }
        catch (ScriptException e) {
            throw new Error(e);
        }
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        Symbol s = this.findSymbol("jmake-proxy", "JAVA");
        JavaObject iface = new JavaObject(clasz);
        return (T)((JavaObject)s.execute((LispObject)iface, (LispObject)thiz)).javaInstance();
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        Symbol s = name.indexOf(58) >= 0 ? this.findSymbol(name) : this.findSymbol(name, "ABCL-SCRIPT-USER");
        if (s != null) {
            LispObject f = s.getSymbolFunction();
            if (f != null && f instanceof Function) {
                LispObject functionAndArgs = Lisp.NIL.push(f);
                for (int i = 0; i < args.length; ++i) {
                    functionAndArgs = functionAndArgs.push(JavaObject.getInstance(args[i], true));
                }
                functionAndArgs = functionAndArgs.reverse();
                return this.eval(this.evalFunction, functionAndArgs, this.getContext());
            }
            throw new NoSuchMethodException(name);
        }
        throw new NoSuchMethodException(name);
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        throw new UnsupportedOperationException("Common Lisp does not have methods in the Java sense. Use invokeFunction instead.");
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        try {
            Function f = (Function)this.compileScript.execute(new SimpleString(script));
            return new AbclCompiledScript(f);
        }
        catch (ClassCastException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        try {
            return this.compile(AbclScriptEngine.toString(script));
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    public class AbclCompiledScript
    extends CompiledScript {
        private LispObject function;

        public AbclCompiledScript(LispObject function) {
            this.function = function;
        }

        public Object eval(ScriptContext context) throws ScriptException {
            return AbclScriptEngine.this.eval(AbclScriptEngine.this.evalCompiledScript, this.function, context);
        }

        public ScriptEngine getEngine() {
            return AbclScriptEngine.this;
        }
    }
}

