/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.DocString;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.HashTable;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;
import org.armedbear.lisp.WeakHashTable;

public final class HashTableFunctions {
    static final LispObject FUNCTION_EQ = Symbol.EQ.getSymbolFunction();
    static final LispObject FUNCTION_EQL = Symbol.EQL.getSymbolFunction();
    static final LispObject FUNCTION_EQUAL = Symbol.EQUAL.getSymbolFunction();
    static final LispObject FUNCTION_EQUALP = Symbol.EQUALP.getSymbolFunction();
    private static final Primitive _MAKE_HASH_TABLE = new pf__make_hash_table();
    private static final Primitive _MAKE_WEAK_HASH_TABLE = new pf__make_weak_hash_table();
    private static final Primitive GETHASH = new pf_gethash();
    private static final Primitive GETHASH1 = new pf_gethash1();
    private static final Primitive PUTHASH = new pf_puthash();
    private static final Primitive REMHASH = new pf_remhash();
    private static final Primitive CLRHASH = new pf_clrhash();
    private static final Primitive HASH_TABLE_COUNT = new pf_hash_table_count();
    private static final Primitive SXHASH = new pf_sxhash();
    @DocString(name="psxhash", args="object")
    private static final Primitive PSXHASH = new pf_psxhash();
    private static final Primitive HASH_TABLE_P = new pf_hash_table_p();
    private static final Primitive HASH_TABLE_ENTRIES = new pf_hash_table_entries();
    private static final Primitive HASH_TABLE_TEST = new pf_hash_table_test();
    private static final Primitive HASH_TABLE_SIZE = new pf_hash_table_size();
    private static final Primitive HASH_TABLE_REHASH_SIZE = new pf_hash_table_rehash_size();
    private static final Primitive HASH_TABLE_REHASH_THRESHOLD = new pf_hash_table_rehash_threshold();
    private static final Primitive MAPHASH = new pf_maphash();
    private static final Primitive HASH_TABLE_WEAKNESS = new pf_hash_table_weakness();

    protected static HashTable checkHashTable(LispObject ht) {
        if (ht instanceof HashTable) {
            return (HashTable)ht;
        }
        Lisp.type_error(ht, Symbol.HASH_TABLE);
        return null;
    }

    @DocString(name="hash-table-weakness", args="hash-table", doc="Return weakness property of HASH-TABLE, or NIL if it has none.")
    private static final class pf_hash_table_weakness
    extends Primitive {
        pf_hash_table_weakness() {
            super(Symbol.HASH_TABLE_WEAKNESS, "hash-table");
        }

        public LispObject execute(LispObject first) {
            if (first instanceof HashTable) {
                return Lisp.NIL;
            }
            if (first instanceof WeakHashTable) {
                return ((WeakHashTable)first).getWeakness();
            }
            return Lisp.error(new TypeError(first, Symbol.HASH_TABLE));
        }
    }

    @DocString(name="maphash", args="function hash-table", doc="Iterates over all entries in the hash-table. For each entry, the function is called with two arguments--the key and the value of that entry.")
    private static final class pf_maphash
    extends Primitive {
        pf_maphash() {
            super(Symbol.MAPHASH, "function hash-table");
        }

        public LispObject execute(LispObject first, LispObject second) {
            if (second instanceof WeakHashTable) {
                return ((WeakHashTable)second).MAPHASH(first);
            }
            return HashTableFunctions.checkHashTable(second).MAPHASH(first);
        }
    }

    @DocString(name="hash-table-rehash-threshold", args="hash-table")
    private static final class pf_hash_table_rehash_threshold
    extends Primitive {
        pf_hash_table_rehash_threshold() {
            super(Symbol.HASH_TABLE_REHASH_THRESHOLD, "hash-table");
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof WeakHashTable) {
                return ((WeakHashTable)arg).getRehashThreshold();
            }
            return HashTableFunctions.checkHashTable(arg).getRehashThreshold();
        }
    }

    @DocString(name="hash-table-rehash-size", args="hash-table")
    private static final class pf_hash_table_rehash_size
    extends Primitive {
        pf_hash_table_rehash_size() {
            super(Symbol.HASH_TABLE_REHASH_SIZE, "hash-table");
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof WeakHashTable) {
                return ((WeakHashTable)arg).getRehashSize();
            }
            return HashTableFunctions.checkHashTable(arg).getRehashSize();
        }
    }

    @DocString(name="hash-table-size", args="hash-table", doc="Returns the number of storage buckets in HASH-TABLE.")
    private static final class pf_hash_table_size
    extends Primitive {
        pf_hash_table_size() {
            super(Symbol.HASH_TABLE_SIZE, "hash-table");
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof WeakHashTable) {
                return Fixnum.getInstance(((WeakHashTable)arg).getSize());
            }
            return Fixnum.getInstance(HashTableFunctions.checkHashTable(arg).getSize());
        }
    }

    @DocString(name="hash-table-test", args="hash-table", doc="Return the test used for the keys of HASH-TABLE.")
    private static final class pf_hash_table_test
    extends Primitive {
        pf_hash_table_test() {
            super(Symbol.HASH_TABLE_TEST, "hash-table");
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof WeakHashTable) {
                return ((WeakHashTable)arg).getTest();
            }
            return HashTableFunctions.checkHashTable(arg).getTest();
        }
    }

    @DocString(name="hah-table-entries", args="hash-table", doc="Returns a list of all key/values pairs in HASH-TABLE.")
    private static final class pf_hash_table_entries
    extends Primitive {
        pf_hash_table_entries() {
            super("hash-table-entries", Lisp.PACKAGE_SYS, false);
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof WeakHashTable) {
                return ((WeakHashTable)arg).ENTRIES();
            }
            return HashTableFunctions.checkHashTable(arg).ENTRIES();
        }
    }

    @DocString(name="hash-table-p", args="object", doc="Whether OBJECT is an instance of a hash-table.")
    private static final class pf_hash_table_p
    extends Primitive {
        pf_hash_table_p() {
            super(Symbol.HASH_TABLE_P, "object");
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof WeakHashTable) {
                return Lisp.T;
            }
            return arg instanceof HashTable ? Lisp.T : Lisp.NIL;
        }
    }

    private static final class pf_psxhash
    extends Primitive {
        pf_psxhash() {
            super("psxhash", Lisp.PACKAGE_SYS, true, "object");
        }

        public LispObject execute(LispObject arg) {
            return Fixnum.getInstance(arg.psxhash());
        }
    }

    @DocString(name="sxhash", args="object => hash-code")
    private static final class pf_sxhash
    extends Primitive {
        pf_sxhash() {
            super(Symbol.SXHASH, "object");
        }

        public LispObject execute(LispObject arg) {
            return Fixnum.getInstance(arg.sxhash());
        }
    }

    @DocString(name="hash-table-count", args="hash-table", doc="Returns the number of entries in HASH-TABLE.")
    private static final class pf_hash_table_count
    extends Primitive {
        pf_hash_table_count() {
            super(Symbol.HASH_TABLE_COUNT, "hash-table");
        }

        public LispObject execute(LispObject arg) {
            if (arg instanceof WeakHashTable) {
                return Fixnum.getInstance(((WeakHashTable)arg).getCount());
            }
            return Fixnum.getInstance(HashTableFunctions.checkHashTable(arg).getCount());
        }
    }

    @DocString(name="clrhash", args="hash-table", returns="hash-table")
    private static final class pf_clrhash
    extends Primitive {
        pf_clrhash() {
            super(Symbol.CLRHASH, "hash-table");
        }

        public LispObject execute(LispObject ht) {
            if (ht instanceof WeakHashTable) {
                ((WeakHashTable)ht).clear();
                return ht;
            }
            HashTableFunctions.checkHashTable(ht).clear();
            return ht;
        }
    }

    @DocString(name="remhash", args="key hash-table", returns="generalized-boolean", doc="Removes the value for KEY in HASH-TABLE, if any.")
    private static final class pf_remhash
    extends Primitive {
        pf_remhash() {
            super(Symbol.REMHASH, "key hash-table");
        }

        public LispObject execute(LispObject key, LispObject ht) {
            if (ht instanceof WeakHashTable) {
                return ((WeakHashTable)ht).remhash(key);
            }
            return HashTableFunctions.checkHashTable(ht).remhash(key);
        }
    }

    @DocString(name="puthash", args="key hash-table new-value &optional default", returns="value")
    private static final class pf_puthash
    extends Primitive {
        pf_puthash() {
            super(Symbol.PUTHASH, "key hash-table new-value &optional default");
        }

        public LispObject execute(LispObject key, LispObject ht, LispObject value) {
            if (ht instanceof WeakHashTable) {
                return ((WeakHashTable)ht).puthash(key, value);
            }
            return HashTableFunctions.checkHashTable(ht).puthash(key, value);
        }

        public LispObject execute(LispObject key, LispObject ht, LispObject ignored, LispObject value) {
            if (ht instanceof WeakHashTable) {
                return ((WeakHashTable)ht).puthash(key, value);
            }
            return HashTableFunctions.checkHashTable(ht).puthash(key, value);
        }
    }

    @DocString(name="gethash1", args="key hash-table", returns="value")
    private static final class pf_gethash1
    extends Primitive {
        pf_gethash1() {
            super(Symbol.GETHASH1, "key hash-table");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LispObject execute(LispObject first, LispObject second) {
            HashTable ht;
            if (second instanceof WeakHashTable) {
                WeakHashTable ht2;
                WeakHashTable weakHashTable = ht2 = (WeakHashTable)second;
                synchronized (weakHashTable) {
                    LispObject value = ht2.get(first);
                    return value != null ? value : Lisp.NIL;
                }
            }
            HashTable hashTable = ht = HashTableFunctions.checkHashTable(second);
            synchronized (hashTable) {
                LispObject value = ht.get(first);
                return value != null ? value : Lisp.NIL;
            }
        }
    }

    @DocString(name="gethash", args="key hash-table &optional default", returns="value, present-p", doc="Returns the value associated with KEY in HASH-TABLE.")
    private static final class pf_gethash
    extends Primitive {
        pf_gethash() {
            super(Symbol.GETHASH, "key hash-table &optional default");
        }

        public LispObject execute(LispObject key, LispObject ht) {
            if (ht instanceof WeakHashTable) {
                return ((WeakHashTable)ht).gethash(key);
            }
            return HashTableFunctions.checkHashTable(ht).gethash(key);
        }

        public LispObject execute(LispObject key, LispObject ht, LispObject defaultValue) {
            if (ht instanceof WeakHashTable) {
                return ((WeakHashTable)ht).gethash(key, defaultValue);
            }
            return HashTableFunctions.checkHashTable(ht).gethash(key, defaultValue);
        }
    }

    @DocString(name="%make-weak-hash-table")
    private static final class pf__make_weak_hash_table
    extends Primitive {
        pf__make_weak_hash_table() {
            super("%make-weak-hash-table", Lisp.PACKAGE_SYS, false);
        }

        public LispObject execute(LispObject test, LispObject size, LispObject rehashSize, LispObject rehashThreshold, LispObject weakness) {
            int n = Fixnum.getValue(size);
            if (test == FUNCTION_EQL || test == Lisp.NIL) {
                return WeakHashTable.newEqlHashTable(n, rehashSize, rehashThreshold, weakness);
            }
            if (test == FUNCTION_EQ) {
                return WeakHashTable.newEqHashTable(n, rehashSize, rehashThreshold, weakness);
            }
            if (test == FUNCTION_EQUAL) {
                return WeakHashTable.newEqualHashTable(n, rehashSize, rehashThreshold, weakness);
            }
            if (test == FUNCTION_EQUALP) {
                return WeakHashTable.newEqualpHashTable(n, rehashSize, rehashThreshold, weakness);
            }
            return Lisp.error(new LispError("Unsupported test for MAKE-HASH-TABLE: " + test.princToString()));
        }
    }

    @DocString(name="%make-hash-table")
    private static final class pf__make_hash_table
    extends Primitive {
        pf__make_hash_table() {
            super("%make-hash-table", Lisp.PACKAGE_SYS, false);
        }

        public LispObject execute(LispObject test, LispObject size, LispObject rehashSize, LispObject rehashThreshold) {
            int n = Fixnum.getValue(size);
            if (test == FUNCTION_EQL || test == Lisp.NIL) {
                return HashTable.newEqlHashTable(n, rehashSize, rehashThreshold);
            }
            if (test == FUNCTION_EQ) {
                return HashTable.newEqHashTable(n, rehashSize, rehashThreshold);
            }
            if (test == FUNCTION_EQUAL) {
                return HashTable.newEqualHashTable(n, rehashSize, rehashThreshold);
            }
            if (test == FUNCTION_EQUALP) {
                return HashTable.newEqualpHashTable(n, rehashSize, rehashThreshold);
            }
            return Lisp.error(new LispError("Unsupported test for MAKE-HASH-TABLE: " + test.princToString()));
        }
    }
}

