/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BasicVector_UnsignedByte16;
import org.armedbear.lisp.BasicVector_UnsignedByte32;
import org.armedbear.lisp.BasicVector_UnsignedByte8;
import org.armedbear.lisp.ComplexArray;
import org.armedbear.lisp.ComplexArray_UnsignedByte32;
import org.armedbear.lisp.ComplexArray_UnsignedByte8;
import org.armedbear.lisp.ComplexBitVector;
import org.armedbear.lisp.ComplexString;
import org.armedbear.lisp.ComplexVector;
import org.armedbear.lisp.ComplexVector_UnsignedByte32;
import org.armedbear.lisp.ComplexVector_UnsignedByte8;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.NilVector;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleArray_T;
import org.armedbear.lisp.SimpleArray_UnsignedByte16;
import org.armedbear.lisp.SimpleArray_UnsignedByte32;
import org.armedbear.lisp.SimpleArray_UnsignedByte8;
import org.armedbear.lisp.SimpleBitVector;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SimpleVector;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.WrongNumberOfArgumentsException;
import org.armedbear.lisp.ZeroRankArray;

public final class make_array
extends Primitive {
    private static final Primitive _MAKE_ARRAY = new make_array();

    public make_array() {
        super("%make-array", Lisp.PACKAGE_SYS, false);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LispObject execute(LispObject[] args) {
        AbstractArray array;
        if (args.length != 9) {
            return Lisp.error(new WrongNumberOfArgumentsException(this, 9));
        }
        LispObject dimensions = args[0];
        LispObject elementType = args[1];
        LispObject initialElement = args[2];
        LispObject initialElementProvided = args[3];
        LispObject initialContents = args[4];
        LispObject adjustable = args[5];
        LispObject fillPointer = args[6];
        LispObject displacedTo = args[7];
        LispObject displacedIndexOffset = args[8];
        if (initialElementProvided != Lisp.NIL && initialContents != Lisp.NIL) {
            return Lisp.error(new LispError("MAKE-ARRAY: cannot specify both initial element and initial contents."));
        }
        int rank = dimensions.listp() ? dimensions.length() : 1;
        int[] dimv = new int[rank];
        if (dimensions.listp()) {
            for (int i = 0; i < rank; ++i) {
                LispObject dim = dimensions.car();
                dimv[i] = Fixnum.getValue(dim);
                dimensions = dimensions.cdr();
            }
        } else {
            dimv[0] = Fixnum.getValue(dimensions);
        }
        if (displacedTo != Lisp.NIL) {
            AbstractArray array2 = Lisp.checkArray(displacedTo);
            if (initialElementProvided != Lisp.NIL) {
                return Lisp.error(new LispError("Initial element must not be specified for a displaced array."));
            }
            if (initialContents != Lisp.NIL) {
                return Lisp.error(new LispError("Initial contents must not be specified for a displaced array."));
            }
            int displacement = displacedIndexOffset != Lisp.NIL ? Fixnum.getValue(displacedIndexOffset) : 0;
            if (rank != 1) return new ComplexArray(dimv, array2, displacement);
            LispObject lispObject = array2.getElementType();
            AbstractVector v = lispObject == Symbol.CHARACTER ? new ComplexString(dimv[0], array2, displacement) : (lispObject == Symbol.BIT ? new ComplexBitVector(dimv[0], array2, displacement) : (lispObject.equal(Lisp.UNSIGNED_BYTE_8) ? new ComplexVector_UnsignedByte8(dimv[0], array2, displacement) : (lispObject.equal(Lisp.UNSIGNED_BYTE_32) ? new ComplexVector_UnsignedByte32(dimv[0], array2, displacement) : new ComplexVector(dimv[0], array2, displacement))));
            if (fillPointer == Lisp.NIL) return v;
            v.setFillPointer(fillPointer);
            return v;
        }
        LispObject upgradedType = Lisp.getUpgradedArrayElementType(elementType);
        if (rank == 0) {
            LispObject data = initialElementProvided != Lisp.NIL ? initialElement : initialContents;
            return new ZeroRankArray(upgradedType, data, adjustable != Lisp.NIL);
        }
        if (rank == 1) {
            void var16_27;
            AbstractVector v;
            int size = dimv[0];
            if (size < 0 || size >= Integer.MAX_VALUE) {
                StringBuilder sb = new StringBuilder();
                sb.append("The size specified for this array (");
                sb.append(size);
                sb.append(')');
                if (size >= Integer.MAX_VALUE) {
                    sb.append(" is >= ARRAY-DIMENSION-LIMIT (");
                    sb.append(Integer.MAX_VALUE);
                    sb.append(").");
                    return Lisp.error(new LispError(sb.toString()));
                } else {
                    sb.append(" is negative.");
                }
                return Lisp.error(new LispError(sb.toString()));
            }
            if (upgradedType == Symbol.CHARACTER) {
                v = fillPointer != Lisp.NIL || adjustable != Lisp.NIL ? new ComplexString(size) : new SimpleString(size);
                LispCharacter lispCharacter = LispCharacter.getInstance('\u0000');
            } else if (upgradedType == Symbol.BIT) {
                v = fillPointer != Lisp.NIL || adjustable != Lisp.NIL ? new ComplexBitVector(size) : new SimpleBitVector(size);
                Fixnum fixnum = Fixnum.ZERO;
            } else if (upgradedType.equal(Lisp.UNSIGNED_BYTE_8)) {
                v = fillPointer != Lisp.NIL || adjustable != Lisp.NIL ? new ComplexVector_UnsignedByte8(size) : new BasicVector_UnsignedByte8(size);
                Fixnum fixnum = Fixnum.ZERO;
            } else if (upgradedType.equal(Lisp.UNSIGNED_BYTE_16) && fillPointer == Lisp.NIL && adjustable == Lisp.NIL) {
                v = new BasicVector_UnsignedByte16(size);
                Fixnum fixnum = Fixnum.ZERO;
            } else if (upgradedType.equal(Lisp.UNSIGNED_BYTE_32)) {
                v = fillPointer != Lisp.NIL || adjustable != Lisp.NIL ? new ComplexVector_UnsignedByte32(size) : new BasicVector_UnsignedByte32(size);
                Fixnum fixnum = Fixnum.ZERO;
            } else if (upgradedType == Lisp.NIL) {
                v = new NilVector(size);
                Object var16_25 = null;
            } else {
                v = fillPointer != Lisp.NIL || adjustable != Lisp.NIL ? new ComplexVector(size) : new SimpleVector(size);
                LispObject lispObject = Lisp.NIL;
            }
            if (initialElementProvided != Lisp.NIL) {
                v.fill(initialElement);
            } else if (initialContents != Lisp.NIL) {
                if (initialContents.listp()) {
                    LispObject list = initialContents;
                    for (int i = 0; i < size; ++i) {
                        v.aset(i, list.car());
                        list = list.cdr();
                    }
                } else {
                    if (!initialContents.vectorp()) return Lisp.type_error(initialContents, Symbol.SEQUENCE);
                    for (int i = 0; i < size; ++i) {
                        v.aset(i, initialContents.elt(i));
                    }
                }
            } else if (var16_27 != null) {
                v.fill((LispObject)var16_27);
            }
            if (fillPointer == Lisp.NIL) return v;
            v.setFillPointer(fillPointer);
            return v;
        }
        if (adjustable == Lisp.NIL) {
            if (upgradedType.equal(Lisp.UNSIGNED_BYTE_8)) {
                if (initialContents != Lisp.NIL) {
                    return new SimpleArray_UnsignedByte8(dimv, initialContents);
                }
                array = new SimpleArray_UnsignedByte8(dimv);
                if (initialElementProvided != Lisp.NIL) {
                    array.fill(initialElement);
                    return array;
                } else {
                    array.fill(Fixnum.ZERO);
                }
                return array;
            } else if (upgradedType.equal(Lisp.UNSIGNED_BYTE_16)) {
                if (initialContents != Lisp.NIL) {
                    return new SimpleArray_UnsignedByte16(dimv, initialContents);
                }
                array = new SimpleArray_UnsignedByte16(dimv);
                if (initialElementProvided != Lisp.NIL) {
                    array.fill(initialElement);
                    return array;
                } else {
                    array.fill(Fixnum.ZERO);
                }
                return array;
            } else if (upgradedType.equal(Lisp.UNSIGNED_BYTE_32)) {
                if (initialContents != Lisp.NIL) {
                    return new SimpleArray_UnsignedByte32(dimv, initialContents);
                }
                array = new SimpleArray_UnsignedByte32(dimv);
                if (initialElementProvided != Lisp.NIL) {
                    array.fill(initialElement);
                    return array;
                } else {
                    array.fill(Fixnum.ZERO);
                }
                return array;
            } else {
                if (initialContents != Lisp.NIL) {
                    return new SimpleArray_T(dimv, upgradedType, initialContents);
                }
                array = new SimpleArray_T(dimv, upgradedType);
                if (initialElementProvided != Lisp.NIL) {
                    array.fill(initialElement);
                    return array;
                } else {
                    array.fill(Lisp.NIL);
                }
            }
            return array;
        } else if (upgradedType.equal(Lisp.UNSIGNED_BYTE_8)) {
            if (initialContents != Lisp.NIL) {
                return new ComplexArray_UnsignedByte8(dimv, initialContents);
            }
            array = new ComplexArray_UnsignedByte8(dimv);
            if (initialElementProvided != Lisp.NIL) {
                array.fill(initialElement);
                return array;
            } else {
                array.fill(Fixnum.ZERO);
            }
            return array;
        } else if (upgradedType.equal(Lisp.UNSIGNED_BYTE_32)) {
            if (initialContents != Lisp.NIL) {
                return new ComplexArray_UnsignedByte32(dimv, initialContents);
            }
            array = new ComplexArray_UnsignedByte32(dimv);
            if (initialElementProvided != Lisp.NIL) {
                array.fill(initialElement);
                return array;
            } else {
                array.fill(Fixnum.ZERO);
            }
            return array;
        } else {
            if (initialContents != Lisp.NIL) {
                return new ComplexArray(dimv, upgradedType, initialContents);
            }
            array = new ComplexArray(dimv, upgradedType);
            if (initialElementProvided != Lisp.NIL) {
                array.fill(initialElement);
                return array;
            } else {
                array.fill(Lisp.NIL);
            }
        }
        return array;
    }
}

