/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.asciidoctor.AsciiDocDirectoryWalker;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;

public class AsciidoctorAntTask
extends Task {
    private String sourceDirectory;
    private String outputDirectory;
    private String sourceDocumentName;
    private String backend = "docbook";
    private String imagesDir = "images";
    private String doctype = "article";
    private boolean compact = false;
    private boolean headerFooter = true;
    private String sourceHighlighter;
    private boolean embedAssets = false;
    private String eruby = "";
    private String templateDir;
    private String templateEngine;
    private List<Attribute> attributes = new ArrayList<Attribute>();

    public void execute() throws BuildException {
        this.checkMandatoryParameter("sourceDirectory", this.sourceDirectory);
        this.checkMandatoryParameter("outputDirectory", this.outputDirectory);
        this.ensureOutputExists();
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        AttributesBuilder attributesBuilder = this.buildAttributes();
        OptionsBuilder optionsBuilder = this.buildOptions();
        optionsBuilder.attributes(attributesBuilder.get());
        Options options2 = optionsBuilder.get();
        AsciiDocDirectoryWalker directoryWalker = new AsciiDocDirectoryWalker(this.sourceDirectory);
        List<File> asciidocFiles = directoryWalker.scan();
        if (this.sourceDocumentName == null) {
            this.log("Render asciidoc files from " + this.sourceDirectory + " to " + this.outputDirectory + " with backend=" + this.backend);
            for (File file2 : asciidocFiles) {
                asciidoctor.renderFile(file2, options2);
            }
        } else {
            this.log("Render " + this.sourceDocumentName + " from " + this.sourceDirectory + " to " + this.outputDirectory + " with backend=" + this.backend);
            asciidoctor.renderFile(new File(this.sourceDirectory, this.sourceDocumentName), options2);
        }
    }

    private OptionsBuilder buildOptions() {
        OptionsBuilder optionsBuilder = OptionsBuilder.options();
        optionsBuilder.safe(SafeMode.SAFE).eruby(this.eruby);
        optionsBuilder.baseDir(this.getProject().getBaseDir()).toDir(new File(this.outputDirectory));
        optionsBuilder.backend(this.backend).docType(this.doctype).compact(this.compact).headerFooter(this.headerFooter);
        if (this.templateEngine != null) {
            optionsBuilder.templateEngine(this.templateEngine);
        }
        if (this.templateDir != null) {
            optionsBuilder.templateDir(new File(this.templateDir));
        }
        return optionsBuilder;
    }

    private AttributesBuilder buildAttributes() {
        AttributesBuilder attributesBuilder = AttributesBuilder.attributes();
        attributesBuilder.imagesDir(this.imagesDir);
        if (this.sourceHighlighter != null) {
            attributesBuilder.sourceHighlighter(this.sourceHighlighter);
        }
        if (this.embedAssets) {
            attributesBuilder.linkCss(false);
            attributesBuilder.dataUri(true);
        }
        attributesBuilder.copyCss(false);
        for (Attribute attribute : this.attributes) {
            if ("true".equals(attribute.getValue()) || "false".equals(attribute.getValue())) {
                attributesBuilder.attribute(attribute.getKey(), Attributes.toAsciidoctorFlag(Boolean.valueOf(attribute.getValue())));
                continue;
            }
            attributesBuilder.attribute(attribute.getKey(), attribute.getValue());
        }
        return attributesBuilder;
    }

    private void checkMandatoryParameter(String name2, Object value2) {
        if (value2 == null) {
            throw new BuildException(name2 + " is mandatory");
        }
    }

    private void ensureOutputExists() {
        File outputFile = new File(this.outputDirectory);
        if (!outputFile.exists() && !outputFile.mkdirs()) {
            this.log("Can't create " + outputFile.getPath(), 0);
        }
    }

    public void setSourceDirectory(String sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setSourceDocumentName(String sourceDocumentName) {
        this.sourceDocumentName = sourceDocumentName;
    }

    public void setBackend(String backend) {
        this.backend = backend;
    }

    public void setImagesDir(String imagesDir) {
        this.imagesDir = imagesDir;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public void setCompact(boolean compact2) {
        this.compact = compact2;
    }

    public void setHeaderFooter(boolean headerFooter) {
        this.headerFooter = headerFooter;
    }

    public void setSourceHighlighter(String sourceHighlighter) {
        this.sourceHighlighter = sourceHighlighter;
    }

    public void setEmbedAssets(boolean embedAssets) {
        this.embedAssets = embedAssets;
    }

    public void setEruby(String eruby) {
        this.eruby = eruby;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public void setTemplateEngine(String templateEngine) {
        this.templateEngine = templateEngine;
    }

    public Attribute createAttribute() {
        Attribute attribute = new Attribute();
        this.attributes.add(attribute);
        return attribute;
    }

    public class Attribute {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setKey(String key2) {
            this.key = key2;
        }

        public void setValue(String value2) {
            this.value = value2;
        }
    }
}

