/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.transcode;

import java.util.Arrays;
import org.jcodings.ObjPtr;
import org.jcodings.exception.TranscoderException;
import org.jcodings.transcode.EConv;
import org.jcodings.transcode.EConvFlags;
import org.jcodings.transcode.Transcoder;
import org.jcodings.transcode.TranscoderList;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jcodings.util.Hash;

public class TranscoderDB
implements EConvFlags {
    public static final CaseInsensitiveBytesHash<CaseInsensitiveBytesHash<Entry>> transcoders = new CaseInsensitiveBytesHash();

    static Entry makeEntry(byte[] source2, byte[] destination) {
        Entry entry;
        CaseInsensitiveBytesHash<Entry> sHash = transcoders.get(source2);
        if (sHash == null) {
            sHash = new CaseInsensitiveBytesHash();
            transcoders.putDirect(source2, sHash);
        }
        if ((entry = sHash.get(destination)) != null) {
            throw new TranscoderException("transcoder from <%n> has been already registered", new String(source2 + " to " + new String(destination)));
        }
        entry = new Entry(source2, destination);
        sHash.putDirect(destination, entry);
        return entry;
    }

    static Entry getEntry(byte[] source2, byte[] destination) {
        CaseInsensitiveBytesHash<Entry> sHash = transcoders.get(source2);
        return sHash == null ? null : sHash.get(destination);
    }

    static void register(Transcoder transcoder) {
        Entry entry = TranscoderDB.makeEntry(transcoder.source, transcoder.destination);
        if (entry.transcoder != null) {
            throw new TranscoderException("transcoder from <%n> has been already registered", new String(transcoder.source + " to " + new String(transcoder.destination)));
        }
        entry.transcoder = transcoder;
    }

    static void declare(byte[] source2, byte[] destination, String transcoderClass) {
        Entry entry = TranscoderDB.makeEntry(source2, destination);
        entry.transcoderClass = transcoderClass;
    }

    static int searchPath(byte[] source2, byte[] destination, SearchPathCallback callback) {
        if (CaseInsensitiveBytesHash.caseInsensitiveEquals(source2, destination)) {
            return -1;
        }
        ObjPtr bfsQueue = new ObjPtr();
        SearchPathQueue queue = new SearchPathQueue();
        queue.encoding = source2;
        ObjPtr<SearchPathQueue> bfsLastQueue = queue.next;
        bfsQueue.p = queue;
        CaseInsensitiveBytesHash<byte[]> bfsVisited = new CaseInsensitiveBytesHash<byte[]>();
        bfsVisited.put(source2, EConv.NULL_STRING);
        while (bfsQueue.p != null) {
            CaseInsensitiveBytesHash<Entry> table2;
            queue = (SearchPathQueue)bfsQueue.p;
            bfsQueue.p = queue.next.p;
            if (bfsQueue.p == null) {
                bfsLastQueue = bfsQueue;
            }
            if ((table2 = transcoders.get(queue.encoding)) == null) continue;
            Entry entry = table2.get(destination);
            if (entry != null) {
                byte[] tmp;
                bfsVisited.put(destination, queue.encoding);
                byte[] enc = destination;
                int pathLength = 0;
                while ((tmp = (byte[])bfsVisited.get(enc)) != EConv.NULL_STRING) {
                    ++pathLength;
                    enc = tmp;
                }
                int depth = pathLength;
                enc = destination;
                while ((tmp = (byte[])bfsVisited.get(enc)) != EConv.NULL_STRING) {
                    callback.call(tmp, enc, --depth);
                    enc = tmp;
                }
                return pathLength;
            }
            byte[] bfsBaseEnc = queue.encoding;
            for (Hash.HashEntry o : table2.entryIterator()) {
                CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)o;
                byte[] dname = e.bytes;
                if (bfsVisited.get(dname) != null) continue;
                SearchPathQueue q = new SearchPathQueue();
                q.encoding = dname;
                q.next.p = null;
                bfsLastQueue.p = q;
                bfsLastQueue = q.next;
                bfsVisited.putDirect(dname, bfsBaseEnc);
            }
            bfsBaseEnc = null;
        }
        return -1;
    }

    private static EConv openByTrascoderEntries(int n, Entry[] entries2) {
        EConv econv = new EConv(n);
        for (int i2 = 0; i2 < n; ++i2) {
            Transcoder transcoder = entries2[i2].getTranscoder();
            econv.addTranscoderAt(transcoder, econv.numTranscoders);
        }
        return econv;
    }

    private static EConv open0(byte[] source2, byte[] destination, int ecflags) {
        Entry[] entries2;
        int numTrans;
        if (source2.length == 0 && destination.length == 0) {
            numTrans = 0;
            entries2 = null;
        } else {
            final ObjPtr lentries = new ObjPtr();
            numTrans = TranscoderDB.searchPath(source2, destination, new SearchPathCallback(){
                int additional = 0;

                public void call(byte[] source2, byte[] destination, int depth) {
                    if (lentries.p == null) {
                        lentries.p = new Entry[depth + 1 + this.additional];
                    }
                    ((Entry[])lentries.p)[depth] = TranscoderDB.getEntry(source2, destination);
                }
            });
            entries2 = (Entry[])lentries.p;
        }
        EConv econv = TranscoderDB.openByTrascoderEntries(numTrans, entries2);
        econv.flags = ecflags;
        econv.source = source2;
        econv.destination = destination;
        return econv;
    }

    private static int decoratorNames(int ecflags, byte[][] decorators) {
        switch (ecflags & 0x3F00) {
            case 0: 
            case 256: 
            case 4096: 
            case 8192: {
                break;
            }
            default: {
                return -1;
            }
        }
        if ((ecflags & 0x4000) != 0 && (ecflags & 0x8000) != 0) {
            return -1;
        }
        int num = 0;
        if ((ecflags & 0x4000) != 0) {
            decorators[num++] = "xml_text_escape".getBytes();
        }
        if ((ecflags & 0x8000) != 0) {
            decorators[num++] = "xml_attr_content_escape".getBytes();
        }
        if ((ecflags & 0x100000) != 0) {
            decorators[num++] = "xml_attr_quote".getBytes();
        }
        if ((ecflags & 0x1000) != 0) {
            decorators[num++] = "crlf_newline".getBytes();
        }
        if ((ecflags & 0x2000) != 0) {
            decorators[num++] = "cr_newline".getBytes();
        }
        if ((ecflags & 0x100) != 0) {
            decorators[num] = "universal_newline".getBytes();
        }
        return num;
    }

    static EConv open(byte[] source2, byte[] destination, int ecflags) {
        byte[][] decorators = new byte[32][];
        int num = TranscoderDB.decoratorNames(ecflags, decorators);
        if (num == -1) {
            return null;
        }
        EConv econv = TranscoderDB.open0(source2, destination, ecflags & 0xFF);
        for (int i2 = 0; i2 < num; ++i2) {
            if (econv.decorateAtLast(decorators[i2])) continue;
            econv.close();
            return null;
        }
        econv.flags |= ecflags & 0xFFFFFF00;
        return econv;
    }

    static byte[] asciiCompatibleEncoding(byte[] asciiCompatName) {
        CaseInsensitiveBytesHash<Entry> dTable = transcoders.get(asciiCompatName);
        if (dTable == null || dTable.size() != 1) {
            return null;
        }
        byte[] asciiCN = null;
        for (Entry e : dTable) {
            Transcoder transcoder;
            if (EConv.decorator(e.source, e.destination) || (transcoder = e.getTranscoder()) == null || !transcoder.compatibility.isDecoder()) continue;
            asciiCN = transcoder.destination;
            break;
        }
        return asciiCN;
    }

    static {
        String[][] transList = TranscoderList.LIST;
        for (int i2 = 0; i2 < transList.length; ++i2) {
            String[] trans = transList[i2];
            TranscoderDB.declare(trans[0].getBytes(), trans[1].getBytes(), trans[2]);
        }
    }

    static interface SearchPathCallback {
        public void call(byte[] var1, byte[] var2, int var3);
    }

    static final class SearchPathQueue {
        ObjPtr<SearchPathQueue> next = new ObjPtr();
        byte[] encoding;

        SearchPathQueue() {
        }
    }

    public static final class Entry {
        private String transcoderClass;
        private final byte[] source;
        private final byte[] destination;
        private Transcoder transcoder;

        private Entry(byte[] source2, byte[] destination) {
            this.source = source2;
            this.destination = destination;
        }

        public byte[] getSource() {
            return this.source;
        }

        public byte[] getDestination() {
            return this.destination;
        }

        public Transcoder getTranscoder() {
            if (this.transcoder == null) {
                if (this.transcoderClass != null) {
                    this.transcoder = Transcoder.load(this.transcoderClass);
                } else {
                    Transcoder.GenericTranscoderEntry[] list2 = TranscoderList.GENERIC_LIST;
                    for (int i2 = 0; i2 < list2.length; ++i2) {
                        Transcoder.GenericTranscoderEntry entry = list2[i2];
                        if (!Arrays.equals(this.source, entry.source) || !Arrays.equals(this.destination, entry.destination)) continue;
                        this.transcoder = entry.createTranscoder();
                        break;
                    }
                }
            }
            return this.transcoder;
        }
    }
}

