/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NonLocalControlFlowNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class NextNode
extends Node
implements NonLocalControlFlowNode {
    private final Node valueNode;

    public NextNode(ISourcePosition position, Node valueNode) {
        super(position);
        assert (valueNode != null) : "valueNode is not null";
        this.valueNode = valueNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.NEXTNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitNextNode(this);
    }

    @Override
    public Node getValueNode() {
        return this.valueNode;
    }

    @Override
    public boolean hasValue() {
        return this.valueNode != NilImplicitNode.NIL;
    }

    @Override
    public List<Node> childNodes() {
        return NextNode.createList(this.valueNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        context.pollThreadEvents();
        throw new JumpException.NextJump(this.valueNode.interpret(runtime, context, self2, aBlock));
    }
}

