/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.ListNode;
import org.jruby.ast.MultipleAsgn19Node;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class AssignmentVisitor {
    @Deprecated
    public static IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self2, Node node, IRubyObject value2, Block block, boolean checkArity) {
        return node.assign(runtime, context, self2, value2, block, checkArity);
    }

    public static IRubyObject multiAssign(Ruby runtime, ThreadContext context, IRubyObject self2, MultipleAsgn19Node node, RubyArray value2, boolean checkArity) {
        int valueLen = value2.getLength();
        int varLen = node.getPreCount() + node.getPostCount();
        if (checkArity && varLen < valueLen) {
            throw runtime.newArgumentError("Wrong # of arguments (" + valueLen + " for " + varLen + ")");
        }
        int offset2 = 0;
        for (offset2 = 0; offset2 < node.getPreCount(); ++offset2) {
            if (offset2 >= valueLen) {
                node.getPre().get(offset2).assign(runtime, context, self2, runtime.getNil(), Block.NULL_BLOCK, false);
                continue;
            }
            node.getPre().get(offset2).assign(runtime, context, self2, value2.eltInternal(offset2), Block.NULL_BLOCK, false);
        }
        Node restArgument = node.getRest();
        if (restArgument != null) {
            int restLen = valueLen - varLen;
            if (restLen > 0) {
                restArgument.assign(runtime, context, self2, value2.subseqLight(offset2, restLen), Block.NULL_BLOCK, false);
                offset2 += restLen;
            } else {
                restArgument.assign(runtime, context, self2, RubyArray.newEmptyArray(runtime), Block.NULL_BLOCK, false);
            }
        }
        for (int i2 = 0; i2 < node.getPostCount(); ++i2) {
            if ((offset2 += i2) >= valueLen) {
                node.getPost().get(i2).assign(runtime, context, self2, runtime.getNil(), Block.NULL_BLOCK, false);
                continue;
            }
            node.getPost().get(i2).assign(runtime, context, self2, value2.eltInternal(offset2), Block.NULL_BLOCK, false);
        }
        return value2;
    }

    public static IRubyObject multiAssign(Ruby runtime, ThreadContext context, IRubyObject self2, MultipleAsgnNode node, RubyArray value2, boolean checkArity) {
        int j;
        int valueLen = value2.getLength();
        int varLen = node.getHeadNode() == null ? 0 : node.getHeadNode().size();
        for (j = 0; j < valueLen && j < varLen; ++j) {
            node.getHeadNode().get(j).assign(runtime, context, self2, value2.eltInternal(j), Block.NULL_BLOCK, checkArity);
        }
        if (checkArity && j < varLen) {
            throw runtime.newArgumentError("Wrong # of arguments (" + valueLen + " for " + varLen + ")");
        }
        Node argsNode = node.getArgsNode();
        if (argsNode != null) {
            if (argsNode.getNodeType() != NodeType.STARNODE) {
                if (varLen < valueLen) {
                    argsNode.assign(runtime, context, self2, value2.subseqLight(varLen, valueLen), Block.NULL_BLOCK, checkArity);
                } else {
                    argsNode.assign(runtime, context, self2, RubyArray.newEmptyArray(runtime), Block.NULL_BLOCK, checkArity);
                }
            }
        } else if (checkArity && valueLen < varLen) {
            throw runtime.newArgumentError("Wrong # of arguments (" + valueLen + " for " + varLen + ")");
        }
        while (j < varLen) {
            node.getHeadNode().get(j++).assign(runtime, context, self2, runtime.getNil(), Block.NULL_BLOCK, checkArity);
        }
        return value2;
    }

    public static IRubyObject multiAssign(Ruby runtime, ThreadContext context, IRubyObject self2, MultipleAsgn19Node node, RubyArray value2) {
        int j;
        int valueLen = value2.getLength();
        int postCount = node.getPostCount();
        int preCount = node.getPreCount();
        ListNode pre = node.getPre();
        ListNode post = node.getPost();
        for (j = 0; j < valueLen && j < preCount; ++j) {
            pre.get(j).assign(runtime, context, self2, value2.eltInternal(j), Block.NULL_BLOCK, false);
        }
        Node rest2 = node.getRest();
        if (rest2 != null) {
            if (rest2.getNodeType() != NodeType.STARNODE) {
                if (preCount + postCount < valueLen) {
                    rest2.assign(runtime, context, self2, value2.subseqLight(preCount, valueLen - preCount - postCount), Block.NULL_BLOCK, false);
                } else {
                    rest2.assign(runtime, context, self2, RubyArray.newEmptyArray(runtime), Block.NULL_BLOCK, false);
                }
            }
            int postIndexBase = valueLen - postCount;
            for (int i2 = 0; i2 < valueLen && i2 < postCount; ++i2) {
                post.get(i2).assign(runtime, context, self2, value2.eltInternal(i2 + postIndexBase), Block.NULL_BLOCK, false);
            }
        }
        while (j < preCount) {
            pre.get(j++).assign(runtime, context, self2, runtime.getNil(), Block.NULL_BLOCK, false);
        }
        return value2;
    }
}

