/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Arrays;
import java.util.Map;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RuntimeHelperCall
extends Instr
implements ResultInstr {
    Variable result;
    String helperMethod;
    Operand[] args;

    public RuntimeHelperCall(Variable result2, String helperMethod, Operand[] args2) {
        super(Operation.RUNTIME_HELPER);
        this.result = result2;
        this.helperMethod = helperMethod;
        this.args = args2;
    }

    @Override
    public Operand[] getOperands() {
        return this.args;
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        for (int i2 = 0; i2 < this.args.length; ++i2) {
            this.args[i2] = this.args[i2].getSimplifiedOperand(valueMap, force);
        }
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        Operand[] clonedArgs = new Operand[this.args.length];
        for (int i2 = 0; i2 < this.args.length; ++i2) {
            clonedArgs[i2++] = this.args[i2].cloneForInlining(ii);
        }
        Variable var = this.getResult();
        return new RuntimeHelperCall(var == null ? null : ii.getRenamedVariable(var), this.helperMethod, clonedArgs);
    }

    @Override
    public String toString() {
        return (this.getResult() == null ? "" : this.getResult() + " = ") + (Object)((Object)this.getOperation()) + "(" + this.helperMethod + ", " + Arrays.toString(this.args) + ")";
    }

    public IRubyObject callHelper(ThreadContext context, DynamicScope currDynScope, IRubyObject self2, Object[] temp, IRScope scope, Block.Type blockType) {
        Object exc = this.args[0].retrieve(context, self2, currDynScope, temp);
        if (this.helperMethod.equals("handlePropagatedBreak")) {
            return IRRuntimeHelpers.handlePropagatedBreak(context, scope, exc, blockType);
        }
        if (this.helperMethod.equals("handleNonlocalReturn")) {
            return IRRuntimeHelpers.handleNonlocalReturn(scope, exc, blockType);
        }
        if (this.helperMethod.equals("catchUncaughtBreakInLambdas")) {
            IRRuntimeHelpers.catchUncaughtBreakInLambdas(context, scope, exc, blockType);
            return null;
        }
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.RuntimeHelperCall(this);
    }
}

