/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CompiledBlockCallback19;
import org.jruby.runtime.ContextAwareBlockBody;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledBlock19
extends ContextAwareBlockBody {
    protected final CompiledBlockCallback19 callback;
    protected final boolean hasMultipleArgsHead;
    protected final String[] parameterList;
    private final boolean needsSplat;

    public static Block newCompiledClosure(ThreadContext context, IRubyObject self2, Arity arity2, StaticScope scope, CompiledBlockCallback19 callback, boolean hasMultipleArgsHead, int argumentType) {
        Binding binding2 = context.currentBinding(self2, Visibility.PUBLIC);
        CompiledBlock19 body = new CompiledBlock19(arity2, scope, callback, hasMultipleArgsHead, argumentType, EMPTY_PARAMETER_LIST);
        return new Block(body, binding2);
    }

    public static Block newCompiledClosure(ThreadContext context, IRubyObject self2, BlockBody body) {
        Binding binding2 = context.currentBinding(self2, Visibility.PUBLIC);
        return new Block(body, binding2);
    }

    public static BlockBody newCompiledBlock(Arity arity2, StaticScope scope, CompiledBlockCallback19 callback, boolean hasMultipleArgsHead, int argumentType, String[] parameterList) {
        return new CompiledBlock19(arity2, scope, callback, hasMultipleArgsHead, argumentType, parameterList);
    }

    public CompiledBlock19(Arity arity2, StaticScope scope, CompiledBlockCallback19 callback, boolean hasMultipleArgsHead, int argumentType, String[] parameterList) {
        super(scope, arity2, argumentType);
        this.callback = callback;
        this.hasMultipleArgsHead = hasMultipleArgsHead;
        this.parameterList = parameterList;
        this.needsSplat = Helpers.needsSplat19(this.arity().required(), !this.arity().isFixed());
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        return this.yield(context, this.newArgsArrayFromArgsWithUnbox(args2, context), null, null, true, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2, Block block) {
        return this.yield(context, this.newArgsArrayFromArgsWithoutUnbox(args2, context), null, null, true, binding2, type2, block);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, Binding binding2, Block.Type type2) {
        return this.yieldSpecificInternal(context, IRubyObject.NULL_ARRAY, binding2, type2);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        return this.yield(context, arg0, binding2, type2);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        return this.yieldSpecificInternal(context, new IRubyObject[]{arg0, arg1}, binding2, type2);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        return this.yieldSpecificInternal(context, new IRubyObject[]{arg0, arg1, arg2}, binding2, type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject yieldSpecificInternal(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        IRubyObject self2 = this.prepareSelf(binding2);
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, null, binding2);
        try {
            IRubyObject iRubyObject = this.callback.call(context, self2, args2, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject = this.handleNextJump(context, nj, type2);
            return iRubyObject;
        }
        finally {
            this.post(context, binding2, oldVis, lastFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        IRubyObject self2 = this.prepareSelf(binding2);
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, null, binding2);
        try {
            IRubyObject[] realArgs = this.setupBlockArg(context.runtime, value2, self2, type2);
            IRubyObject iRubyObject = this.callback.call(context, self2, realArgs, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject = this.handleNextJump(context, nj, type2);
            return iRubyObject;
        }
        finally {
            this.post(context, binding2, oldVis, lastFrame);
        }
    }

    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject args2, IRubyObject self2, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2) {
        return this.yield(context, args2, self2, klass, aValue, binding2, type2, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject args2, IRubyObject self2, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2, Block block) {
        if (klass == null) {
            self2 = this.prepareSelf(binding2);
        }
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, klass, binding2);
        try {
            IRubyObject[] realArgs = this.setupBlockArgs(args2, type2, aValue);
            IRubyObject iRubyObject = this.callback.call(context, self2, realArgs, block);
            return iRubyObject;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject = this.handleNextJump(context, nj, type2);
            return iRubyObject;
        }
        finally {
            this.post(context, binding2, oldVis, lastFrame);
        }
    }

    private IRubyObject prepareSelf(Binding binding2) {
        IRubyObject self2 = binding2.getSelf();
        binding2.getFrame().setSelf(self2);
        return self2;
    }

    private IRubyObject handleNextJump(ThreadContext context, JumpException.NextJump nj, Block.Type type2) {
        return nj.getValue() == null ? context.runtime.getNil() : (IRubyObject)nj.getValue();
    }

    private IRubyObject[] setupBlockArg(Ruby ruby2, IRubyObject value2, IRubyObject self2, Block.Type type2) {
        return this.setupBlockArgs(value2, type2, false);
    }

    private IRubyObject[] setupBlockArgs(IRubyObject value2, Block.Type type2, boolean alreadyArray) {
        return Helpers.restructureBlockArgs19(value2, this.arity(), type2, this.needsSplat, alreadyArray);
    }

    @Override
    public String getFile() {
        return this.callback.getFile();
    }

    @Override
    public int getLine() {
        return this.callback.getLine();
    }

    @Override
    public String[] getParameterList() {
        return this.parameterList;
    }
}

