/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jruby.RubyModule;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.WeakIdentityHashMap;

public class ObjectSpace {
    private final ReferenceQueue<Object> deadReferences = new ReferenceQueue();
    private final ReferenceQueue<ObjectGroup> objectGroupReferenceQueue = new ReferenceQueue();
    private WeakReferenceListNode top;
    private ReferenceQueue deadIdentityReferences = new ReferenceQueue();
    private final Map identities = new HashMap();
    private final Map identitiesByObject = new WeakIdentityHashMap();
    private static final AtomicLong maxId = new AtomicLong(1000L);
    private final ThreadLocal<Reference<ObjectGroup>> currentObjectGroup = new ThreadLocal();
    private Reference<GroupSweeper> groupSweeperReference;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObjectId(long id2, IRubyObject object) {
        Map map = this.identities;
        synchronized (map) {
            this.cleanIdentities();
            this.identities.put(id2, new IdReference(object, id2, this.deadIdentityReferences));
            this.identitiesByObject.put(object, id2);
        }
    }

    public static long calculateObjectId(Object object) {
        return maxId.getAndIncrement() * 2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createAndRegisterObjectId(IRubyObject rubyObject) {
        Map map = this.identities;
        synchronized (map) {
            Long longId = (Long)this.identitiesByObject.get(rubyObject);
            if (longId == null) {
                longId = this.createId(rubyObject);
            }
            return longId;
        }
    }

    private long createId(IRubyObject object) {
        long id2 = ObjectSpace.calculateObjectId(object);
        this.registerObjectId(id2, object);
        return id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject id2ref(long id2) {
        Map map = this.identities;
        synchronized (map) {
            this.cleanIdentities();
            IdReference reference2 = (IdReference)this.identities.get(id2);
            if (reference2 == null) {
                return null;
            }
            return (IRubyObject)reference2.get();
        }
    }

    private void cleanIdentities() {
        IdReference ref;
        while ((ref = (IdReference)this.deadIdentityReferences.poll()) != null) {
            this.identities.remove(ref.id());
        }
    }

    @Deprecated
    public long idOf(IRubyObject rubyObject) {
        return this.createAndRegisterObjectId(rubyObject);
    }

    public void addFinalizer(IRubyObject object, IRubyObject proc2) {
        object.addFinalizer(proc2);
    }

    public void removeFinalizers(long id2) {
        IRubyObject object = this.id2ref(id2);
        if (object != null) {
            object.removeFinalizers();
        }
    }

    public void add(IRubyObject object) {
        if (object.getMetaClass() != null && !(object instanceof JavaProxy)) {
            this.getObjectGroup().add(object);
        } else {
            this.addIndividualWeakReference(object);
        }
    }

    private synchronized void addIndividualWeakReference(IRubyObject object) {
        this.cleanup(this.deadReferences);
        this.top = new WeakReferenceListNode<Object>(object, this.deadReferences, this.top);
    }

    private synchronized void registerGroupSweeper() {
        if (this.groupSweeperReference == null || this.groupSweeperReference.get() == null) {
            this.groupSweeperReference = new WeakReference<GroupSweeper>(new GroupSweeper());
        }
    }

    private synchronized void splitObjectGroups() {
        this.cleanup(this.objectGroupReferenceQueue);
        WeakReferenceListNode node = this.top;
        while (node != null) {
            Object obj = node.get();
            if (obj instanceof ObjectGroup) {
                ObjectGroup objectGroup = (ObjectGroup)obj;
                for (int i2 = 0; i2 < objectGroup.size(); ++i2) {
                    IRubyObject rubyObject = objectGroup.set(i2, null);
                    if (rubyObject == null) continue;
                    this.top = new WeakReferenceListNode<Object>(rubyObject, this.deadReferences, this.top);
                }
            }
            node = node.nextNode;
        }
    }

    public synchronized Iterator iterator(RubyModule rubyClass) {
        final ArrayList<WeakReference<IRubyObject>> objList = new ArrayList<WeakReference<IRubyObject>>();
        WeakReferenceListNode current2 = this.top;
        while (current2 != null) {
            Object obj = current2.get();
            if (obj instanceof IRubyObject) {
                IRubyObject rubyObject = (IRubyObject)current2.get();
                if (rubyObject != null && rubyClass.isInstance(rubyObject)) {
                    objList.add(current2);
                }
            } else if (obj instanceof ObjectGroup) {
                for (IRubyObject rubyObject : (ObjectGroup)obj) {
                    if (rubyObject == null || !rubyClass.isInstance(rubyObject)) continue;
                    objList.add(new WeakReference<IRubyObject>(rubyObject));
                }
            }
            current2 = current2.nextNode;
        }
        return new Iterator(){
            private Iterator<Reference<Object>> iter;
            {
                this.iter = objList.iterator();
            }

            @Override
            public boolean hasNext() {
                throw new UnsupportedOperationException();
            }

            public Object next() {
                Object obj = null;
                while (this.iter.hasNext() && (obj = this.iter.next().get()) == null) {
                }
                return obj;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void cleanup(ReferenceQueue<?> referenceQueue) {
        WeakReferenceListNode reference2;
        while ((reference2 = (WeakReferenceListNode)referenceQueue.poll()) != null) {
            reference2.remove();
        }
    }

    private ObjectGroup getObjectGroup() {
        Reference<ObjectGroup> ref = this.currentObjectGroup.get();
        ObjectGroup objectGroup = ref != null ? ref.get() : null;
        return objectGroup != null && !objectGroup.isFull() ? objectGroup : this.addObjectGroup();
    }

    private synchronized ObjectGroup addObjectGroup() {
        this.cleanup(this.objectGroupReferenceQueue);
        ObjectGroup objectGroup = new ObjectGroup();
        WeakReferenceListNode<ObjectGroup> ref = new WeakReferenceListNode<ObjectGroup>(objectGroup, this.objectGroupReferenceQueue, this.top);
        this.currentObjectGroup.set(ref);
        this.top = ref;
        if (this.groupSweeperReference == null) {
            this.registerGroupSweeper();
        }
        return objectGroup;
    }

    private final class GroupSweeper {
        private GroupSweeper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                ObjectSpace.this.splitObjectGroups();
            }
            finally {
                ObjectSpace.this.registerGroupSweeper();
                super.finalize();
            }
        }
    }

    private static final class ObjectGroup
    extends AbstractList<IRubyObject> {
        private static final int MAX_OBJECTS_PER_GROUP = 64;
        private final AtomicReferenceArray<IRubyObject> objects = new AtomicReferenceArray(64);
        private int nextIndex = 0;

        private ObjectGroup() {
        }

        @Override
        public boolean add(IRubyObject obj) {
            obj.getMetaClass().getRealClass().getObjectGroupAccessorField().getVariableAccessorForWrite().set(obj, this);
            this.objects.set(this.nextIndex, obj);
            ++this.nextIndex;
            return true;
        }

        @Override
        public IRubyObject get(int index2) {
            return this.objects.get(index2);
        }

        @Override
        public IRubyObject set(int index2, IRubyObject element) {
            return this.objects.getAndSet(index2, element);
        }

        private boolean isFull() {
            return this.nextIndex >= this.objects.length();
        }

        @Override
        public int size() {
            return this.objects.length();
        }
    }

    private static class IdReference
    extends WeakReference {
        private final long id;

        public IdReference(IRubyObject object, long id2, ReferenceQueue queue) {
            super(object, queue);
            this.id = id2;
        }

        public long id() {
            return this.id;
        }
    }

    private class WeakReferenceListNode<T>
    extends WeakReference<T> {
        private WeakReferenceListNode prevNode;
        private WeakReferenceListNode nextNode;

        public WeakReferenceListNode(T referent, ReferenceQueue<T> queue, WeakReferenceListNode<?> next2) {
            super(referent, queue);
            this.nextNode = next2;
            if (next2 != null) {
                next2.prevNode = this;
            }
        }

        private void remove() {
            if (this.prevNode != null) {
                this.prevNode.nextNode = this.nextNode;
            } else {
                ObjectSpace.this.top = this.nextNode;
            }
            if (this.nextNode != null) {
                this.nextNode.prevNode = this.prevNode;
            }
        }
    }
}

