/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;

public class SimpleSampler {
    private static final Map<ThreadContext, Object> CURRENT = new WeakHashMap<ThreadContext, Object>();
    private static final Map<String, Integer> SAMPLES = new HashMap<String, Integer>();
    private static final List<List<String>> TRACES = new ArrayList<List<String>>();
    private static boolean reported = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerThreadContext(ThreadContext tc) {
        Map<ThreadContext, Object> map = CURRENT;
        synchronized (map) {
            CURRENT.put(tc, null);
        }
    }

    public static void startSampleThread() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SimpleSampler.runSampling();
            }
        }).start();
    }

    public static void report() {
        if (!reported) {
            System.err.println();
            System.err.println("Samples - ");
            ArrayList<String> samples = new ArrayList<String>();
            samples.addAll(SAMPLES.keySet());
            Collections.sort(samples, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return (Integer)SAMPLES.get(o2) - (Integer)SAMPLES.get(o1);
                }
            });
            for (List<String> ls : TRACES) {
                if (ls.size() <= 1) continue;
                System.err.println("Trace #" + System.identityHashCode(ls));
                for (String ss : ls) {
                    System.err.println("  " + ss);
                }
                System.err.println();
            }
            String BLANKS = "                                                            ";
            for (String ss : samples) {
                int len = Math.max(60 - ss.length(), 0);
                System.err.println(" " + ss + BLANKS.substring(0, len) + "==> " + SAMPLES.get(ss));
            }
            reported = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runSampling() {
        long interval = Long.parseLong(System.getProperty("jruby.sampling.interval", "10"));
        int depth = Integer.parseInt(System.getProperty("jruby.sampling.depth", "5"));
        System.err.println("[Sampling with");
        System.err.println(" - interval: " + interval);
        System.err.println(" - depth: " + depth + "]");
        Map<ThreadContext, Object> map = CURRENT;
        synchronized (map) {
            while (!reported) {
                try {
                    CURRENT.wait(interval);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    for (ThreadContext tc : CURRENT.keySet()) {
                        Frame[] frames;
                        if (tc == null || (frames = tc.createBacktrace(1, false)) == null) continue;
                        ArrayList<String> trace = new ArrayList<String>(depth);
                        for (int i2 = Math.max(frames.length - depth, 0); i2 < frames.length; ++i2) {
                            Frame f = frames[i2];
                            String name2 = f.getKlazz() + "#" + f.getName();
                            if (f.isBindingFrame() || name2.equals("null#null")) continue;
                            trace.add(name2);
                            Integer v = SAMPLES.get(name2);
                            if (v == null) {
                                v = 1;
                            } else {
                                Integer n = v;
                                Integer n2 = v = Integer.valueOf(v + 1);
                            }
                            SAMPLES.put(name2, v);
                        }
                        TRACES.add(trace);
                    }
                }
                catch (Exception e) {
                }
            }
        }
    }
}

