/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.RubyHash;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public final class XMLConverter {
    private static final XMLCharacterTranslator XML_TEXT_TRANSLATOR = new XMLTextCharacterTranslator();
    private static final XMLCharacterTranslator XML_ATTR_TRANSLATOR = new XMLAttrCharacterTranslator();

    private XMLConverter() {
    }

    public static void checkOptions(ThreadContext context, IRubyObject options2) {
        IRubyObject xmlOption;
        RubyHash hash2 = (RubyHash)options2;
        if (!(context.runtime.is1_8() || (xmlOption = hash2.fastARef(context.runtime.newSymbol("xml"))) == null || xmlOption.op_equal(context, context.runtime.newSymbol("attr")).isTrue() || xmlOption.op_equal(context, context.runtime.newSymbol("text")).isTrue())) {
            throw context.runtime.newArgumentError("unexpected value for xml option: " + xmlOption.asString());
        }
    }

    public static ByteList convert(ThreadContext context, ByteList input, IRubyObject options2) {
        XMLConverter.checkOptions(context, options2);
        RubyHash hash2 = (RubyHash)options2;
        IRubyObject xmlOption = hash2.fastARef(context.runtime.newSymbol("xml"));
        String stringInput = context.runtime.newString(input).asJavaString();
        String stringOutput = xmlOption.op_equal(context, context.runtime.newSymbol("attr")).isTrue() ? XML_ATTR_TRANSLATOR.translate(stringInput) : XML_TEXT_TRANSLATOR.translate(stringInput);
        return new ByteList(stringOutput.getBytes());
    }

    static class XMLAttrCharacterTranslator
    extends XMLTextCharacterTranslator {
        XMLAttrCharacterTranslator() {
        }

        @Override
        public String[] table() {
            return new String[]{"&", "&amp;", "<", "&lt;", ">", "&gt;", "\"", "&quot;"};
        }

        @Override
        public String translate(String input) {
            return "\"" + super.translate(input) + "\"";
        }
    }

    static class XMLTextCharacterTranslator
    extends XMLCharacterTranslator {
        XMLTextCharacterTranslator() {
        }

        @Override
        public String[] table() {
            return new String[]{"&", "&amp;", "<", "&lt;", ">", "&gt;"};
        }
    }

    static abstract class XMLCharacterTranslator
    implements CharacterTranslator {
        XMLCharacterTranslator() {
        }

        abstract String[] table();

        @Override
        public String translate(String input) {
            String output = input;
            for (int i2 = 0; i2 < this.table().length; i2 += 2) {
                output = output.replace(this.table()[i2], this.table()[i2 + 1]);
            }
            return output;
        }
    }

    static interface CharacterTranslator {
        public String translate(String var1);
    }
}

