/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.ast;

import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.AbstractBlock;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.BlockImpl;
import org.asciidoctor.ast.DocumentRuby;
import org.asciidoctor.ast.Section;
import org.asciidoctor.ast.SectionImpl;
import org.asciidoctor.internal.RubyHashUtil;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyObject;

public class AbstractBlockImpl
implements AbstractBlock {
    private static final String BLOCK_CLASS = "Block";
    private static final String SECTION_CLASS = "Section";
    protected AbstractBlock delegate;
    protected Ruby runtime;

    public AbstractBlockImpl(AbstractBlock blockDelegate, Ruby runtime) {
        this.delegate = blockDelegate;
        this.runtime = runtime;
    }

    @Override
    public String id() {
        return this.delegate.id();
    }

    @Override
    public String title() {
        return this.delegate.title();
    }

    @Override
    public String role() {
        return this.delegate.role();
    }

    @Override
    public String style() {
        return this.delegate.style();
    }

    @Override
    public List<AbstractBlock> blocks() {
        List<AbstractBlock> rubyBlocks = this.delegate.blocks();
        for (int i2 = 0; i2 < rubyBlocks.size(); ++i2) {
            AbstractBlock abstractBlock = rubyBlocks.get(i2);
            if (abstractBlock instanceof RubyArray || abstractBlock instanceof Block) continue;
            RubyObject rubyObject = (RubyObject)((Object)abstractBlock);
            rubyBlocks.set(i2, this.overrideRubyObjectToJavaObject(rubyObject));
        }
        return rubyBlocks;
    }

    @Override
    public Map<String, Object> attributes() {
        return this.delegate.attributes();
    }

    @Override
    public Object content() {
        return this.delegate.content();
    }

    @Override
    public String convert() {
        return this.delegate.convert();
    }

    @Override
    public String context() {
        return this.delegate.context();
    }

    @Override
    public AbstractBlock delegate() {
        return this.delegate;
    }

    @Override
    public DocumentRuby document() {
        return this.delegate.document();
    }

    @Override
    public List<AbstractBlock> findBy(Map<Object, Object> selector) {
        List<AbstractBlock> findBy = this.delegate.findBy(RubyHashUtil.convertMapToRubyHashWithSymbolsIfNecessary(this.runtime, selector));
        for (int i2 = 0; i2 < findBy.size(); ++i2) {
            AbstractBlock abstractBlock = findBy.get(i2);
            if (abstractBlock instanceof RubyArray || abstractBlock instanceof AbstractBlock) continue;
            RubyObject rubyObject = (RubyObject)((Object)abstractBlock);
            findBy.set(i2, this.overrideRubyObjectToJavaObject(rubyObject));
        }
        return findBy;
    }

    private AbstractBlock overrideRubyObjectToJavaObject(RubyObject rubyObject) {
        if (BLOCK_CLASS.equals(rubyObject.getMetaClass().getBaseName())) {
            Block blockRuby = RubyUtils.rubyToJava(this.runtime, rubyObject, Block.class);
            return new BlockImpl(blockRuby, this.runtime);
        }
        if (SECTION_CLASS.equals(rubyObject.getMetaClass().getBaseName())) {
            Section blockRuby = RubyUtils.rubyToJava(this.runtime, rubyObject, Section.class);
            return new SectionImpl(blockRuby, this.runtime);
        }
        AbstractBlock blockRuby = RubyUtils.rubyToJava(this.runtime, rubyObject, AbstractBlock.class);
        return new AbstractBlockImpl(blockRuby, this.runtime);
    }
}

