/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.extension;

import java.util.HashMap;
import java.util.Map;
import org.asciidoctor.extension.MacroProcessor;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.RubyRegexp;
import org.jruby.util.RegexpOptions;

public abstract class InlineMacroProcessor
extends MacroProcessor {
    protected RubyRegexp regexp;

    public InlineMacroProcessor(String macroName) {
        this(macroName, new HashMap<String, Object>());
    }

    public InlineMacroProcessor(String macroName, Map<String, Object> config) {
        super(macroName, config);
        this.regexp = config.containsKey("regexp") ? this.convertRegexp(config.get("regexp")) : this.resolveRegexp(macroName, (String)config.get("format"));
        this.config.put(RubyUtils.toSymbol(this.rubyRuntime, "regexp"), this.regexp);
    }

    private RubyRegexp convertRegexp(Object regexp2) {
        return RubyRegexp.newRegexp(this.rubyRuntime, regexp2.toString(), RegexpOptions.NULL_OPTIONS);
    }

    public RubyRegexp resolveRegexp(String macroName, String format) {
        String maybe = "?";
        String or = "|";
        String lit_backslash = "\\\\";
        String open_bracket = "\\[";
        String close_bracket = "\\]";
        String esc_close_bracket = lit_backslash + close_bracket;
        String not_close_bracket = "^" + close_bracket;
        String not_whitespace = "\\S+?";
        if ("short".equals(format)) {
            return this.convertRegexp(lit_backslash + maybe + macroName + ":" + open_bracket + "((?:" + esc_close_bracket + or + "[" + not_close_bracket + "]" + ")*?)" + close_bracket);
        }
        return this.convertRegexp(lit_backslash + maybe + macroName + ":" + "(" + not_whitespace + ")" + open_bracket + "((?:" + esc_close_bracket + or + "[" + not_close_bracket + "]" + ")*?)" + close_bracket);
    }

    public RubyRegexp getRegexp() {
        return this.regexp;
    }
}

