/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.asciidoctor.internal.IOUtils;
import org.jruby.Ruby;
import org.jruby.RubyRuntimeAdapter;
import org.jruby.RubyString;

public class DefaultCssResolver {
    private static final String ASCIIDCOTOR_CSS_NAME = "asciidoctor.css";
    private static final String STYLESHEETS_ASCIIDOCTOR_CSS = "stylesheets/asciidoctor.css";
    private Ruby runtime;
    private RubyRuntimeAdapter evaler;
    private String defaultCssContent = null;

    public DefaultCssResolver(Ruby runtime, RubyRuntimeAdapter evaler) {
        this.runtime = runtime;
        this.evaler = evaler;
    }

    public void treatCopyCssAttribute(File currentDirectory, Map<String, Object> options2) {
        String content = this.loadContent();
        try {
            File destinationDirectory = this.getDestinationDirectory(currentDirectory, options2);
            this.writeContent(destinationDirectory, content);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isCopyCssActionRequired(Map<String, Object> options2) {
        Map attributes = (Map)options2.get("attributes");
        return attributes != null && this.isCopyCssPresent(attributes) && this.isLinkCssWithValidValue(attributes) && this.isStylesheetWithValidValue(attributes);
    }

    private boolean isStylesheetWithValidValue(Map<String, Object> attributes) {
        return this.isAttributeNotConfirmed(attributes, "stylesheet") || "".equals(attributes.get("stylesheet")) || "DEFAULT".equals(attributes.get("stylesheet"));
    }

    private boolean isLinkCssWithValidValue(Map<String, Object> attributes) {
        return this.isAttributeNotConfirmed(attributes, "linkcss") || "".equals(attributes.get("linkcss"));
    }

    private boolean isCopyCssPresent(Map<String, Object> attributes) {
        return "".equals(attributes.get("copycss"));
    }

    private boolean isAttributeNotConfirmed(Map<String, Object> attributes, String attribute) {
        return !attributes.containsKey(attribute) && !attributes.containsKey(attribute + "!");
    }

    private File getDestinationDirectory(File currentDirectory, Map<String, Object> options2) {
        if ("".equals(options2.get("in_place"))) {
            return currentDirectory;
        }
        if (options2.containsKey("to_file")) {
            File toFile = new File((String)options2.get("to_file"));
            if (toFile.isAbsolute()) {
                return toFile.getParentFile();
            }
            if (options2.containsKey("to_dir")) {
                File toDir = new File((String)options2.get("to_dir"));
                return new File(toDir, toFile.getParent());
            }
            return new File(currentDirectory, toFile.getParent());
        }
        if (options2.containsKey("to_dir")) {
            return new File((String)options2.get("to_dir"));
        }
        return currentDirectory;
    }

    private void writeContent(File directory, String content) throws IOException {
        File fullPath = new File(directory, ASCIIDCOTOR_CSS_NAME);
        IOUtils.writeFull(new FileWriter(fullPath), content);
    }

    private String loadContent() {
        if (this.defaultCssContent == null) {
            InputStream defaultCssInputStream = DefaultCssResolver.class.getResourceAsStream(this.cssClasspathLocation());
            this.defaultCssContent = IOUtils.readFull(defaultCssInputStream);
        }
        return this.defaultCssContent;
    }

    private String cssClasspathLocation() {
        return "/" + this.gemClasspath() + "/" + STYLESHEETS_ASCIIDOCTOR_CSS;
    }

    private String gemClasspath() {
        RubyString gemLocationRubyObject = (RubyString)this.evaler.eval(this.runtime, "Gem.loaded_specs['asciidoctor'].full_gem_path");
        String gemLocation = gemLocationRubyObject.asJavaString();
        return gemLocation.substring(gemLocation.indexOf("gems"), gemLocation.length());
    }
}

