/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.DirectoryWalker;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.ast.AbstractBlock;
import org.asciidoctor.ast.ContentPart;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.DocumentHeader;
import org.asciidoctor.ast.DocumentRuby;
import org.asciidoctor.ast.StructuredDocument;
import org.asciidoctor.ast.Title;
import org.asciidoctor.extension.JavaExtensionRegistry;
import org.asciidoctor.extension.RubyExtensionRegistry;
import org.asciidoctor.extension.internal.ExtensionRegistryExecutor;
import org.asciidoctor.internal.AsciidoctorModule;
import org.asciidoctor.internal.AsciidoctorUtils;
import org.asciidoctor.internal.EnvironmentInjector;
import org.asciidoctor.internal.IOUtils;
import org.asciidoctor.internal.JRubyAsciidoctorModuleFactory;
import org.asciidoctor.internal.JRubyRuntimeContext;
import org.asciidoctor.internal.RubyGemsPreloader;
import org.asciidoctor.internal.RubyHashUtil;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.ScriptingContainer;
import org.jruby.javasupport.JavaEmbedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRubyAsciidoctor
implements Asciidoctor {
    private static final Logger log = LoggerFactory.getLogger(JRubyAsciidoctor.class.getName());
    private static final String GEM_PATH = "GEM_PATH";
    private static final int DEFAULT_MAX_LEVEL = 1;
    private AsciidoctorModule asciidoctorModule;
    protected RubyGemsPreloader rubyGemsPreloader;
    protected Ruby rubyRuntime;

    private JRubyAsciidoctor(AsciidoctorModule asciidoctorModule, Ruby rubyRuntime) {
        this.asciidoctorModule = asciidoctorModule;
        this.rubyRuntime = rubyRuntime;
        this.rubyGemsPreloader = new RubyGemsPreloader(this.rubyRuntime);
    }

    public static Asciidoctor create() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        Asciidoctor asciidoctor = JRubyAsciidoctor.createJRubyAsciidoctorInstance(env);
        JRubyAsciidoctor.registerExtensions(asciidoctor);
        return asciidoctor;
    }

    public static Asciidoctor create(String gemPath) {
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put(GEM_PATH, gemPath);
        Asciidoctor asciidoctor = JRubyAsciidoctor.createJRubyAsciidoctorInstance(env);
        JRubyAsciidoctor.registerExtensions(asciidoctor);
        return asciidoctor;
    }

    public static Asciidoctor create(List<String> loadPaths) {
        Asciidoctor asciidoctor = JRubyAsciidoctor.createJRubyAsciidoctorInstance(loadPaths);
        JRubyAsciidoctor.registerExtensions(asciidoctor);
        return asciidoctor;
    }

    public static Asciidoctor create(ClassLoader classloader) {
        Asciidoctor asciidoctor = JRubyAsciidoctor.createJRubyAsciidoctorInstance(classloader);
        JRubyAsciidoctor.registerExtensions(asciidoctor);
        return asciidoctor;
    }

    private static void registerExtensions(Asciidoctor asciidoctor) {
        new ExtensionRegistryExecutor(asciidoctor).registerAllExtensions();
    }

    private static Asciidoctor createJRubyAsciidoctorInstance(List<String> loadPaths) {
        RubyInstanceConfig config = JRubyAsciidoctor.createOptimizedConfiguration();
        Ruby rubyRuntime = JavaEmbedUtils.initialize(loadPaths, config);
        JRubyRuntimeContext.set(rubyRuntime);
        JRubyAsciidoctorModuleFactory jRubyAsciidoctorModuleFactory = new JRubyAsciidoctorModuleFactory(rubyRuntime);
        AsciidoctorModule asciidoctorModule = jRubyAsciidoctorModuleFactory.createAsciidoctorModule();
        JRubyAsciidoctor jRubyAsciidoctor = new JRubyAsciidoctor(asciidoctorModule, rubyRuntime);
        return jRubyAsciidoctor;
    }

    private static Asciidoctor createJRubyAsciidoctorInstance(Map<String, Object> environmentVars) {
        RubyInstanceConfig config = JRubyAsciidoctor.createOptimizedConfiguration();
        JRubyAsciidoctor.injectEnvironmentVariables(config, environmentVars);
        Ruby rubyRuntime = JavaEmbedUtils.initialize(Collections.EMPTY_LIST, config);
        JRubyRuntimeContext.set(rubyRuntime);
        JRubyAsciidoctorModuleFactory jRubyAsciidoctorModuleFactory = new JRubyAsciidoctorModuleFactory(rubyRuntime);
        AsciidoctorModule asciidoctorModule = jRubyAsciidoctorModuleFactory.createAsciidoctorModule();
        JRubyAsciidoctor jRubyAsciidoctor = new JRubyAsciidoctor(asciidoctorModule, rubyRuntime);
        return jRubyAsciidoctor;
    }

    private static Asciidoctor createJRubyAsciidoctorInstance(ClassLoader classloader) {
        ScriptingContainer container = new ScriptingContainer();
        container.setClassLoader(classloader);
        Ruby rubyRuntime = container.getProvider().getRuntime();
        JRubyRuntimeContext.set(rubyRuntime);
        JRubyAsciidoctorModuleFactory jRubyAsciidoctorModuleFactory = new JRubyAsciidoctorModuleFactory(rubyRuntime);
        AsciidoctorModule asciidoctorModule = jRubyAsciidoctorModuleFactory.createAsciidoctorModule();
        JRubyAsciidoctor jRubyAsciidoctor = new JRubyAsciidoctor(asciidoctorModule, rubyRuntime);
        return jRubyAsciidoctor;
    }

    private static void injectEnvironmentVariables(RubyInstanceConfig config, Map<String, Object> environmentVars) {
        EnvironmentInjector environmentInjector = new EnvironmentInjector(config);
        environmentInjector.inject(environmentVars);
    }

    private static RubyInstanceConfig createOptimizedConfiguration() {
        RubyInstanceConfig config = new RubyInstanceConfig();
        config.setCompatVersion(CompatVersion.RUBY2_0);
        config.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
        return config;
    }

    private DocumentHeader toDocumentHeader(DocumentRuby documentRuby) {
        HashMap<Object, Object> opts = new HashMap<Object, Object>();
        opts.put("partition", true);
        Document document = new Document(documentRuby, this.rubyRuntime);
        return DocumentHeader.createDocumentHeader((Title)document.doctitle(opts), documentRuby.title(), documentRuby.getAttributes());
    }

    private StructuredDocument toDocument(DocumentRuby documentRuby, Ruby rubyRuntime, int maxDeepLevel) {
        Document document = new Document(documentRuby, rubyRuntime);
        List<ContentPart> contentParts = this.getContents(document.blocks(), 1, maxDeepLevel);
        return StructuredDocument.createStructuredDocument(this.toDocumentHeader(documentRuby), contentParts);
    }

    private List<ContentPart> getContents(List<AbstractBlock> blocks2, int level2, int maxDeepLevel) {
        if (level2 > maxDeepLevel) {
            return null;
        }
        ArrayList<ContentPart> parts = new ArrayList<ContentPart>();
        for (AbstractBlock block : blocks2) {
            parts.add(this.getContentPartFromBlock(block, level2, maxDeepLevel));
        }
        return parts;
    }

    private ContentPart getContentPartFromBlock(AbstractBlock child, int level2, int maxDeepLevel) {
        Object content = child.content();
        String textContent = content instanceof String ? (String)content : child.convert();
        ContentPart contentPart = ContentPart.createContentPart(child.id(), level2, child.context(), child.title(), child.style(), child.role(), child.attributes(), textContent);
        contentPart.setParts(this.getContents(child.blocks(), level2 + 1, maxDeepLevel));
        return contentPart;
    }

    @Override
    public StructuredDocument readDocumentStructure(File filename2, Map<String, Object> options2) {
        this.rubyGemsPreloader.preloadRequiredLibraries(options2);
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options2);
        DocumentRuby documentRuby = this.asciidoctorModule.load_file(filename2.getAbsolutePath(), rubyHash);
        int maxDeepLevel = options2.containsKey("STRUCTURE_MAX_LEVEL") ? (Integer)options2.get("STRUCTURE_MAX_LEVEL") : 1;
        return this.toDocument(documentRuby, this.rubyRuntime, maxDeepLevel);
    }

    @Override
    public StructuredDocument readDocumentStructure(String content, Map<String, Object> options2) {
        this.rubyGemsPreloader.preloadRequiredLibraries(options2);
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options2);
        DocumentRuby documentRuby = this.asciidoctorModule.load(content, rubyHash);
        int maxDeepLevel = options2.containsKey("STRUCTURE_MAX_LEVEL") ? (Integer)options2.get("STRUCTURE_MAX_LEVEL") : 1;
        return this.toDocument(documentRuby, this.rubyRuntime, maxDeepLevel);
    }

    @Override
    public StructuredDocument readDocumentStructure(Reader contentReader, Map<String, Object> options2) {
        String content = IOUtils.readFull(contentReader);
        return this.readDocumentStructure(content, options2);
    }

    @Override
    public DocumentHeader readDocumentHeader(File filename2) {
        RubyHash rubyHash = this.getParseHeaderOnlyOption();
        DocumentRuby documentRuby = this.asciidoctorModule.load_file(filename2.getAbsolutePath(), rubyHash);
        return this.toDocumentHeader(documentRuby);
    }

    @Override
    public DocumentHeader readDocumentHeader(String content) {
        RubyHash rubyHash = this.getParseHeaderOnlyOption();
        DocumentRuby documentRuby = this.asciidoctorModule.load(content, rubyHash);
        return this.toDocumentHeader(documentRuby);
    }

    @Override
    public DocumentHeader readDocumentHeader(Reader contentReader) {
        String content = IOUtils.readFull(contentReader);
        return this.readDocumentHeader(content);
    }

    private RubyHash getParseHeaderOnlyOption() {
        HashMap<String, Object> options2 = new HashMap<String, Object>();
        options2.put("parse_header_only", true);
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options2);
        return rubyHash;
    }

    @Override
    @Deprecated
    public String render(String content, Map<String, Object> options2) {
        this.rubyGemsPreloader.preloadRequiredLibraries(options2);
        if (log.isDebugEnabled()) {
            log.debug(AsciidoctorUtils.toAsciidoctorCommand(options2, "-"));
            if (AsciidoctorUtils.isOptionWithAttribute(options2, "source-highlighter", "pygments")) {
                log.debug("In order to use Pygments with Asciidoctor, you need to install Pygments (and Python, if you don\u2019t have it yet). Read http://asciidoctor.org/news/#syntax-highlighting-with-pygments.");
            }
        }
        String currentDirectory = this.rubyRuntime.getCurrentDirectory();
        if (options2.containsKey("base_dir")) {
            this.rubyRuntime.setCurrentDirectory((String)options2.get("base_dir"));
        }
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options2);
        Object object = this.asciidoctorModule.convert(content, rubyHash);
        this.rubyRuntime.setCurrentDirectory(currentDirectory);
        return this.returnExpectedValue(object);
    }

    @Override
    @Deprecated
    public String renderFile(File filename2, Map<String, Object> options2) {
        this.rubyGemsPreloader.preloadRequiredLibraries(options2);
        if (log.isDebugEnabled()) {
            log.debug(AsciidoctorUtils.toAsciidoctorCommand(options2, filename2.getAbsolutePath()));
        }
        String currentDirectory = this.rubyRuntime.getCurrentDirectory();
        if (options2.containsKey("base_dir")) {
            this.rubyRuntime.setCurrentDirectory((String)options2.get("base_dir"));
        }
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options2);
        Object object = this.asciidoctorModule.convertFile(filename2.getAbsolutePath(), rubyHash);
        this.rubyRuntime.setCurrentDirectory(currentDirectory);
        return this.returnExpectedValue(object);
    }

    private String returnExpectedValue(Object object) {
        if (object instanceof String) {
            return object.toString();
        }
        return null;
    }

    @Override
    @Deprecated
    public void render(Reader contentReader, Writer rendererWriter, Map<String, Object> options2) throws IOException {
        String content = IOUtils.readFull(contentReader);
        String renderedContent = this.render(content, options2);
        IOUtils.writeFull(rendererWriter, renderedContent);
    }

    @Override
    @Deprecated
    public String[] renderFiles(Collection<File> asciidoctorFiles, Map<String, Object> options2) {
        List<String> asciidoctorContent = this.renderAllFiles(options2, asciidoctorFiles);
        return asciidoctorContent.toArray(new String[asciidoctorContent.size()]);
    }

    @Override
    @Deprecated
    public String[] renderFiles(Collection<File> asciidoctorFiles, Options options2) {
        return this.renderFiles(asciidoctorFiles, options2.map());
    }

    @Override
    @Deprecated
    public String[] renderDirectory(DirectoryWalker directoryWalker, Map<String, Object> options2) {
        List<File> asciidoctorFiles = this.scanForAsciiDocFiles(directoryWalker);
        List<String> asciidoctorContent = this.renderAllFiles(options2, asciidoctorFiles);
        return asciidoctorContent.toArray(new String[asciidoctorContent.size()]);
    }

    private List<String> renderAllFiles(Map<String, Object> options2, Collection<File> asciidoctorFiles) {
        ArrayList<String> asciidoctorContent = new ArrayList<String>();
        for (File asciidoctorFile : asciidoctorFiles) {
            String renderedFile = this.renderFile(asciidoctorFile, options2);
            if (renderedFile == null) continue;
            asciidoctorContent.add(renderedFile);
        }
        return asciidoctorContent;
    }

    private List<File> scanForAsciiDocFiles(DirectoryWalker directoryWalker) {
        List<File> asciidoctorFiles = directoryWalker.scan();
        return asciidoctorFiles;
    }

    @Override
    @Deprecated
    public String render(String content, Options options2) {
        return this.render(content, options2.map());
    }

    @Override
    @Deprecated
    public void render(Reader contentReader, Writer rendererWriter, Options options2) throws IOException {
        this.render(contentReader, rendererWriter, options2.map());
    }

    @Override
    @Deprecated
    public String renderFile(File filename2, Options options2) {
        return this.renderFile(filename2, options2.map());
    }

    @Override
    @Deprecated
    public String[] renderDirectory(DirectoryWalker directoryWalker, Options options2) {
        return this.renderDirectory(directoryWalker, options2.map());
    }

    @Override
    @Deprecated
    public String render(String content, OptionsBuilder options2) {
        return this.render(content, options2.asMap());
    }

    @Override
    @Deprecated
    public void render(Reader contentReader, Writer rendererWriter, OptionsBuilder options2) throws IOException {
        this.render(contentReader, rendererWriter, options2.asMap());
    }

    @Override
    @Deprecated
    public String renderFile(File filename2, OptionsBuilder options2) {
        return this.renderFile(filename2, options2.asMap());
    }

    @Override
    @Deprecated
    public String[] renderDirectory(DirectoryWalker directoryWalker, OptionsBuilder options2) {
        return this.renderDirectory(directoryWalker, options2.asMap());
    }

    @Override
    @Deprecated
    public String[] renderFiles(Collection<File> asciidoctorFiles, OptionsBuilder options2) {
        return this.renderFiles(asciidoctorFiles, options2.asMap());
    }

    @Override
    public JavaExtensionRegistry javaExtensionRegistry() {
        return new JavaExtensionRegistry(this.asciidoctorModule, this.rubyRuntime);
    }

    @Override
    public RubyExtensionRegistry rubyExtensionRegistry() {
        return new RubyExtensionRegistry(this.asciidoctorModule, this.rubyRuntime);
    }

    @Override
    public void unregisterAllExtensions() {
        this.asciidoctorModule.unregister_all_extensions();
    }

    @Override
    public void shutdown() {
        this.rubyRuntime.tearDown();
    }

    @Override
    public String asciidoctorVersion() {
        return this.asciidoctorModule.asciidoctorRuntimeEnvironmentVersion();
    }

    @Override
    public String convert(String content, Map<String, Object> options2) {
        return this.render(content, options2);
    }

    @Override
    public String convert(String content, Options options2) {
        return this.render(content, options2);
    }

    @Override
    public String convert(String content, OptionsBuilder options2) {
        return this.render(content, options2);
    }

    @Override
    public void convert(Reader contentReader, Writer rendererWriter, Map<String, Object> options2) throws IOException {
        this.render(contentReader, rendererWriter, options2);
    }

    @Override
    public void convert(Reader contentReader, Writer rendererWriter, Options options2) throws IOException {
        this.render(contentReader, rendererWriter, options2);
    }

    @Override
    public void convert(Reader contentReader, Writer rendererWriter, OptionsBuilder options2) throws IOException {
        this.render(contentReader, rendererWriter, options2);
    }

    @Override
    public String convertFile(File filename2, Map<String, Object> options2) {
        return this.renderFile(filename2, options2);
    }

    @Override
    public String convertFile(File filename2, Options options2) {
        return this.renderFile(filename2, options2);
    }

    @Override
    public String convertFile(File filename2, OptionsBuilder options2) {
        return this.renderFile(filename2, options2);
    }

    @Override
    public String[] convertDirectory(DirectoryWalker directoryWalker, Map<String, Object> options2) {
        return this.renderDirectory(directoryWalker, options2);
    }

    @Override
    public String[] convertDirectory(DirectoryWalker directoryWalker, Options options2) {
        return this.renderDirectory(directoryWalker, options2);
    }

    @Override
    public String[] convertDirectory(DirectoryWalker directoryWalker, OptionsBuilder options2) {
        return this.renderDirectory(directoryWalker, options2);
    }

    @Override
    public String[] convertFiles(Collection<File> asciidoctorFiles, Map<String, Object> options2) {
        return this.renderFiles(asciidoctorFiles, options2);
    }

    @Override
    public String[] convertFiles(Collection<File> asciidoctorFiles, Options options2) {
        return this.renderFiles(asciidoctorFiles, options2);
    }

    @Override
    public String[] convertFiles(Collection<File> asciidoctorFiles, OptionsBuilder options2) {
        return this.renderFiles(asciidoctorFiles, options2);
    }

    @Override
    public Document load(String content, Map<String, Object> options2) {
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options2);
        return new Document(this.asciidoctorModule.load(content, rubyHash), this.rubyRuntime);
    }

    @Override
    public Document loadFile(File file2, Map<String, Object> options2) {
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options2);
        return new Document(this.asciidoctorModule.load(file2.getAbsolutePath(), rubyHash), this.rubyRuntime);
    }
}

