/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubySymbol;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyHashUtil {
    private RubyHashUtil() {
    }

    public static RubyHash convertMapToRubyHashWithSymbolsIfNecessary(Ruby rubyRuntime, Map<Object, Object> options2) {
        RubyHash rubyHash = new RubyHash(rubyRuntime);
        Set<Map.Entry<Object, Object>> optionsSet = options2.entrySet();
        for (Map.Entry<Object, Object> entry : optionsSet) {
            Object keyType = entry.getKey();
            if (!RubyHashUtil.isNotARubySymbol(keyType)) continue;
            String key2 = (String)keyType;
            Object value2 = entry.getValue();
            RubySymbol newSymbol = RubyUtils.toSymbol(rubyRuntime, key2);
            IRubyObject iRubyValue = RubyHashUtil.toRubyObject(rubyRuntime, value2);
            rubyHash.put(newSymbol, iRubyValue);
        }
        return rubyHash;
    }

    public static RubyHash convertMapToRubyHashWithSymbols(Ruby rubyRuntime, Map<String, Object> options2) {
        RubyHash rubyHash = new RubyHash(rubyRuntime);
        Set<Map.Entry<String, Object>> optionsSet = options2.entrySet();
        for (Map.Entry<String, Object> entry : optionsSet) {
            String key2 = entry.getKey();
            Object value2 = entry.getValue();
            RubySymbol newSymbol = RubyUtils.toSymbol(rubyRuntime, key2);
            IRubyObject iRubyValue = RubyHashUtil.toRubyObject(rubyRuntime, value2);
            rubyHash.put(newSymbol, iRubyValue);
        }
        return rubyHash;
    }

    private static boolean isNotARubySymbol(Object keyType) {
        return keyType instanceof String;
    }

    public static Map<Object, Object> convertRubyHashMapToMap(Map<Object, Object> rubyHashMap) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Set<Map.Entry<Object, Object>> elements = rubyHashMap.entrySet();
        for (Map.Entry<Object, Object> element : elements) {
            if (element.getKey() instanceof RubySymbol) {
                map.put(RubyHashUtil.toJavaString((RubySymbol)element.getKey()), RubyHashUtil.toJavaObject(element.getValue()));
                continue;
            }
            map.put(RubyHashUtil.toJavaObject(element.getKey()).toString(), RubyHashUtil.toJavaObject(element.getValue()));
        }
        return map;
    }

    private static String toJavaString(RubySymbol element) {
        return element.asJavaString();
    }

    private static Object toJavaObject(Object rubyObject) {
        if (rubyObject instanceof IRubyObject) {
            IRubyObject iRubyObject = (IRubyObject)rubyObject;
            return JavaEmbedUtils.rubyToJava(iRubyObject);
        }
        return rubyObject;
    }

    private static IRubyObject toRubyObject(Ruby rubyRuntime, Object value2) {
        String stringValue;
        if (value2 instanceof List) {
            return RubyHashUtil.toRubyArray(rubyRuntime, (List)value2);
        }
        if (RubyHashUtil.isNotARubySymbol(value2) && (stringValue = (String)value2).startsWith(":")) {
            return RubyUtils.toSymbol(rubyRuntime, stringValue.substring(1));
        }
        IRubyObject iRubyObject = JavaEmbedUtils.javaToRuby(rubyRuntime, value2);
        return iRubyObject;
    }

    private static IRubyObject toRubyArray(Ruby rubyRuntime, List<Object> values2) {
        RubyArray rubyArray = RubyArray.newArray(rubyRuntime, values2.size());
        for (Object value2 : values2) {
            rubyArray.add(RubyHashUtil.toRubyObject(rubyRuntime, value2));
        }
        return rubyArray;
    }

    public static RubyHash toNoneSymbolsRubyHash(Ruby rubyRuntime, Map<String, Object> map) {
        RubyHash rubyHash = new RubyHash(rubyRuntime);
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            rubyHash.put(RubyHashUtil.toJavaObject(entry.getKey()), RubyHashUtil.toJavaObject(entry.getValue()));
        }
        return rubyHash;
    }
}

