/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.slf4j.Marker;

public class BasicMarker
implements Marker {
    private static final long serialVersionUID = 1803952589649545191L;
    private final String name;
    private List refereceList;
    private static String OPEN = "[ ";
    private static String CLOSE = " ]";
    private static String SEP = ", ";

    BasicMarker(String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException("A marker name cannot be null");
        }
        this.name = name2;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void add(Marker reference2) {
        if (reference2 == null) {
            throw new IllegalArgumentException("A null value cannot be added to a Marker as reference.");
        }
        if (this.contains(reference2)) {
            return;
        }
        if (reference2.contains(this)) {
            return;
        }
        if (this.refereceList == null) {
            this.refereceList = new Vector();
        }
        this.refereceList.add(reference2);
    }

    public synchronized boolean hasReferences() {
        return this.refereceList != null && this.refereceList.size() > 0;
    }

    public boolean hasChildren() {
        return this.hasReferences();
    }

    public synchronized Iterator iterator() {
        if (this.refereceList != null) {
            return this.refereceList.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public synchronized boolean remove(Marker referenceToRemove) {
        if (this.refereceList == null) {
            return false;
        }
        int size2 = this.refereceList.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            Marker m = (Marker)this.refereceList.get(i2);
            if (!((Object)referenceToRemove).equals(m)) continue;
            this.refereceList.remove(i2);
            return true;
        }
        return false;
    }

    public boolean contains(Marker other) {
        if (other == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this.equals(other)) {
            return true;
        }
        if (this.hasReferences()) {
            for (int i2 = 0; i2 < this.refereceList.size(); ++i2) {
                Marker ref = (Marker)this.refereceList.get(i2);
                if (!ref.contains(other)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this.name.equals(name2)) {
            return true;
        }
        if (this.hasReferences()) {
            for (int i2 = 0; i2 < this.refereceList.size(); ++i2) {
                Marker ref = (Marker)this.refereceList.get(i2);
                if (!ref.contains(name2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Marker)) {
            return false;
        }
        Marker other = (Marker)obj;
        return this.name.equals(other.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        if (!this.hasReferences()) {
            return this.getName();
        }
        Iterator it = this.iterator();
        StringBuffer sb = new StringBuffer(this.getName());
        sb.append(' ').append(OPEN);
        while (it.hasNext()) {
            Marker reference2 = (Marker)it.next();
            sb.append(reference2.getName());
            if (!it.hasNext()) continue;
            sb.append(SEP);
        }
        sb.append(CLOSE);
        return sb.toString();
    }
}

