/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.ant;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.asciidoctor.AbstractDirectoryWalker;
import org.asciidoctor.AsciiDocDirectoryWalker;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.internal.JRubyRuntimeContext;
import org.asciidoctor.internal.RubyUtils;

public class AsciidoctorAntTask
extends Task {
    private String sourceDirectory;
    private String outputDirectory;
    private boolean preserveDirectories = false;
    private String sourceDocumentName;
    private String backend = "docbook";
    private String imagesDir = "images";
    private String doctype = "article";
    private boolean compact = false;
    private boolean headerFooter = true;
    private String sourceHighlighter;
    private boolean embedAssets = false;
    private String eruby = "";
    private String templateDir;
    private String templateEngine;
    private String baseDir;
    private boolean relativeBaseDir = false;
    private String extensions;
    private SafeMode safe = SafeMode.SAFE;
    private List<FileSet> resources = new ArrayList<FileSet>();
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private List<Extension> preProcessors = new ArrayList<Extension>();
    private List<Extension> treeProcessors = new ArrayList<Extension>();
    private List<Extension> postProcessors = new ArrayList<Extension>();
    private List<Extension> blockProcessors = new ArrayList<Extension>();
    private List<Extension> blockMacroProcessors = new ArrayList<Extension>();
    private List<Extension> inlineMacroProcessors = new ArrayList<Extension>();
    private List<Extension> includeProcessors = new ArrayList<Extension>();
    private List<RubyLibrary> requires = new ArrayList<RubyLibrary>();
    private String gemPaths;

    public void execute() throws BuildException {
        this.checkMandatoryParameter("sourceDirectory", this.sourceDirectory);
        this.checkMandatoryParameter("outputDirectory", this.outputDirectory);
        this.ensureOutputExists();
        Asciidoctor asciidoctor = this.createAsciidoctor(this.gemPaths);
        this.registerAdditionalRubyLibraries();
        this.registerExtensions(asciidoctor);
        AttributesBuilder attributesBuilder = this.buildAttributes();
        OptionsBuilder optionsBuilder = this.buildOptions();
        optionsBuilder.attributes(attributesBuilder.get());
        if (this.sourceDocumentName == null) {
            this.log("Render asciidoc files from " + this.sourceDirectory + " to " + this.outputDirectory + " with backend=" + this.backend);
            for (File file2 : this.scanSourceFiles()) {
                this.setDestinationPaths(optionsBuilder, file2);
                asciidoctor.renderFile(file2, optionsBuilder.get());
            }
        } else {
            this.log("Render " + this.sourceDocumentName + " from " + this.sourceDirectory + " to " + this.outputDirectory + " with backend=" + this.backend);
            File file3 = new File(this.sourceDirectory, this.sourceDocumentName);
            this.setDestinationPaths(optionsBuilder, file3);
            asciidoctor.renderFile(file3, optionsBuilder.get());
        }
        try {
            for (FileSet resource2 : this.resources) {
                File resourceDir = resource2.getDir();
                String destPath = resourceDir.getCanonicalPath().substring(new File(this.sourceDirectory).getCanonicalPath().length());
                File destResourceDir = new File(this.outputDirectory, destPath);
                destResourceDir.mkdirs();
                String[] includedFiles = resource2.getDirectoryScanner(this.getProject()).getIncludedFiles();
                FileUtils.copyDirectory(resourceDir, destResourceDir, new ResourceFileFilter(includedFiles), false);
            }
        }
        catch (IOException e) {
            throw new BuildException("Error copying resources", (Throwable)e);
        }
    }

    private void registerAdditionalRubyLibraries() {
        for (RubyLibrary require2 : this.requires) {
            RubyUtils.requireLibrary(JRubyRuntimeContext.get(), require2.getName());
        }
    }

    private void registerExtensions(Asciidoctor asciidoctor) {
        for (Extension preProcessor : this.preProcessors) {
            asciidoctor.javaExtensionRegistry().preprocessor(preProcessor.getClassName());
        }
        for (Extension treeProcessor : this.treeProcessors) {
            asciidoctor.javaExtensionRegistry().treeprocessor(treeProcessor.getClassName());
        }
        for (Extension postProcessor : this.postProcessors) {
            asciidoctor.javaExtensionRegistry().postprocessor(postProcessor.getClassName());
        }
        for (Extension blockProcessor : this.blockProcessors) {
            asciidoctor.javaExtensionRegistry().block(blockProcessor.getBlockName(), blockProcessor.getClassName());
        }
        for (Extension blockMacroProcessor : this.blockMacroProcessors) {
            asciidoctor.javaExtensionRegistry().blockMacro(blockMacroProcessor.getBlockName(), blockMacroProcessor.getClassName());
        }
        for (Extension inlineMacroProcessor : this.inlineMacroProcessors) {
            asciidoctor.javaExtensionRegistry().inlineMacro(inlineMacroProcessor.getBlockName(), inlineMacroProcessor.getClassName());
        }
        for (Extension includeProcessor : this.includeProcessors) {
            asciidoctor.javaExtensionRegistry().includeProcessor(includeProcessor.getClassName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Asciidoctor createAsciidoctor(String gemPath) {
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Asciidoctor asciidoctor = this.getAsciidoctorInstance(gemPath);
            return asciidoctor;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
    }

    private Asciidoctor getAsciidoctorInstance(String gemPath) {
        String gemHomeExpected;
        Asciidoctor asciidoctor;
        if (gemPath == null) {
            asciidoctor = Asciidoctor.Factory.create();
        } else {
            String normalizedGemPath = File.separatorChar == '\\' ? gemPath.replaceAll("\\\\", "/") : gemPath;
            asciidoctor = Asciidoctor.Factory.create(normalizedGemPath);
        }
        String gemHome = JRubyRuntimeContext.get().evalScriptlet("ENV['GEM_HOME']").toString();
        String string2 = gemHomeExpected = gemPath == null || "".equals(gemPath) ? "" : gemPath.split(File.pathSeparator)[0];
        if (!"".equals(gemHome) && !gemHomeExpected.equals(gemHome)) {
            this.log("Using inherited external environment to resolve gems (" + gemHome + "), i.e. build is platform dependent!");
        }
        return asciidoctor;
    }

    private OptionsBuilder buildOptions() {
        OptionsBuilder optionsBuilder = OptionsBuilder.options();
        optionsBuilder.safe(this.safe).eruby(this.eruby).backend(this.backend).docType(this.doctype).compact(this.compact).headerFooter(this.headerFooter).mkDirs(true);
        if (this.templateEngine != null) {
            optionsBuilder.templateEngine(this.templateEngine);
        }
        if (this.templateDir != null) {
            optionsBuilder.templateDir(new File(this.templateDir));
        }
        return optionsBuilder;
    }

    private void setDestinationPaths(OptionsBuilder optionsBuilder, File sourceFile) {
        optionsBuilder.baseDir(this.computeBaseDir(sourceFile));
        try {
            if (this.preserveDirectories) {
                String proposalPath = sourceFile.getParentFile().getCanonicalPath().substring(new File(this.sourceDirectory).getCanonicalPath().length());
                File relativePath = new File(this.outputDirectory, proposalPath);
                relativePath.mkdirs();
                optionsBuilder.toDir(relativePath).destinationDir(relativePath);
            } else {
                File destinationDir = new File(this.outputDirectory);
                optionsBuilder.toDir(destinationDir).destinationDir(destinationDir);
            }
        }
        catch (IOException e) {
            throw new BuildException("Unable to locate output directory", (Throwable)e);
        }
    }

    private File computeBaseDir(File sourceFile) {
        File baseDirFile = this.baseDir != null ? new File(this.baseDir) : (this.relativeBaseDir ? sourceFile.getParentFile() : this.getProject().getBaseDir());
        return baseDirFile;
    }

    private AttributesBuilder buildAttributes() {
        AttributesBuilder attributesBuilder = AttributesBuilder.attributes();
        attributesBuilder.imagesDir(this.imagesDir);
        if (this.sourceHighlighter != null) {
            attributesBuilder.sourceHighlighter(this.sourceHighlighter);
        }
        if (this.embedAssets) {
            attributesBuilder.linkCss(false);
            attributesBuilder.dataUri(true);
        }
        attributesBuilder.copyCss(false);
        for (Attribute attribute : this.attributes) {
            if ("true".equals(attribute.getValue()) || "false".equals(attribute.getValue())) {
                attributesBuilder.attribute(attribute.getKey(), Attributes.toAsciidoctorFlag(Boolean.valueOf(attribute.getValue())));
                continue;
            }
            attributesBuilder.attribute(attribute.getKey(), attribute.getValue());
        }
        return attributesBuilder;
    }

    private void checkMandatoryParameter(String name2, Object value2) {
        if (value2 == null) {
            throw new BuildException(name2 + " is mandatory");
        }
    }

    private void ensureOutputExists() {
        File outputFile = new File(this.outputDirectory);
        if (!outputFile.exists() && !outputFile.mkdirs()) {
            this.log("Can't create " + outputFile.getPath(), 0);
        }
    }

    private List<File> scanSourceFiles() {
        List<File> asciidoctorFiles;
        AbstractDirectoryWalker directoryWalker;
        String absoluteSourceDirectory = this.sourceDirectory;
        if (this.extensions == null || this.extensions.isEmpty()) {
            directoryWalker = new AsciiDocDirectoryWalker(absoluteSourceDirectory);
            asciidoctorFiles = directoryWalker.scan();
        } else {
            directoryWalker = new CustomExtensionDirectoryWalker(absoluteSourceDirectory, Arrays.asList(this.extensions.split(",")));
            asciidoctorFiles = directoryWalker.scan();
        }
        Iterator<File> iter = asciidoctorFiles.iterator();
        block0: while (iter.hasNext()) {
            File f = iter.next();
            while (!absoluteSourceDirectory.equals(f.getAbsolutePath())) {
                if (f.getName().startsWith("_")) {
                    iter.remove();
                    continue block0;
                }
                if ((f = f.getParentFile()) != null) continue;
                continue block0;
            }
        }
        return asciidoctorFiles;
    }

    public void setSourceDirectory(String sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setSourceDocumentName(String sourceDocumentName) {
        this.sourceDocumentName = sourceDocumentName;
    }

    public void setBackend(String backend) {
        this.backend = backend;
    }

    public void setImagesDir(String imagesDir) {
        this.imagesDir = imagesDir;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public void setCompact(boolean compact2) {
        this.compact = compact2;
    }

    public void setHeaderFooter(boolean headerFooter) {
        this.headerFooter = headerFooter;
    }

    public void setSourceHighlighter(String sourceHighlighter) {
        this.sourceHighlighter = sourceHighlighter;
    }

    public void setEmbedAssets(boolean embedAssets) {
        this.embedAssets = embedAssets;
    }

    public void setEruby(String eruby) {
        this.eruby = eruby;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public void setTemplateEngine(String templateEngine) {
        this.templateEngine = templateEngine;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setRelativeBaseDir(boolean relativeBaseDir) {
        this.relativeBaseDir = relativeBaseDir;
    }

    public void setExtensions(String extensions) {
        this.extensions = extensions;
    }

    public void setPreserveDirectories(boolean preserveDirectories) {
        this.preserveDirectories = preserveDirectories;
    }

    public void addResource(FileSet fileSet) {
        this.resources.add(fileSet);
    }

    public Attribute createAttribute() {
        Attribute attribute = new Attribute();
        this.attributes.add(attribute);
        return attribute;
    }

    public void setSafemode(String s2) {
        this.safe = SafeMode.valueOf(s2.toUpperCase());
    }

    public Extension createPreProcessor() {
        Extension extension = new Extension();
        this.preProcessors.add(extension);
        return extension;
    }

    public Extension createTreeProcessor() {
        Extension extension = new Extension();
        this.treeProcessors.add(extension);
        return extension;
    }

    public Extension createPostProcessor() {
        Extension extension = new Extension();
        this.postProcessors.add(extension);
        return extension;
    }

    public Extension createBlockProcessor() {
        Extension extension = new Extension();
        this.blockProcessors.add(extension);
        return extension;
    }

    public Extension createBlockMacroProcessor() {
        Extension extension = new Extension();
        this.blockMacroProcessors.add(extension);
        return extension;
    }

    public Extension createInlineMacroProcessor() {
        Extension extension = new Extension();
        this.inlineMacroProcessors.add(extension);
        return extension;
    }

    public Extension createIncludeProcessor() {
        Extension extension = new Extension();
        this.includeProcessors.add(extension);
        return extension;
    }

    public void setGemPaths(String gemPaths) {
        this.gemPaths = gemPaths;
    }

    public RubyLibrary createRequire() {
        RubyLibrary rubyLibrary = new RubyLibrary();
        this.requires.add(rubyLibrary);
        return rubyLibrary;
    }

    public class RubyLibrary {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name2) {
            this.name = name2;
        }
    }

    public class Extension {
        private String className;
        private String blockName;

        public String getClassName() {
            return this.className;
        }

        public String getBlockName() {
            return this.blockName;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setBlockName(String blockName) {
            this.blockName = blockName;
        }
    }

    private static class ResourceFileFilter
    implements FileFilter {
        private final List<String> includedFiles;

        public ResourceFileFilter(String[] includedFiles) {
            this.includedFiles = Arrays.asList(includedFiles);
        }

        @Override
        public boolean accept(File pathname2) {
            return this.includedFiles.contains(pathname2.getName());
        }
    }

    public class Attribute {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setKey(String key2) {
            this.key = key2;
        }

        public void setValue(String value2) {
            this.value = value2;
        }
    }

    private static class CustomExtensionDirectoryWalker
    extends AbstractDirectoryWalker {
        private final List<String> extensions;

        public CustomExtensionDirectoryWalker(String absolutePath, List<String> extensions) {
            super(absolutePath);
            this.extensions = extensions;
        }

        @Override
        protected boolean isAcceptedFile(File filename2) {
            String name2 = filename2.getName();
            for (String extension : this.extensions) {
                if (!name2.endsWith(extension)) continue;
                return true;
            }
            return false;
        }
    }
}

