/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.ast;

import java.util.ArrayList;
import java.util.List;
import org.asciidoctor.ast.AbstractBlockImpl;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.Column;
import org.asciidoctor.ast.NodeConverter;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.RowImpl;
import org.asciidoctor.ast.Table;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class TableImpl
extends AbstractBlockImpl
implements Table {
    private static final String FRAME_ATTR = "frame";
    private static final String GRID_ATTR = "grid";
    private Table delegate;
    private Rows rows;

    public TableImpl(Table delegate2, Ruby rubyRuntime) {
        super(delegate2, rubyRuntime);
        this.delegate = delegate2;
        IRubyObject rubyTable = JavaEmbedUtils.javaToRuby(rubyRuntime, delegate2);
        this.rows = new RowsImpl(RubyUtils.rubyToJava(rubyRuntime, rubyTable.getInstanceVariables().getInstanceVariable("@rows"), Rows.class), rubyRuntime);
    }

    @Override
    public boolean hasHeaderOption() {
        return this.delegate.hasHeaderOption();
    }

    @Override
    public String getFrame() {
        return (String)this.getAttr(FRAME_ATTR, "all");
    }

    @Override
    public void setFrame(String frame) {
        this.setAttr(FRAME_ATTR, frame, true);
    }

    @Override
    public String getGrid() {
        return (String)this.getAttr(GRID_ATTR, "all");
    }

    @Override
    public void setGrid(String grid) {
        this.setAttr(GRID_ATTR, grid, true);
    }

    @Override
    public List<Column> getColumns() {
        List<Column> rubyColumns = this.delegate.getColumns();
        ArrayList<Column> result2 = new ArrayList<Column>(rubyColumns.size());
        for (int i2 = 0; i2 < rubyColumns.size(); ++i2) {
            IRubyObject rubyColumn = (IRubyObject)((Object)rubyColumns.get(i2));
            result2.add((Column)NodeConverter.createASTNode(rubyColumn));
        }
        return result2;
    }

    @Override
    public List<Row> getFooter() {
        return this.rows.getFoot();
    }

    @Override
    public List<Row> getBody() {
        return this.rows.getBody();
    }

    @Override
    public List<Row> getHeader() {
        return this.rows.getHead();
    }

    public static class RowsImpl
    implements Rows {
        private final Rows delegate;
        private final Ruby rubyRuntime;

        public RowsImpl(Rows delegate2, Ruby rubyRuntime) {
            this.delegate = delegate2;
            this.rubyRuntime = rubyRuntime;
        }

        @Override
        public List<Row> getHead() {
            return this.convertRows(this.delegate.getHead());
        }

        @Override
        public List<Row> getFoot() {
            return this.convertRows(this.delegate.getFoot());
        }

        @Override
        public List<Row> getBody() {
            return this.convertRows(this.delegate.getBody());
        }

        private List<Row> convertRows(List<?> rows) {
            ArrayList<Row> result2 = new ArrayList<Row>(rows.size());
            for (int i2 = 0; i2 < rows.size(); ++i2) {
                List rubyRow = (List)rows.get(i2);
                result2.add(this.convertRow(rubyRow));
            }
            return result2;
        }

        private Row convertRow(List<? extends IRubyObject> rubyRow) {
            ArrayList<Cell> cells = new ArrayList<Cell>(rubyRow.size());
            for (int j = 0; j < rubyRow.size(); ++j) {
                IRubyObject rubyCell = rubyRow.get(j);
                cells.add((Cell)NodeConverter.createASTNode(rubyCell));
            }
            return new RowImpl(cells, this.rubyRuntime);
        }
    }

    public static interface Rows {
        public List<Row> getHead();

        public List<Row> getFoot();

        public List<Row> getBody();
    }
}

