/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jruby.RubyInstanceConfig;

class EnvironmentInjector {
    private RubyInstanceConfig config;

    EnvironmentInjector(RubyInstanceConfig config) {
        this.config = config;
    }

    void inject(Map<String, Object> environmentVars) {
        if (!environmentVars.isEmpty()) {
            HashMap<String, String> replacementEnv = new HashMap<String, String>(System.getenv());
            for (Map.Entry<String, Object> envVar : environmentVars.entrySet()) {
                String key2 = envVar.getKey();
                Object val = envVar.getValue();
                if (val == null || "".equals(val)) {
                    replacementEnv.remove(envVar.getKey());
                    if (!"GEM_PATH".equals(key2) || environmentVars.containsKey("GEM_HOME")) continue;
                    replacementEnv.remove("GEM_HOME");
                    continue;
                }
                replacementEnv.put(key2, (String)val);
                if (!"GEM_PATH".equals(key2) || environmentVars.containsKey("GEM_HOME")) continue;
                String gemHome = val.toString().split(File.pathSeparator)[0];
                replacementEnv.put("GEM_HOME", gemHome);
            }
            this.config.setEnvironment(replacementEnv);
        }
    }
}

