/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.ast;

import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.AbstractBlock;
import org.asciidoctor.ast.AbstractNode;
import org.asciidoctor.ast.AbstractNodeImpl;
import org.asciidoctor.ast.NodeConverter;
import org.asciidoctor.ast.Section;
import org.asciidoctor.internal.RubyHashUtil;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyObject;

public class AbstractBlockImpl
extends AbstractNodeImpl
implements AbstractBlock {
    private static final String BLOCK_CLASS = "Block";
    private static final String SECTION_CLASS = "Section";
    protected AbstractBlock delegate;

    public AbstractBlockImpl(AbstractBlock blockDelegate, Ruby runtime) {
        super(blockDelegate, runtime);
        this.delegate = blockDelegate;
    }

    @Override
    @Deprecated
    public String title() {
        return this.getTitle();
    }

    @Override
    public String getTitle() {
        return this.delegate.getTitle();
    }

    public boolean isTitle() {
        return RubyUtils.invokeRubyMethod(this.delegate, "title?", new Object[0], Boolean.class);
    }

    @Override
    @Deprecated
    public String style() {
        return this.getStyle();
    }

    @Override
    public String getStyle() {
        return this.delegate.getStyle();
    }

    public String getCaption() {
        return RubyUtils.invokeRubyMethod(this.delegate, "caption", new Object[0], String.class);
    }

    @Override
    @Deprecated
    public List<AbstractBlock> blocks() {
        return this.getBlocks();
    }

    @Override
    public List<AbstractBlock> getBlocks() {
        List<AbstractBlock> rubyBlocks = this.delegate.getBlocks();
        for (int i2 = 0; i2 < rubyBlocks.size(); ++i2) {
            AbstractBlock abstractBlock = rubyBlocks.get(i2);
            if (abstractBlock instanceof RubyArray || abstractBlock instanceof AbstractNode) continue;
            RubyObject rubyObject = (RubyObject)((Object)abstractBlock);
            rubyBlocks.set(i2, (AbstractBlock)NodeConverter.createASTNode(rubyObject));
        }
        return rubyBlocks;
    }

    public boolean isBlocks() {
        return RubyUtils.invokeRubyMethod(this.delegate, "blocks?", new Object[0], Boolean.class);
    }

    @Override
    @Deprecated
    public Object content() {
        return this.getContent();
    }

    @Override
    @Deprecated
    public Object getContent() {
        return this.delegate.content();
    }

    @Override
    public String getNodeName() {
        return this.delegate.getNodeName();
    }

    @Override
    public String convert() {
        return this.delegate.convert();
    }

    @Override
    public int getLevel() {
        return this.delegate.getLevel();
    }

    @Override
    public AbstractBlock delegate() {
        return this.delegate;
    }

    public List<Section> getSections() {
        return RubyUtils.invokeRubyMethod(this.delegate, "sections", new Object[0], List.class);
    }

    public boolean isSections() {
        return RubyUtils.invokeRubyMethod(this.delegate, "sections?", new Object[0], Boolean.class);
    }

    @Override
    public List<AbstractBlock> findBy(Map<Object, Object> selector) {
        List<AbstractBlock> findBy = this.delegate.findBy(RubyHashUtil.convertMapToRubyHashWithSymbolsIfNecessary(this.runtime, selector));
        for (int i2 = 0; i2 < findBy.size(); ++i2) {
            AbstractBlock abstractBlock = findBy.get(i2);
            if (abstractBlock instanceof RubyArray || abstractBlock instanceof AbstractBlock) continue;
            RubyObject rubyObject = (RubyObject)((Object)abstractBlock);
            findBy.set(i2, (AbstractBlock)NodeConverter.createASTNode(rubyObject));
        }
        return findBy;
    }
}

