/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.asciidoctor.extension.BlockMacroProcessor;
import org.asciidoctor.extension.BlockProcessor;
import org.asciidoctor.extension.DocinfoProcessor;
import org.asciidoctor.extension.ExtensionGroup;
import org.asciidoctor.extension.IncludeProcessor;
import org.asciidoctor.extension.InlineMacroProcessor;
import org.asciidoctor.extension.Postprocessor;
import org.asciidoctor.extension.Preprocessor;
import org.asciidoctor.extension.Treeprocessor;
import org.asciidoctor.internal.AsciidoctorModule;
import org.asciidoctor.internal.JRubyAsciidoctor;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.Ruby;

public class ExtensionGroupImpl
implements ExtensionGroup {
    private final JRubyAsciidoctor asciidoctor;
    private final Ruby rubyRuntime;
    private final AsciidoctorModule asciidoctorModule;
    private final String groupName;
    private final List<Runnable> registrations = new ArrayList<Runnable>();

    public ExtensionGroupImpl(String groupName, JRubyAsciidoctor asciidoctor) {
        this.groupName = groupName;
        this.asciidoctor = asciidoctor;
        this.rubyRuntime = asciidoctor.getRubyRuntime();
        this.asciidoctorModule = asciidoctor.getAsciidoctorModule();
    }

    @Override
    public void register() {
        for (Runnable r : this.registrations) {
            r.run();
        }
    }

    @Override
    public void unregister() {
        this.asciidoctorModule.unregister_extension(this.groupName);
    }

    @Override
    public ExtensionGroup docinfoProcessor(final Class<? extends DocinfoProcessor> docInfoProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, docInfoProcessor);
                ExtensionGroupImpl.this.asciidoctorModule.docinfo_processor(RubyUtils.toRubyClass(ExtensionGroupImpl.this.rubyRuntime, docInfoProcessor), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup docinfoProcessor(final DocinfoProcessor docInfoProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, docInfoProcessor.getClass());
                ExtensionGroupImpl.this.asciidoctorModule.docinfo_processor(docInfoProcessor, ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup docinfoProcessor(final String docInfoProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, docInfoProcessor);
                ExtensionGroupImpl.this.asciidoctorModule.docinfo_processor(ExtensionGroupImpl.this.getClassName(docInfoProcessor), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup preprocessor(final Class<? extends Preprocessor> preprocessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, preprocessor);
                ExtensionGroupImpl.this.asciidoctorModule.preprocessor(RubyUtils.toRubyClass(ExtensionGroupImpl.this.rubyRuntime, preprocessor), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup preprocessor(final Preprocessor preprocessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, preprocessor.getClass());
                ExtensionGroupImpl.this.asciidoctorModule.preprocessor(preprocessor, ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup preprocessor(final String preprocessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, preprocessor);
                ExtensionGroupImpl.this.asciidoctorModule.preprocessor(ExtensionGroupImpl.this.getClassName(preprocessor), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup postprocessor(final String postprocessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, postprocessor);
                ExtensionGroupImpl.this.asciidoctorModule.postprocessor(ExtensionGroupImpl.this.getClassName(postprocessor), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup postprocessor(final Class<? extends Postprocessor> postprocessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, postprocessor);
                ExtensionGroupImpl.this.asciidoctorModule.postprocessor(RubyUtils.toRubyClass(ExtensionGroupImpl.this.rubyRuntime, postprocessor), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup postprocessor(final Postprocessor postprocesor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, postprocesor.getClass());
                ExtensionGroupImpl.this.asciidoctorModule.postprocessor(postprocesor, ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup includeProcessor(final String includeProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, includeProcessor);
                ExtensionGroupImpl.this.asciidoctorModule.include_processor(ExtensionGroupImpl.this.getClassName(includeProcessor), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup includeProcessor(final Class<? extends IncludeProcessor> includeProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, includeProcessor);
                ExtensionGroupImpl.this.asciidoctorModule.include_processor(RubyUtils.toRubyClass(ExtensionGroupImpl.this.rubyRuntime, includeProcessor), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup includeProcessor(final IncludeProcessor includeProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                String importLine = ExtensionGroupImpl.this.getImportLine(includeProcessor.getClass());
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, importLine);
                ExtensionGroupImpl.this.asciidoctorModule.include_processor(includeProcessor, ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup treeprocessor(final Treeprocessor treeprocessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, treeprocessor.getClass());
                ExtensionGroupImpl.this.asciidoctorModule.treeprocessor(treeprocessor, ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup treeprocessor(final Class<? extends Treeprocessor> treeProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, treeProcessor);
                ExtensionGroupImpl.this.asciidoctorModule.treeprocessor(RubyUtils.toRubyClass(ExtensionGroupImpl.this.rubyRuntime, treeProcessor), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup treeprocessor(final String treeProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, treeProcessor);
                ExtensionGroupImpl.this.asciidoctorModule.treeprocessor(ExtensionGroupImpl.this.getClassName(treeProcessor), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup block(final String blockName, final String blockProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, blockProcessor);
                ExtensionGroupImpl.this.asciidoctorModule.block_processor(ExtensionGroupImpl.this.getClassName(blockProcessor), (Object)RubyUtils.toSymbol(ExtensionGroupImpl.this.rubyRuntime, blockName), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup block(final String blockName, final Class<? extends BlockProcessor> blockProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, blockProcessor);
                ExtensionGroupImpl.this.asciidoctorModule.block_processor(RubyUtils.toRubyClass(ExtensionGroupImpl.this.rubyRuntime, blockProcessor), (Object)RubyUtils.toSymbol(ExtensionGroupImpl.this.rubyRuntime, blockName), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup block(BlockProcessor blockProcessor) {
        this.block(blockProcessor.getName(), blockProcessor);
        return this;
    }

    @Override
    public ExtensionGroup block(final String blockName, final BlockProcessor blockProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, blockProcessor.getClass());
                ExtensionGroupImpl.this.asciidoctorModule.block_processor(blockProcessor, (Object)RubyUtils.toSymbol(ExtensionGroupImpl.this.rubyRuntime, blockName), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup blockMacro(final String blockName, final Class<? extends BlockMacroProcessor> blockMacroProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, blockMacroProcessor);
                ExtensionGroupImpl.this.asciidoctorModule.block_macro(blockMacroProcessor.getSimpleName(), (Object)RubyUtils.toSymbol(ExtensionGroupImpl.this.rubyRuntime, blockName), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup blockMacro(final String blockName, final String blockMacroProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, blockMacroProcessor);
                ExtensionGroupImpl.this.asciidoctorModule.block_macro(ExtensionGroupImpl.this.getClassName(blockMacroProcessor), (Object)RubyUtils.toSymbol(ExtensionGroupImpl.this.rubyRuntime, blockName), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup blockMacro(final BlockMacroProcessor blockMacroProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, blockMacroProcessor.getClass());
                ExtensionGroupImpl.this.asciidoctorModule.block_macro(blockMacroProcessor, (Object)RubyUtils.toSymbol(ExtensionGroupImpl.this.rubyRuntime, blockMacroProcessor.getName()), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup inlineMacro(final InlineMacroProcessor inlineMacroProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, inlineMacroProcessor.getClass());
                ExtensionGroupImpl.this.asciidoctorModule.inline_macro(inlineMacroProcessor, (Object)RubyUtils.toSymbol(ExtensionGroupImpl.this.rubyRuntime, inlineMacroProcessor.getName()), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup inlineMacro(final String blockName, final Class<? extends InlineMacroProcessor> inlineMacroProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, inlineMacroProcessor);
                ExtensionGroupImpl.this.asciidoctorModule.inline_macro(RubyUtils.toRubyClass(ExtensionGroupImpl.this.rubyRuntime, inlineMacroProcessor), (Object)RubyUtils.toSymbol(ExtensionGroupImpl.this.rubyRuntime, blockName), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup inlineMacro(final String blockName, final String inlineMacroProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.javaImport(ExtensionGroupImpl.this.rubyRuntime, inlineMacroProcessor);
                ExtensionGroupImpl.this.asciidoctorModule.inline_macro(ExtensionGroupImpl.this.getClassName(inlineMacroProcessor), (Object)RubyUtils.toSymbol(ExtensionGroupImpl.this.rubyRuntime, blockName), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup requireRubyLibrary(final String requiredLibrary) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                RubyUtils.requireLibrary(ExtensionGroupImpl.this.rubyRuntime, requiredLibrary);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup loadRubyClass(final InputStream rubyClassStream) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                RubyUtils.loadRubyClass(ExtensionGroupImpl.this.rubyRuntime, rubyClassStream);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup rubyPreprocessor(final String preprocessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.asciidoctorModule.preprocessor(preprocessor, ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup rubyPostprocessor(final String postprocessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.asciidoctorModule.postprocessor(postprocessor, ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup rubyDocinfoProcessor(final String docinfoProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.asciidoctorModule.docinfo_processor(docinfoProcessor, ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup rubyIncludeProcessor(final String includeProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.asciidoctorModule.include_processor(includeProcessor, ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup rubyTreeprocessor(final String treeProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.asciidoctorModule.treeprocessor(treeProcessor, ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup rubyBlock(final String blockName, final String blockProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.asciidoctorModule.block_processor(blockProcessor, (Object)RubyUtils.toSymbol(ExtensionGroupImpl.this.rubyRuntime, blockName), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup rubyBlockMacro(final String blockName, final String blockMacroProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.asciidoctorModule.block_macro(blockMacroProcessor, (Object)RubyUtils.toSymbol(ExtensionGroupImpl.this.rubyRuntime, blockName), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup rubyInlineMacro(final String blockName, final String inlineMacroProcessor) {
        this.registrations.add(new Runnable(){

            @Override
            public void run() {
                ExtensionGroupImpl.this.asciidoctorModule.inline_macro(inlineMacroProcessor, (Object)RubyUtils.toSymbol(ExtensionGroupImpl.this.rubyRuntime, blockName), ExtensionGroupImpl.this.groupName);
            }
        });
        return this;
    }

    private void javaImport(Ruby ruby2, Class<?> clazz) {
        ruby2.evalScriptlet(String.format("java_import '%s'", this.getImportLine(clazz)));
    }

    private void javaImport(Ruby ruby2, String className) {
        ruby2.evalScriptlet(String.format("java_import '%s'", className));
    }

    private String getImportLine(Class<?> extensionClass) {
        int dollarPosition = -1;
        String className = extensionClass.getName();
        dollarPosition = className.indexOf("$");
        if (dollarPosition != -1) {
            className = className.substring(0, dollarPosition);
        }
        return className;
    }

    private String getClassName(String clazz) {
        return clazz.substring(clazz.lastIndexOf(".") + 1);
    }
}

