/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.cli;

import com.beust.jcommander.JCommander;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.GlobDirectoryWalker;
import org.asciidoctor.Options;
import org.asciidoctor.cli.AsciidoctorCliOptions;
import org.asciidoctor.internal.JRubyAsciidoctor;
import org.asciidoctor.internal.JRubyRuntimeContext;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class AsciidoctorInvoker {
    public void invoke(String ... parameters2) {
        AsciidoctorCliOptions asciidoctorCliOptions = new AsciidoctorCliOptions();
        JCommander jCommander = new JCommander((Object)asciidoctorCliOptions, parameters2);
        if (asciidoctorCliOptions.isHelp() || parameters2.length == 0) {
            jCommander.setProgramName("asciidoctor");
            jCommander.usage();
        } else {
            Asciidoctor asciidoctor = this.buildAsciidoctorJInstance(asciidoctorCliOptions);
            if (asciidoctorCliOptions.isVersion()) {
                System.out.println("Asciidoctor " + asciidoctor.asciidoctorVersion() + " [http://asciidoctor.org]");
                return;
            }
            List<File> inputFiles = this.getInputFiles(asciidoctorCliOptions);
            if (inputFiles.isEmpty()) {
                System.err.println("asciidoctor: FAILED: input file(s) '" + asciidoctorCliOptions.getParameters() + "' missing or cannot be read");
                throw new IllegalArgumentException("asciidoctor: FAILED: input file(s) '" + asciidoctorCliOptions.getParameters() + "' missing or cannot be read");
            }
            Options options2 = asciidoctorCliOptions.parse();
            if (asciidoctorCliOptions.isRequire()) {
                for (String require : asciidoctorCliOptions.getRequire()) {
                    RubyUtils.requireLibrary(JRubyRuntimeContext.get(), require);
                }
            }
            this.setTimingsMode(asciidoctorCliOptions, options2);
            this.setVerboseLevel(asciidoctorCliOptions);
            String output = this.renderInput(asciidoctor, options2, inputFiles);
            if (asciidoctorCliOptions.isTimings()) {
                Map<String, Object> optionsMap = options2.map();
                IRubyObject timings = (IRubyObject)optionsMap.get("timings");
                timings.callMethod(JRubyRuntimeContext.get().getCurrentContext(), "print_report");
            }
            if (!"".equals(output.trim())) {
                System.out.println(output);
            }
        }
    }

    private void setTimingsMode(AsciidoctorCliOptions asciidoctorCliOptions, Options options2) {
        if (asciidoctorCliOptions.isTimings()) {
            options2.setOption("timings", JRubyRuntimeContext.get().evalScriptlet("Asciidoctor::Timings.new"));
        }
    }

    private void setVerboseLevel(AsciidoctorCliOptions asciidoctorCliOptions) {
        if (asciidoctorCliOptions.isVerbose()) {
            RubyUtils.setGlobalVariable(JRubyRuntimeContext.get(), "VERBOSE", "true");
        } else if (asciidoctorCliOptions.isQuiet()) {
            RubyUtils.setGlobalVariable(JRubyRuntimeContext.get(), "VERBOSE", "nil");
        }
    }

    private Asciidoctor buildAsciidoctorJInstance(AsciidoctorCliOptions asciidoctorCliOptions) {
        Asciidoctor asciidoctor = asciidoctorCliOptions.isLoadPaths() ? JRubyAsciidoctor.create(asciidoctorCliOptions.getLoadPaths()) : JRubyAsciidoctor.create((String)null);
        return asciidoctor;
    }

    private String renderInput(Asciidoctor asciidoctor, Options options2, List<File> inputFiles) {
        StringBuilder output = new StringBuilder();
        for (File inputFile : inputFiles) {
            if (inputFile.canRead()) {
                String renderedFile = asciidoctor.renderFile(inputFile, options2);
                if (renderedFile == null) continue;
                output.append(renderedFile).append(System.getProperty("line.separator"));
                continue;
            }
            System.err.println("asciidoctor: FAILED: input file(s) '" + inputFile.getAbsolutePath() + "' missing or cannot be read");
            throw new IllegalArgumentException("asciidoctor: FAILED: input file(s) '" + inputFile.getAbsolutePath() + "' missing or cannot be read");
        }
        return output.toString();
    }

    private String readInputFromStdIn() {
        Scanner in = new Scanner(System.in);
        String content = in.nextLine();
        in.close();
        return content;
    }

    private List<File> getInputFiles(AsciidoctorCliOptions asciidoctorCliOptions) {
        List<String> parameters2 = asciidoctorCliOptions.getParameters();
        if (parameters2.isEmpty()) {
            System.err.println("asciidoctor: FAILED: input file missing");
            throw new IllegalArgumentException("asciidoctor: FAILED: input file missing");
        }
        if (parameters2.contains("-")) {
            System.err.println("asciidoctor:  FAILED: input file is required instead of an argument.");
            throw new IllegalArgumentException("asciidoctor:  FAILED: input file is required instead of an argument.");
        }
        ArrayList<File> filesToBeRendered = new ArrayList<File>();
        for (String globExpression : parameters2) {
            GlobDirectoryWalker globDirectoryWalker = new GlobDirectoryWalker(globExpression);
            filesToBeRendered.addAll(globDirectoryWalker.scan());
        }
        return filesToBeRendered;
    }

    public static void main(String[] args2) {
        new AsciidoctorInvoker().invoke(args2);
    }
}

