/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class NGInputStream
extends FilterInputStream {
    private DataInputStream din = (DataInputStream)this.in;
    private boolean eof = false;
    private long remaining = 0L;
    private byte[] oneByteBuffer = null;
    private final DataOutputStream out;
    private boolean started = false;

    public NGInputStream(InputStream in, DataOutputStream out) {
        super(in);
        this.out = out;
    }

    private void readHeader() throws IOException {
        if (this.eof) {
            return;
        }
        int hlen = this.din.readInt();
        byte chunkType = this.din.readByte();
        switch (chunkType) {
            case 48: {
                this.remaining = hlen;
                break;
            }
            case 46: {
                this.eof = true;
                break;
            }
            default: {
                throw new IOException("Unknown stream type: " + (char)chunkType);
            }
        }
    }

    public int available() throws IOException {
        if (this.eof) {
            return 0;
        }
        if (this.remaining > 0L) {
            return this.in.available();
        }
        return Math.max(0, this.in.available() - 5);
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.oneByteBuffer == null) {
            this.oneByteBuffer = new byte[1];
        }
        return this.read(this.oneByteBuffer, 0, 1) == -1 ? -1 : this.oneByteBuffer[0];
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b2, int offset2, int length2) throws IOException {
        if (!this.started) {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.writeInt(0);
                this.out.writeByte(83);
                this.out.flush();
                this.started = true;
            }
        }
        if (this.remaining == 0L) {
            this.readHeader();
        }
        if (this.eof) {
            return -1;
        }
        int bytesToRead = Math.min((int)this.remaining, length2);
        int result2 = this.in.read(b2, offset2, bytesToRead);
        this.remaining -= (long)result2;
        return result2;
    }
}

