/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.darwin;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Errno implements Constant
{
    EPERM(1L),
    ENOENT(2L),
    ESRCH(3L),
    EINTR(4L),
    EIO(5L),
    ENXIO(6L),
    E2BIG(7L),
    ENOEXEC(8L),
    EBADF(9L),
    ECHILD(10L),
    EDEADLK(11L),
    ENOMEM(12L),
    EACCES(13L),
    EFAULT(14L),
    ENOTBLK(15L),
    EBUSY(16L),
    EEXIST(17L),
    EXDEV(18L),
    ENODEV(19L),
    ENOTDIR(20L),
    EISDIR(21L),
    EINVAL(22L),
    ENFILE(23L),
    EMFILE(24L),
    ENOTTY(25L),
    ETXTBSY(26L),
    EFBIG(27L),
    ENOSPC(28L),
    ESPIPE(29L),
    EROFS(30L),
    EMLINK(31L),
    EPIPE(32L),
    EDOM(33L),
    ERANGE(34L),
    EWOULDBLOCK(35L),
    EAGAIN(35L),
    EINPROGRESS(36L),
    EALREADY(37L),
    ENOTSOCK(38L),
    EDESTADDRREQ(39L),
    EMSGSIZE(40L),
    EPROTOTYPE(41L),
    ENOPROTOOPT(42L),
    EPROTONOSUPPORT(43L),
    ESOCKTNOSUPPORT(44L),
    EOPNOTSUPP(102L),
    EPFNOSUPPORT(46L),
    EAFNOSUPPORT(47L),
    EADDRINUSE(48L),
    EADDRNOTAVAIL(49L),
    ENETDOWN(50L),
    ENETUNREACH(51L),
    ENETRESET(52L),
    ECONNABORTED(53L),
    ECONNRESET(54L),
    ENOBUFS(55L),
    EISCONN(56L),
    ENOTCONN(57L),
    ESHUTDOWN(58L),
    ETOOMANYREFS(59L),
    ETIMEDOUT(60L),
    ECONNREFUSED(61L),
    ELOOP(62L),
    ENAMETOOLONG(63L),
    EHOSTDOWN(64L),
    EHOSTUNREACH(65L),
    ENOTEMPTY(66L),
    EUSERS(68L),
    EDQUOT(69L),
    ESTALE(70L),
    EREMOTE(71L),
    ENOLCK(77L),
    ENOSYS(78L),
    EOVERFLOW(84L),
    EIDRM(90L),
    ENOMSG(91L),
    EILSEQ(92L),
    EBADMSG(94L),
    EMULTIHOP(95L),
    ENODATA(96L),
    ENOLINK(97L),
    ENOSR(98L),
    ENOSTR(99L),
    EPROTO(100L),
    ETIME(101L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 102L;

    private Errno(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringTable {
        public static final Map<Errno, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<Errno, String> generateTable() {
            EnumMap<Errno, String> map2 = new EnumMap<Errno, String>(Errno.class);
            map2.put(EPERM, "Operation not permitted");
            map2.put(ENOENT, "No such file or directory");
            map2.put(ESRCH, "No such process");
            map2.put(EINTR, "Interrupted system call");
            map2.put(EIO, "Input/output error");
            map2.put(ENXIO, "Device not configured");
            map2.put(E2BIG, "Argument list too long");
            map2.put(ENOEXEC, "Exec format error");
            map2.put(EBADF, "Bad file descriptor");
            map2.put(ECHILD, "No child processes");
            map2.put(EDEADLK, "Resource deadlock avoided");
            map2.put(ENOMEM, "Cannot allocate memory");
            map2.put(EACCES, "Permission denied");
            map2.put(EFAULT, "Bad address");
            map2.put(ENOTBLK, "Block device required");
            map2.put(EBUSY, "Resource busy");
            map2.put(EEXIST, "File exists");
            map2.put(EXDEV, "Cross-device link");
            map2.put(ENODEV, "Operation not supported by device");
            map2.put(ENOTDIR, "Not a directory");
            map2.put(EISDIR, "Is a directory");
            map2.put(EINVAL, "Invalid argument");
            map2.put(ENFILE, "Too many open files in system");
            map2.put(EMFILE, "Too many open files");
            map2.put(ENOTTY, "Inappropriate ioctl for device");
            map2.put(ETXTBSY, "Text file busy");
            map2.put(EFBIG, "File too large");
            map2.put(ENOSPC, "No space left on device");
            map2.put(ESPIPE, "Illegal seek");
            map2.put(EROFS, "Read-only file system");
            map2.put(EMLINK, "Too many links");
            map2.put(EPIPE, "Broken pipe");
            map2.put(EDOM, "Numerical argument out of domain");
            map2.put(ERANGE, "Result too large");
            map2.put(EWOULDBLOCK, "Resource temporarily unavailable");
            map2.put(EAGAIN, "Resource temporarily unavailable");
            map2.put(EINPROGRESS, "Operation now in progress");
            map2.put(EALREADY, "Operation already in progress");
            map2.put(ENOTSOCK, "Socket operation on non-socket");
            map2.put(EDESTADDRREQ, "Destination address required");
            map2.put(EMSGSIZE, "Message too long");
            map2.put(EPROTOTYPE, "Protocol wrong type for socket");
            map2.put(ENOPROTOOPT, "Protocol not available");
            map2.put(EPROTONOSUPPORT, "Protocol not supported");
            map2.put(ESOCKTNOSUPPORT, "Socket type not supported");
            map2.put(EOPNOTSUPP, "Operation not supported on socket");
            map2.put(EPFNOSUPPORT, "Protocol family not supported");
            map2.put(EAFNOSUPPORT, "Address family not supported by protocol family");
            map2.put(EADDRINUSE, "Address already in use");
            map2.put(EADDRNOTAVAIL, "Can't assign requested address");
            map2.put(ENETDOWN, "Network is down");
            map2.put(ENETUNREACH, "Network is unreachable");
            map2.put(ENETRESET, "Network dropped connection on reset");
            map2.put(ECONNABORTED, "Software caused connection abort");
            map2.put(ECONNRESET, "Connection reset by peer");
            map2.put(ENOBUFS, "No buffer space available");
            map2.put(EISCONN, "Socket is already connected");
            map2.put(ENOTCONN, "Socket is not connected");
            map2.put(ESHUTDOWN, "Can't send after socket shutdown");
            map2.put(ETOOMANYREFS, "Too many references: can't splice");
            map2.put(ETIMEDOUT, "Operation timed out");
            map2.put(ECONNREFUSED, "Connection refused");
            map2.put(ELOOP, "Too many levels of symbolic links");
            map2.put(ENAMETOOLONG, "File name too long");
            map2.put(EHOSTDOWN, "Host is down");
            map2.put(EHOSTUNREACH, "No route to host");
            map2.put(ENOTEMPTY, "Directory not empty");
            map2.put(EUSERS, "Too many users");
            map2.put(EDQUOT, "Disc quota exceeded");
            map2.put(ESTALE, "Stale NFS file handle");
            map2.put(EREMOTE, "Too many levels of remote in path");
            map2.put(ENOLCK, "No locks available");
            map2.put(ENOSYS, "Function not implemented");
            map2.put(EOVERFLOW, "Value too large to be stored in data type");
            map2.put(EIDRM, "Identifier removed");
            map2.put(ENOMSG, "No message of desired type");
            map2.put(EILSEQ, "Illegal byte sequence");
            map2.put(EBADMSG, "Bad message");
            map2.put(EMULTIHOP, "EMULTIHOP (Reserved)");
            map2.put(ENODATA, "No message available on STREAM");
            map2.put(ENOLINK, "ENOLINK (Reserved)");
            map2.put(ENOSR, "No STREAM resources");
            map2.put(ENOSTR, "Not a STREAM");
            map2.put(EPROTO, "Protocol error");
            map2.put(ETIME, "STREAM ioctl timeout");
            return map2;
        }
    }
}

