/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.ThreadMonitor;

public class FileSystemUtils {
    private static final FileSystemUtils INSTANCE = new FileSystemUtils();
    private static final int INIT_PROBLEM = -1;
    private static final int OTHER = 0;
    private static final int WINDOWS = 1;
    private static final int UNIX = 2;
    private static final int POSIX_UNIX = 3;
    private static final int OS;
    private static final String DF;

    @Deprecated
    public static long freeSpace(String path2) throws IOException {
        return INSTANCE.freeSpaceOS(path2, OS, false, -1L);
    }

    public static long freeSpaceKb(String path2) throws IOException {
        return FileSystemUtils.freeSpaceKb(path2, -1L);
    }

    public static long freeSpaceKb(String path2, long timeout2) throws IOException {
        return INSTANCE.freeSpaceOS(path2, OS, true, timeout2);
    }

    public static long freeSpaceKb() throws IOException {
        return FileSystemUtils.freeSpaceKb(-1L);
    }

    public static long freeSpaceKb(long timeout2) throws IOException {
        return FileSystemUtils.freeSpaceKb(new File(".").getAbsolutePath(), timeout2);
    }

    long freeSpaceOS(String path2, int os, boolean kb, long timeout2) throws IOException {
        if (path2 == null) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        switch (os) {
            case 1: {
                return kb ? this.freeSpaceWindows(path2, timeout2) / 1024L : this.freeSpaceWindows(path2, timeout2);
            }
            case 2: {
                return this.freeSpaceUnix(path2, kb, false, timeout2);
            }
            case 3: {
                return this.freeSpaceUnix(path2, kb, true, timeout2);
            }
            case 0: {
                throw new IllegalStateException("Unsupported operating system");
            }
        }
        throw new IllegalStateException("Exception caught when determining operating system");
    }

    long freeSpaceWindows(String path2, long timeout2) throws IOException {
        if ((path2 = FilenameUtils.normalize(path2, false)).length() > 0 && path2.charAt(0) != '\"') {
            path2 = "\"" + path2 + "\"";
        }
        String[] cmdAttribs = new String[]{"cmd.exe", "/C", "dir /a /-c " + path2};
        List<String> lines2 = this.performCommand(cmdAttribs, Integer.MAX_VALUE, timeout2);
        for (int i2 = lines2.size() - 1; i2 >= 0; --i2) {
            String line = lines2.get(i2);
            if (line.length() <= 0) continue;
            return this.parseDir(line, path2);
        }
        throw new IOException("Command line 'dir /-c' did not return any info for path '" + path2 + "'");
    }

    long parseDir(String line, String path2) throws IOException {
        char c;
        int j;
        int bytesStart = 0;
        int bytesEnd = 0;
        for (j = line.length() - 1; j >= 0; --j) {
            c = line.charAt(j);
            if (!Character.isDigit(c)) continue;
            bytesEnd = j + 1;
            break;
        }
        while (j >= 0) {
            c = line.charAt(j);
            if (!Character.isDigit(c) && c != ',' && c != '.') {
                bytesStart = j + 1;
                break;
            }
            --j;
        }
        if (j < 0) {
            throw new IOException("Command line 'dir /-c' did not return valid info for path '" + path2 + "'");
        }
        StringBuilder buf = new StringBuilder(line.substring(bytesStart, bytesEnd));
        for (int k = 0; k < buf.length(); ++k) {
            if (buf.charAt(k) != ',' && buf.charAt(k) != '.') continue;
            buf.deleteCharAt(k--);
        }
        return this.parseBytes(buf.toString(), path2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long freeSpaceUnix(String path2, boolean kb, boolean posix, long timeout2) throws IOException {
        String[] stringArray;
        if (path2.length() == 0) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        String flags2 = "-";
        if (kb) {
            flags2 = flags2 + "k";
        }
        if (posix) {
            flags2 = flags2 + "P";
        }
        if (flags2.length() > 1) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = DF;
            stringArray2[1] = flags2;
            stringArray = stringArray2;
            stringArray2[2] = path2;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = DF;
            stringArray = stringArray3;
            stringArray3[1] = path2;
        }
        String[] cmdAttribs = stringArray;
        List<String> lines2 = this.performCommand(cmdAttribs, 3, timeout2);
        if (lines2.size() < 2) {
            throw new IOException("Command line '" + DF + "' did not return info as expected " + "for path '" + path2 + "'- response was " + lines2);
        }
        String line2 = lines2.get(1);
        StringTokenizer tok = new StringTokenizer(line2, " ");
        if (tok.countTokens() < 4) {
            if (tok.countTokens() != 1 || lines2.size() < 3) throw new IOException("Command line '" + DF + "' did not return data as expected " + "for path '" + path2 + "'- check path is valid");
            String line3 = lines2.get(2);
            tok = new StringTokenizer(line3, " ");
        } else {
            tok.nextToken();
        }
        tok.nextToken();
        tok.nextToken();
        String freeSpace = tok.nextToken();
        return this.parseBytes(freeSpace, path2);
    }

    long parseBytes(String freeSpace, String path2) throws IOException {
        try {
            long bytes2 = Long.parseLong(freeSpace);
            if (bytes2 < 0L) {
                throw new IOException("Command line '" + DF + "' did not find free space in response " + "for path '" + path2 + "'- check path is valid");
            }
            return bytes2;
        }
        catch (NumberFormatException ex) {
            throw new IOExceptionWithCause("Command line '" + DF + "' did not return numeric data as expected " + "for path '" + path2 + "'- check path is valid", ex);
        }
    }

    List<String> performCommand(String[] cmdAttribs, int max2, long timeout2) throws IOException {
        ArrayList<String> arrayList;
        ArrayList<String> lines2 = new ArrayList<String>(20);
        Process proc2 = null;
        InputStream in = null;
        OutputStream out = null;
        InputStream err = null;
        BufferedReader inr = null;
        try {
            Thread monitor = ThreadMonitor.start(timeout2);
            proc2 = this.openProcess(cmdAttribs);
            in = proc2.getInputStream();
            out = proc2.getOutputStream();
            err = proc2.getErrorStream();
            inr = new BufferedReader(new InputStreamReader(in));
            String line = inr.readLine();
            while (line != null && lines2.size() < max2) {
                line = line.toLowerCase(Locale.ENGLISH).trim();
                lines2.add(line);
                line = inr.readLine();
            }
            proc2.waitFor();
            ThreadMonitor.stop(monitor);
            if (proc2.exitValue() != 0) {
                throw new IOException("Command line returned OS error code '" + proc2.exitValue() + "' for command " + Arrays.asList(cmdAttribs));
            }
            if (lines2.isEmpty()) {
                throw new IOException("Command line did not return any info for command " + Arrays.asList(cmdAttribs));
            }
            arrayList = lines2;
        }
        catch (InterruptedException ex) {
            try {
                throw new IOExceptionWithCause("Command line threw an InterruptedException for command " + Arrays.asList(cmdAttribs) + " timeout=" + timeout2, ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(err);
                IOUtils.closeQuietly(inr);
                if (proc2 != null) {
                    proc2.destroy();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(out);
        IOUtils.closeQuietly(err);
        IOUtils.closeQuietly(inr);
        if (proc2 != null) {
            proc2.destroy();
        }
        return arrayList;
    }

    Process openProcess(String[] cmdAttribs) throws IOException {
        return Runtime.getRuntime().exec(cmdAttribs);
    }

    static {
        int os = 0;
        String dfPath = "df";
        try {
            String osName = System.getProperty("os.name");
            if (osName == null) {
                throw new IOException("os.name not found");
            }
            if ((osName = osName.toLowerCase(Locale.ENGLISH)).indexOf("windows") != -1) {
                os = 1;
            } else if (osName.indexOf("linux") != -1 || osName.indexOf("mpe/ix") != -1 || osName.indexOf("freebsd") != -1 || osName.indexOf("irix") != -1 || osName.indexOf("digital unix") != -1 || osName.indexOf("unix") != -1 || osName.indexOf("mac os x") != -1) {
                os = 2;
            } else if (osName.indexOf("sun os") != -1 || osName.indexOf("sunos") != -1 || osName.indexOf("solaris") != -1) {
                os = 3;
                dfPath = "/usr/xpg4/bin/df";
            } else {
                os = osName.indexOf("hp-ux") != -1 || osName.indexOf("aix") != -1 ? 3 : 0;
            }
        }
        catch (Exception ex) {
            os = -1;
        }
        OS = os;
        DF = dfPath;
    }
}

