/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.Reader;
import java.io.Serializable;

public class CharSequenceReader
extends Reader
implements Serializable {
    private final CharSequence charSequence;
    private int idx;
    private int mark;

    public CharSequenceReader(CharSequence charSequence) {
        this.charSequence = charSequence != null ? charSequence : "";
    }

    @Override
    public void close() {
        this.idx = 0;
        this.mark = 0;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.idx;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        if (this.idx >= this.charSequence.length()) {
            return -1;
        }
        return this.charSequence.charAt(this.idx++);
    }

    @Override
    public int read(char[] array, int offset2, int length2) {
        if (this.idx >= this.charSequence.length()) {
            return -1;
        }
        if (array == null) {
            throw new NullPointerException("Character array is missing");
        }
        if (length2 < 0 || offset2 < 0 || offset2 + length2 > array.length) {
            throw new IndexOutOfBoundsException("Array Size=" + array.length + ", offset=" + offset2 + ", length=" + length2);
        }
        int count2 = 0;
        for (int i2 = 0; i2 < length2; ++i2) {
            int c = this.read();
            if (c == -1) {
                return count2;
            }
            array[offset2 + i2] = (char)c;
            ++count2;
        }
        return count2;
    }

    @Override
    public void reset() {
        this.idx = this.mark;
    }

    @Override
    public long skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Number of characters to skip is less than zero: " + n);
        }
        if (this.idx >= this.charSequence.length()) {
            return -1L;
        }
        int dest = (int)Math.min((long)this.charSequence.length(), (long)this.idx + n);
        int count2 = dest - this.idx;
        this.idx = dest;
        return count2;
    }

    public String toString() {
        return ((Object)this.charSequence).toString();
    }
}

