/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileWriterWithEncoding
extends Writer {
    private final Writer out;

    public FileWriterWithEncoding(String filename2, String encoding2) throws IOException {
        this(new File(filename2), encoding2, false);
    }

    public FileWriterWithEncoding(String filename2, String encoding2, boolean append2) throws IOException {
        this(new File(filename2), encoding2, append2);
    }

    public FileWriterWithEncoding(String filename2, Charset encoding2) throws IOException {
        this(new File(filename2), encoding2, false);
    }

    public FileWriterWithEncoding(String filename2, Charset encoding2, boolean append2) throws IOException {
        this(new File(filename2), encoding2, append2);
    }

    public FileWriterWithEncoding(String filename2, CharsetEncoder encoding2) throws IOException {
        this(new File(filename2), encoding2, false);
    }

    public FileWriterWithEncoding(String filename2, CharsetEncoder encoding2, boolean append2) throws IOException {
        this(new File(filename2), encoding2, append2);
    }

    public FileWriterWithEncoding(File file2, String encoding2) throws IOException {
        this(file2, encoding2, false);
    }

    public FileWriterWithEncoding(File file2, String encoding2, boolean append2) throws IOException {
        this.out = FileWriterWithEncoding.initWriter(file2, encoding2, append2);
    }

    public FileWriterWithEncoding(File file2, Charset encoding2) throws IOException {
        this(file2, encoding2, false);
    }

    public FileWriterWithEncoding(File file2, Charset encoding2, boolean append2) throws IOException {
        this.out = FileWriterWithEncoding.initWriter(file2, encoding2, append2);
    }

    public FileWriterWithEncoding(File file2, CharsetEncoder encoding2) throws IOException {
        this(file2, encoding2, false);
    }

    public FileWriterWithEncoding(File file2, CharsetEncoder encoding2, boolean append2) throws IOException {
        this.out = FileWriterWithEncoding.initWriter(file2, encoding2, append2);
    }

    private static Writer initWriter(File file2, Object encoding2, boolean append2) throws IOException {
        if (file2 == null) {
            throw new NullPointerException("File is missing");
        }
        if (encoding2 == null) {
            throw new NullPointerException("Encoding is missing");
        }
        boolean fileExistedAlready = file2.exists();
        FileOutputStream stream = null;
        OutputStreamWriter writer = null;
        try {
            stream = new FileOutputStream(file2, append2);
            writer = encoding2 instanceof Charset ? new OutputStreamWriter((OutputStream)stream, (Charset)encoding2) : (encoding2 instanceof CharsetEncoder ? new OutputStreamWriter((OutputStream)stream, (CharsetEncoder)encoding2) : new OutputStreamWriter((OutputStream)stream, (String)encoding2));
        }
        catch (IOException ex) {
            IOUtils.closeQuietly(writer);
            IOUtils.closeQuietly(stream);
            if (!fileExistedAlready) {
                FileUtils.deleteQuietly(file2);
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            IOUtils.closeQuietly(writer);
            IOUtils.closeQuietly(stream);
            if (!fileExistedAlready) {
                FileUtils.deleteQuietly(file2);
            }
            throw ex;
        }
        return writer;
    }

    @Override
    public void write(int idx) throws IOException {
        this.out.write(idx);
    }

    @Override
    public void write(char[] chr2) throws IOException {
        this.out.write(chr2);
    }

    @Override
    public void write(char[] chr2, int st, int end2) throws IOException {
        this.out.write(chr2, st, end2);
    }

    @Override
    public void write(String str) throws IOException {
        this.out.write(str);
    }

    @Override
    public void write(String str, int st, int end2) throws IOException {
        this.out.write(str, st, end2);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

