/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.asciidoctor.DirectoryWalker;

public class GlobDirectoryWalker
implements DirectoryWalker {
    private final File rootDirectory;
    private final File canonicalRootDir;
    private final List<File> matches = new ArrayList<File>();
    private final String globExpression;

    public GlobDirectoryWalker(String globExpression) {
        int indexOfUnglobbedPart = this.findIndexOfUnglobbedPart(globExpression);
        String unglobbedPart = globExpression.substring(0, indexOfUnglobbedPart + 1);
        this.rootDirectory = new File(unglobbedPart).getAbsoluteFile();
        this.globExpression = globExpression.substring(indexOfUnglobbedPart + 1);
        this.checkInput(this.rootDirectory);
        this.canonicalRootDir = this.getCanonicalPath(this.rootDirectory);
    }

    private int findIndexOfUnglobbedPart(String globExpression) {
        int result2 = -1;
        block4: for (int i2 = 0; i2 < globExpression.length(); ++i2) {
            switch (globExpression.charAt(i2)) {
                case '/': 
                case '\\': {
                    result2 = i2;
                    continue block4;
                }
                case '*': {
                    return result2;
                }
            }
        }
        return result2;
    }

    @Override
    public List<File> scan() {
        Pattern pattern = new Pattern(this.globExpression);
        this.scanDir(this.canonicalRootDir, Arrays.asList(pattern));
        return this.matches;
    }

    private void checkInput(File rootDir) {
        if (!rootDir.exists()) {
            throw new IllegalArgumentException("Directory does not exist: " + rootDir);
        }
        if (!rootDir.isDirectory()) {
            throw new IllegalArgumentException("File must be a directory: " + rootDir);
        }
    }

    private File getCanonicalPath(File rootDir) {
        try {
            rootDir = rootDir.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Error determining canonical path: " + rootDir, ex);
        }
        return rootDir;
    }

    private void scanDir(File dir, List<Pattern> includes) {
        if (!dir.canRead()) {
            return;
        }
        if (this.isGlobalExpression(includes)) {
            this.findFilesThroughMatchingDirectories(dir, includes);
        } else {
            this.findFileInSpecificLocation(dir, includes);
        }
    }

    private void findFileInSpecificLocation(File dir, List<Pattern> includes) {
        ArrayList<Pattern> matchingIncludes = new ArrayList<Pattern>(1);
        for (Pattern include2 : includes) {
            if (matchingIncludes.isEmpty()) {
                matchingIncludes.add(include2);
            } else {
                matchingIncludes.set(0, include2);
            }
            this.process(dir, include2.value, matchingIncludes);
        }
    }

    private void findFilesThroughMatchingDirectories(File dir, List<Pattern> includes) {
        for (String fileName : dir.list()) {
            ArrayList<Pattern> matchingIncludes = new ArrayList<Pattern>(includes.size());
            for (Pattern include2 : includes) {
                if (!include2.matches(fileName)) continue;
                matchingIncludes.add(include2);
            }
            if (matchingIncludes.isEmpty()) continue;
            this.process(dir, fileName, matchingIncludes);
        }
    }

    private void process(File dir, String fileName, List<Pattern> matchingIncludes) {
        boolean isFinalMatch = false;
        ArrayList<Pattern> incrementedPatterns = new ArrayList<Pattern>();
        Iterator<Pattern> iter = matchingIncludes.iterator();
        while (iter.hasNext()) {
            Pattern include2 = iter.next();
            if (include2.incr(fileName)) {
                incrementedPatterns.add(include2);
                if (include2.isExhausted()) {
                    iter.remove();
                }
            }
            if (!include2.wasFinalMatch()) continue;
            isFinalMatch = true;
        }
        File file2 = new File(dir, fileName);
        if (isFinalMatch) {
            int length2 = this.canonicalRootDir.getPath().length();
            if (!this.canonicalRootDir.getPath().endsWith(File.separator)) {
                ++length2;
            }
            this.matches.add(new File(this.rootDirectory, file2.getPath().substring(length2)));
        }
        if (!matchingIncludes.isEmpty() && file2.isDirectory()) {
            this.scanDir(file2, matchingIncludes);
        }
        for (Pattern include3 : incrementedPatterns) {
            include3.decr();
        }
    }

    private boolean isGlobalExpression(List<Pattern> includes) {
        boolean scanAll = false;
        for (Pattern include2 : includes) {
            if (include2.value.indexOf(42) == -1 && include2.value.indexOf(63) == -1) continue;
            scanAll = true;
            break;
        }
        return scanAll;
    }

    static class Pattern {
        String value;
        final String[] values;
        private int index;

        Pattern(String pattern) {
            pattern = pattern.replace('\\', '/');
            pattern = pattern.replaceAll("\\*\\*[^/]", "**/*");
            pattern = pattern.replaceAll("[^/]\\*\\*", "*/**");
            this.values = pattern.split("/");
            this.value = this.values[0];
        }

        boolean matches(String fileName) {
            int j;
            if (this.value.equals("**")) {
                return true;
            }
            if (this.value.indexOf(42) == -1 && this.value.indexOf(63) == -1) {
                return fileName.equals(this.value);
            }
            int i2 = 0;
            for (j = 0; i2 < fileName.length() && j < this.value.length() && this.value.charAt(j) != '*'; ++i2, ++j) {
                if (this.value.charAt(j) == fileName.charAt(i2) || this.value.charAt(j) == '?') continue;
                return false;
            }
            if (j == this.value.length()) {
                return fileName.length() == this.value.length();
            }
            int cp = 0;
            int mp = 0;
            while (i2 < fileName.length()) {
                if (j < this.value.length() && this.value.charAt(j) == '*') {
                    if (j++ >= this.value.length()) {
                        return true;
                    }
                    mp = j;
                    cp = i2 + 1;
                    continue;
                }
                if (j < this.value.length() && (this.value.charAt(j) == fileName.charAt(i2) || this.value.charAt(j) == '?')) {
                    ++j;
                    ++i2;
                    continue;
                }
                j = mp;
                i2 = cp++;
            }
            while (j < this.value.length() && this.value.charAt(j) == '*') {
                ++j;
            }
            return j >= this.value.length();
        }

        String nextValue() {
            if (this.index + 1 == this.values.length) {
                return null;
            }
            return this.values[this.index + 1];
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean incr(String fileName) {
            if (!this.value.equals("**")) {
                this.incr();
                return true;
            }
            if (this.index == this.values.length - 1) {
                return false;
            }
            this.incr();
            if (this.matches(fileName)) {
                this.incr();
                return true;
            }
            this.decr();
            return false;
        }

        void incr() {
            ++this.index;
            this.value = this.index >= this.values.length ? null : this.values[this.index];
        }

        void decr() {
            --this.index;
            if (this.index > 0 && this.values[this.index - 1].equals("**")) {
                --this.index;
            }
            this.value = this.values[this.index];
        }

        void reset() {
            this.index = 0;
            this.value = this.values[0];
        }

        boolean isExhausted() {
            return this.index >= this.values.length;
        }

        boolean isLast() {
            return this.index >= this.values.length - 1;
        }

        boolean wasFinalMatch() {
            return this.isExhausted() || this.isLast() && this.value.equals("**");
        }
    }
}

