/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.asciidoctor.ast.ContentPart;
import org.asciidoctor.ast.DocumentHeader;

public class StructuredDocument {
    private DocumentHeader header;
    private List<ContentPart> parts;

    private StructuredDocument() {
    }

    public List<ContentPart> getParts() {
        return this.parts;
    }

    public DocumentHeader getHeader() {
        return this.header;
    }

    public ContentPart getPartById(String id2) {
        if (id2 != null) {
            for (ContentPart part : this.parts) {
                if (!id2.equals(part.getId())) continue;
                return part;
            }
        }
        return null;
    }

    public ContentPart getPartByStyle(String style) {
        if (style != null) {
            for (ContentPart part : this.parts) {
                if (!style.equals(part.getStyle())) continue;
                return part;
            }
        }
        return null;
    }

    public ContentPart getPartByRole(String role) {
        if (role != null) {
            for (ContentPart part : this.parts) {
                if (!role.equals(part.getRole())) continue;
                return part;
            }
        }
        return null;
    }

    public List<ContentPart> getPartsByContext(String context) {
        if (context != null) {
            ArrayList<ContentPart> filteredParts = new ArrayList<ContentPart>();
            for (ContentPart part : this.parts) {
                if (!context.equals(part.getContext())) continue;
                filteredParts.add(part);
            }
            return filteredParts;
        }
        return Collections.emptyList();
    }

    public List<ContentPart> getPartsByStyle(String style) {
        if (style != null) {
            ArrayList<ContentPart> filteredParts = new ArrayList<ContentPart>();
            for (ContentPart part : this.parts) {
                if (!style.equals(part.getStyle())) continue;
                filteredParts.add(part);
            }
            return filteredParts;
        }
        return Collections.emptyList();
    }

    public List<ContentPart> getPartsByRole(String role) {
        if (role != null) {
            ArrayList<ContentPart> filteredParts = new ArrayList<ContentPart>();
            for (ContentPart part : this.parts) {
                if (!role.equals(part.getRole())) continue;
                filteredParts.add(part);
            }
            return filteredParts;
        }
        return Collections.emptyList();
    }

    public static StructuredDocument createStructuredDocument(DocumentHeader header, List<ContentPart> parts) {
        StructuredDocument document = new StructuredDocument();
        document.header = header;
        document.parts = parts;
        return document;
    }
}

