/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.converter;

import java.util.HashMap;
import java.util.Map;
import org.asciidoctor.converter.Converter;
import org.asciidoctor.converter.ConverterFor;
import org.asciidoctor.converter.ConverterProxy;
import org.asciidoctor.converter.OutputFormatWriter;
import org.asciidoctor.internal.AsciidoctorModule;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaConverterRegistry {
    private AsciidoctorModule asciidoctorModule;
    private Ruby rubyRuntime;

    public JavaConverterRegistry(AsciidoctorModule asciidoctorModule, Ruby rubyRuntime) {
        this.asciidoctorModule = asciidoctorModule;
        this.rubyRuntime = rubyRuntime;
    }

    public <U, T extends Converter<U> & OutputFormatWriter<U>> void register(Class<T> converterClass, String ... backends) {
        RubyClass clazz = ConverterProxy.register(this.rubyRuntime, converterClass);
        ConverterFor converterForAnnotation = converterClass.getAnnotation(ConverterFor.class);
        if (converterForAnnotation != null) {
            String backend = !"".equals(converterForAnnotation.format()) ? converterForAnnotation.format() : converterForAnnotation.value();
            this.asciidoctorModule.register_converter(clazz, new String[]{backend});
        } else if (backends.length == 0) {
            this.asciidoctorModule.register_converter(clazz);
        }
        if (backends.length > 0) {
            this.asciidoctorModule.register_converter(clazz, backends);
        }
    }

    public Class<?> resolve(String backend) {
        RubyClass rubyClass = this.asciidoctorModule.resolve_converter(backend);
        Class<? extends IRubyObject> clazz = rubyClass.getReifiedClass();
        if (clazz != null) {
            return clazz;
        }
        if (rubyClass.getAllocator() instanceof ConverterProxy.Allocator) {
            ConverterProxy.Allocator allocator = (ConverterProxy.Allocator)rubyClass.getAllocator();
            return allocator.getConverterClass();
        }
        return null;
    }

    public void unregisterAll() {
        this.asciidoctorModule.unregister_all_converters();
    }

    public Map<String, Class<?>> converters() {
        RubyArray rubyKeys = this.asciidoctorModule.converters();
        HashMap converters = new HashMap();
        for (IRubyObject rubyBackend : rubyKeys.getList()) {
            String backend = ((RubyString)rubyBackend).asJavaString();
            converters.put(backend, this.resolve(backend));
        }
        return converters;
    }
}

