/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.extension.processorproxies;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.asciidoctor.ast.ContentModel;
import org.asciidoctor.ast.impl.ContentNodeImpl;
import org.asciidoctor.extension.Contexts;
import org.asciidoctor.extension.DefaultAttribute;
import org.asciidoctor.extension.DefaultAttributes;
import org.asciidoctor.extension.Format;
import org.asciidoctor.extension.Location;
import org.asciidoctor.extension.Name;
import org.asciidoctor.extension.PositionalAttributes;
import org.asciidoctor.extension.Processor;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.RegexpOptions;

public class AbstractProcessorProxy<T extends Processor>
extends RubyObject {
    protected static final String MEMBER_NAME_CONFIG = "@config";
    protected static final String METHOD_NAME_INITIALIZE = "initialize";
    protected T processor;
    private Class<? extends T> processorClass;

    public AbstractProcessorProxy(Ruby runtime, RubyClass metaClass, Class<? extends T> processorClass) {
        super(runtime, metaClass);
        this.processorClass = processorClass;
    }

    public AbstractProcessorProxy(Ruby runtime, RubyClass metaClass, T processor) {
        super(runtime, metaClass);
        this.processor = processor;
    }

    protected T getProcessor() {
        return this.processor;
    }

    protected void setProcessor(T processor) {
        this.processor = processor;
    }

    public Class<? extends T> getProcessorClass() {
        return this.processorClass;
    }

    public void setProcessorClass(Class<? extends T> processorClass) {
        this.processorClass = processorClass;
    }

    T instantiateProcessor(Object ... args2) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<T> constructor2 = this.findConstructorWithMostMatchingArguments(args2);
        return (T)((Processor)constructor2.newInstance(Arrays.copyOf(args2, constructor2.getParameterTypes().length)));
    }

    private Constructor<T> findConstructorWithMostMatchingArguments(Object ... args2) {
        int numberOfMatchingArguments = -1;
        Constructor<?> bestConstructor = null;
        for (Constructor<?> constructor2 : this.getProcessorClass().getConstructors()) {
            int currentNumberOfArguments = constructor2.getParameterTypes().length;
            if (currentNumberOfArguments <= numberOfMatchingArguments || !this.isConstructorCandidate(constructor2, args2)) continue;
            numberOfMatchingArguments = currentNumberOfArguments;
            bestConstructor = constructor2;
        }
        if (bestConstructor != null) {
            return bestConstructor;
        }
        ArrayList expectedTypes = new ArrayList(args2.length);
        for (Object arg2 : args2) {
            if (arg2 == null) {
                expectedTypes.add(Void.class);
                continue;
            }
            expectedTypes.add(arg2.getClass());
        }
        throw new IllegalArgumentException("Processor class " + this.getProcessorClass() + " does not provide a constructor accepting " + expectedTypes);
    }

    private boolean isConstructorCandidate(Constructor<?> constructor2, Object ... args2) {
        if (constructor2.getParameterTypes().length > args2.length) {
            return false;
        }
        Class<?>[] constructorParameterTypes = constructor2.getParameterTypes();
        for (int i2 = 0; i2 < constructorParameterTypes.length; ++i2) {
            if (args2[i2] == null || constructorParameterTypes[i2].isAssignableFrom(args2[i2].getClass())) continue;
            return false;
        }
        return true;
    }

    public void finalizeJavaConfig() {
        ((Processor)this.getProcessor()).setConfigFinalized();
    }

    protected IRubyObject convertProcessorResult(Object o) {
        if (o instanceof ContentNodeImpl) {
            return ((ContentNodeImpl)o).getRubyObject();
        }
        return JavaEmbedUtils.javaToRuby(this.getRuntime(), o);
    }

    protected static void applyAnnotations(Class<? extends Processor> processor, RubyClass rubyClass) {
        AbstractProcessorProxy.handleLocationAnnotation(processor, rubyClass);
        AbstractProcessorProxy.handleNameAnnotation(processor, rubyClass);
        AbstractProcessorProxy.handleContentModelAnnotation(processor, rubyClass);
        AbstractProcessorProxy.handleDefaultAttributeAnnotation(processor, rubyClass);
        AbstractProcessorProxy.handleDefaultAttributesAnnotation(processor, rubyClass);
        AbstractProcessorProxy.handlePositionalAttributesAnnotation(processor, rubyClass);
        AbstractProcessorProxy.handleContextsAnnotation(processor, rubyClass);
        AbstractProcessorProxy.handleFormatAnnotation(processor, rubyClass);
    }

    private static void handleFormatAnnotation(Class<? extends Processor> processor, RubyClass rubyClass) {
        Ruby rubyRuntime = rubyClass.getRuntime();
        if (processor.isAnnotationPresent(Format.class)) {
            Format format = processor.getAnnotation(Format.class);
            switch (format.value()) {
                case CUSTOM: {
                    rubyClass.callMethod(rubyRuntime.getCurrentContext(), "option", new IRubyObject[]{rubyRuntime.newSymbol("regexp"), AbstractProcessorProxy.convertRegexp(rubyRuntime, format.regexp())});
                }
            }
            rubyClass.callMethod(rubyRuntime.getCurrentContext(), "option", new IRubyObject[]{rubyRuntime.newSymbol("format"), rubyRuntime.newSymbol(format.value().optionValue().substring(1))});
        }
    }

    private static void handleContextsAnnotation(Class<? extends Processor> processor, RubyClass rubyClass) {
        Ruby rubyRuntime = rubyClass.getRuntime();
        if (processor.isAnnotationPresent(Contexts.class)) {
            Contexts contexts = processor.getAnnotation(Contexts.class);
            RubyArray contextList = rubyRuntime.newArray();
            for (String value2 : contexts.value()) {
                contextList.add(rubyRuntime.newSymbol(value2.substring(1)));
            }
            rubyClass.callMethod(rubyRuntime.getCurrentContext(), "option", new IRubyObject[]{rubyRuntime.newSymbol("contexts"), contextList});
        }
    }

    private static void handleDefaultAttributesAnnotation(Class<? extends Processor> processor, RubyClass rubyClass) {
        Ruby rubyRuntime = rubyClass.getRuntime();
        if (processor.isAnnotationPresent(DefaultAttributes.class)) {
            DefaultAttributes defaultAttributes = processor.getAnnotation(DefaultAttributes.class);
            RubyHash defaultAttrs = RubyHash.newHash(rubyRuntime);
            for (DefaultAttribute defaultAttribute : defaultAttributes.value()) {
                defaultAttrs.put(defaultAttribute.key(), defaultAttribute.value());
            }
            rubyClass.callMethod(rubyRuntime.getCurrentContext(), "option", new IRubyObject[]{rubyRuntime.newSymbol("default_attrs"), defaultAttrs});
        }
    }

    private static void handleDefaultAttributeAnnotation(Class<? extends Processor> processor, RubyClass rubyClass) {
        Ruby rubyRuntime = rubyClass.getRuntime();
        if (processor.isAnnotationPresent(DefaultAttribute.class)) {
            DefaultAttribute defaultAttribute = processor.getAnnotation(DefaultAttribute.class);
            RubyHash defaultAttrs = RubyHash.newHash(rubyRuntime);
            defaultAttrs.put(defaultAttribute.key(), defaultAttribute.value());
            rubyClass.callMethod(rubyRuntime.getCurrentContext(), "option", new IRubyObject[]{rubyRuntime.newSymbol("default_attrs"), defaultAttrs});
        }
    }

    private static void handlePositionalAttributesAnnotation(Class<? extends Processor> processor, RubyClass rubyClass) {
        Ruby rubyRuntime = rubyClass.getRuntime();
        if (processor.isAnnotationPresent(PositionalAttributes.class)) {
            PositionalAttributes positionalAttributes = processor.getAnnotation(PositionalAttributes.class);
            RubyArray positionalAttrs = RubyArray.newArray(rubyRuntime);
            for (String positionalAttribute : positionalAttributes.value()) {
                positionalAttrs.add(positionalAttribute);
            }
            rubyClass.callMethod(rubyRuntime.getCurrentContext(), "option", new IRubyObject[]{rubyRuntime.newSymbol("pos_attrs"), positionalAttrs});
        }
    }

    private static void handleContentModelAnnotation(Class<? extends Processor> processor, RubyClass rubyClass) {
        Ruby rubyRuntime = rubyClass.getRuntime();
        if (processor.isAnnotationPresent(ContentModel.class)) {
            ContentModel contentModel = processor.getAnnotation(ContentModel.class);
            rubyClass.callMethod(rubyRuntime.getCurrentContext(), "option", new IRubyObject[]{rubyRuntime.newSymbol("content_model"), rubyRuntime.newSymbol(contentModel.value().substring(1))});
        }
    }

    private static void handleNameAnnotation(Class<? extends Processor> processor, RubyClass rubyClass) {
        Ruby rubyRuntime = rubyClass.getRuntime();
        if (processor.isAnnotationPresent(Name.class)) {
            Name name2 = processor.getAnnotation(Name.class);
            rubyClass.callMethod(rubyRuntime.getCurrentContext(), "option", new IRubyObject[]{rubyRuntime.newSymbol("name"), rubyRuntime.newString(name2.value())});
        }
    }

    private static void handleLocationAnnotation(Class<? extends Processor> processor, RubyClass rubyClass) {
        Ruby rubyRuntime = rubyClass.getRuntime();
        if (processor.isAnnotationPresent(Location.class)) {
            Location location = processor.getAnnotation(Location.class);
            rubyClass.callMethod(rubyRuntime.getCurrentContext(), "option", new IRubyObject[]{rubyRuntime.newSymbol("location"), rubyRuntime.newSymbol(location.value().optionValue().substring(1))});
        }
    }

    protected static RubyRegexp convertRegexp(Ruby runtime, CharSequence regexp2) {
        return RubyRegexp.newRegexp(runtime, regexp2.toString(), RegexpOptions.NULL_OPTIONS);
    }

    public static String getName(Class<? extends Processor> processor) {
        if (processor.isAnnotationPresent(Name.class)) {
            Name name2 = processor.getAnnotation(Name.class);
            return name2.value();
        }
        throw new IllegalArgumentException("Processor " + processor + " has no @Name annotation!");
    }
}

