/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.asciidoctor.extension.BlockMacroProcessor;
import org.asciidoctor.extension.BlockProcessor;
import org.asciidoctor.extension.DocinfoProcessor;
import org.asciidoctor.extension.ExtensionGroup;
import org.asciidoctor.extension.IncludeProcessor;
import org.asciidoctor.extension.InlineMacroProcessor;
import org.asciidoctor.extension.Postprocessor;
import org.asciidoctor.extension.Preprocessor;
import org.asciidoctor.extension.Treeprocessor;
import org.asciidoctor.extension.processorproxies.AbstractProcessorProxy;
import org.asciidoctor.extension.processorproxies.BlockMacroProcessorProxy;
import org.asciidoctor.extension.processorproxies.BlockProcessorProxy;
import org.asciidoctor.extension.processorproxies.DocinfoProcessorProxy;
import org.asciidoctor.extension.processorproxies.IncludeProcessorProxy;
import org.asciidoctor.extension.processorproxies.InlineMacroProcessorProxy;
import org.asciidoctor.extension.processorproxies.PostprocessorProxy;
import org.asciidoctor.extension.processorproxies.PreprocessorProxy;
import org.asciidoctor.extension.processorproxies.TreeprocessorProxy;
import org.asciidoctor.internal.AsciidoctorModule;
import org.asciidoctor.internal.JRubyAsciidoctor;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubySymbol;

public class ExtensionGroupImpl
implements ExtensionGroup {
    private final Ruby rubyRuntime;
    private final AsciidoctorModule asciidoctorModule;
    private final String groupName;
    private List<Registrator> registrators = new ArrayList<Registrator>();

    public ExtensionGroupImpl(String groupName, JRubyAsciidoctor asciidoctor) {
        this.groupName = groupName;
        this.rubyRuntime = asciidoctor.getRubyRuntime();
        this.asciidoctorModule = asciidoctor.getAsciidoctorModule();
    }

    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void register() {
        this.asciidoctorModule.register_extension_group(this.groupName, this);
    }

    public void registerExtensions(Registry registry) {
        for (Registrator registrator : this.registrators) {
            registrator.register(registry);
        }
    }

    @Override
    public void unregister() {
        this.asciidoctorModule.unregister_extension(this.groupName);
    }

    @Override
    public ExtensionGroup docinfoProcessor(Class<? extends DocinfoProcessor> docInfoProcessor) {
        final RubyClass rubyClass = DocinfoProcessorProxy.register(this.rubyRuntime, docInfoProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.docinfo_processor(rubyClass);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup docinfoProcessor(DocinfoProcessor docInfoProcessor) {
        final RubyClass rubyClass = DocinfoProcessorProxy.register(this.rubyRuntime, docInfoProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.docinfo_processor(rubyClass);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup docinfoProcessor(String docInfoProcessor) {
        try {
            Class<?> docinfoProcessorClass = Class.forName(docInfoProcessor);
            this.docinfoProcessor(docinfoProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public ExtensionGroup preprocessor(Class<? extends Preprocessor> preprocessor) {
        final RubyClass rubyClass = PreprocessorProxy.register(this.rubyRuntime, preprocessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.preprocessor(rubyClass);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup preprocessor(Preprocessor preprocessor) {
        final RubyClass rubyClass = PreprocessorProxy.register(this.rubyRuntime, preprocessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.preprocessor(rubyClass);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup preprocessor(String preprocessor) {
        try {
            Class<?> preprocessorClass = Class.forName(preprocessor);
            this.preprocessor(preprocessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public ExtensionGroup postprocessor(String postprocessor) {
        try {
            Class<?> postprocessorClass = Class.forName(postprocessor);
            this.postprocessor(postprocessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public ExtensionGroup postprocessor(Class<? extends Postprocessor> postprocessor) {
        final RubyClass rubyClass = PostprocessorProxy.register(this.rubyRuntime, postprocessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.postprocessor(rubyClass);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup postprocessor(Postprocessor postprocessor) {
        final RubyClass rubyClass = PostprocessorProxy.register(this.rubyRuntime, postprocessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.postprocessor(rubyClass);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup includeProcessor(String includeProcessor) {
        try {
            Class<?> includeProcessorClass = Class.forName(includeProcessor);
            this.includeProcessor(includeProcessorClass);
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ExtensionGroup includeProcessor(Class<? extends IncludeProcessor> includeProcessor) {
        final RubyClass rubyClass = IncludeProcessorProxy.register(this.rubyRuntime, includeProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.include_processor(rubyClass);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup includeProcessor(IncludeProcessor includeProcessor) {
        final RubyClass rubyClass = IncludeProcessorProxy.register(this.rubyRuntime, includeProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.include_processor(rubyClass);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup treeprocessor(Treeprocessor treeprocessor) {
        final RubyClass rubyClass = TreeprocessorProxy.register(this.rubyRuntime, treeprocessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.tree_processor(rubyClass);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup treeprocessor(Class<? extends Treeprocessor> treeProcessor) {
        final RubyClass rubyClass = TreeprocessorProxy.register(this.rubyRuntime, treeProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.tree_processor(rubyClass);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup treeprocessor(String treeProcessor) {
        try {
            Class<?> treeProcessorClass = Class.forName(treeProcessor);
            this.treeprocessor(treeProcessorClass);
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ExtensionGroup block(String blockName, String blockProcessor) {
        try {
            Class<?> blockProcessorClass = Class.forName(blockProcessor);
            return this.block(blockName, blockProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ExtensionGroup block(String blockProcessor) {
        try {
            Class<?> blockProcessorClass = Class.forName(blockProcessor);
            return this.block(blockProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ExtensionGroup block(final String blockName, Class<? extends BlockProcessor> blockProcessor) {
        final RubyClass rubyClass = BlockProcessorProxy.register(this.rubyRuntime, blockProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.block(rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(blockName));
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup block(final Class<? extends BlockProcessor> blockProcessor) {
        final RubyClass rubyClass = BlockProcessorProxy.register(this.rubyRuntime, blockProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.block(rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(BlockProcessorProxy.getName(blockProcessor)));
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup block(final BlockProcessor blockProcessor) {
        final RubyClass rubyClass = BlockProcessorProxy.register(this.rubyRuntime, blockProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.block(rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(blockProcessor.getName()));
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup block(final String blockName, BlockProcessor blockProcessor) {
        final RubyClass rubyClass = BlockProcessorProxy.register(this.rubyRuntime, blockProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.block(rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(blockName));
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup blockMacro(final String blockName, Class<? extends BlockMacroProcessor> blockMacroProcessor) {
        final RubyClass rubyClass = BlockMacroProcessorProxy.register(this.rubyRuntime, blockMacroProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.block_macro(rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(blockName));
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup blockMacro(final Class<? extends BlockMacroProcessor> blockMacroProcessor) {
        final RubyClass rubyClass = BlockMacroProcessorProxy.register(this.rubyRuntime, blockMacroProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.block_macro(rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(AbstractProcessorProxy.getName(blockMacroProcessor)));
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup blockMacro(String blockName, String blockMacroProcessor) {
        try {
            Class<?> blockMacroProcessorClass = Class.forName(blockMacroProcessor);
            return this.blockMacro(blockName, blockMacroProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ExtensionGroup blockMacro(String blockMacroProcessor) {
        try {
            Class<?> blockMacroProcessorClass = Class.forName(blockMacroProcessor);
            return this.blockMacro(blockMacroProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ExtensionGroup blockMacro(final BlockMacroProcessor blockMacroProcessor) {
        final RubyClass rubyClass = BlockMacroProcessorProxy.register(this.rubyRuntime, blockMacroProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.block_macro(rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(blockMacroProcessor.getName()));
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup inlineMacro(final InlineMacroProcessor inlineMacroProcessor) {
        final RubyClass rubyClass = InlineMacroProcessorProxy.register(this.rubyRuntime, inlineMacroProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.inline_macro(rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(inlineMacroProcessor.getName()));
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup inlineMacro(final String name2, Class<? extends InlineMacroProcessor> inlineMacroProcessor) {
        final RubyClass rubyClass = InlineMacroProcessorProxy.register(this.rubyRuntime, inlineMacroProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.inline_macro(rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(name2));
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup inlineMacro(final Class<? extends InlineMacroProcessor> inlineMacroProcessor) {
        final RubyClass rubyClass = InlineMacroProcessorProxy.register(this.rubyRuntime, inlineMacroProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.inline_macro(rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(AbstractProcessorProxy.getName(inlineMacroProcessor)));
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup inlineMacro(String name2, String inlineMacroProcessor) {
        try {
            Class<?> inlineMacroProcessorClass = Class.forName(inlineMacroProcessor);
            return this.inlineMacro(name2, inlineMacroProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ExtensionGroup inlineMacro(String inlineMacroProcessor) {
        try {
            Class<?> inlineMacroProcessorClass = Class.forName(inlineMacroProcessor);
            return this.inlineMacro(inlineMacroProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ExtensionGroup requireRubyLibrary(String requiredLibrary) {
        RubyUtils.requireLibrary(this.rubyRuntime, requiredLibrary);
        return this;
    }

    @Override
    public ExtensionGroup loadRubyClass(InputStream rubyClassStream) {
        RubyUtils.loadRubyClass(this.rubyRuntime, rubyClassStream);
        return this;
    }

    @Override
    public ExtensionGroup rubyPreprocessor(final String preprocessor) {
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.preprocessor(preprocessor);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup rubyPostprocessor(final String postprocessor) {
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.postprocessor(postprocessor);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup rubyDocinfoProcessor(final String docinfoProcessor) {
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.docinfo_processor(docinfoProcessor);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup rubyIncludeProcessor(final String includeProcessor) {
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.include_processor(includeProcessor);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup rubyTreeprocessor(final String treeProcessor) {
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.tree_processor(treeProcessor);
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup rubyBlock(final String blockName, final String blockProcessor) {
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.block(blockProcessor, ExtensionGroupImpl.this.rubyRuntime.newSymbol(blockName));
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup rubyBlockMacro(final String blockName, final String blockMacroProcessor) {
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.block_macro(blockMacroProcessor, ExtensionGroupImpl.this.rubyRuntime.newSymbol(blockName));
            }
        });
        return this;
    }

    @Override
    public ExtensionGroup rubyInlineMacro(final String macroName, final String inlineMacroProcessor) {
        this.registrators.add(new Registrator(){

            @Override
            public void register(Registry registry) {
                registry.inline_macro(inlineMacroProcessor, ExtensionGroupImpl.this.rubyRuntime.newSymbol(macroName));
            }
        });
        return this;
    }

    public static interface Registrator {
        public void register(Registry var1);
    }

    public static interface Registry {
        public void docinfo_processor(RubyClass var1);

        public void docinfo_processor(String var1);

        public void preprocessor(RubyClass var1);

        public void preprocessor(String var1);

        public void postprocessor(RubyClass var1);

        public void postprocessor(String var1);

        public void include_processor(RubyClass var1);

        public void include_processor(String var1);

        public void tree_processor(RubyClass var1);

        public void tree_processor(String var1);

        public void block(RubyClass var1, RubySymbol var2);

        public void block(String var1, RubySymbol var2);

        public void block_macro(RubyClass var1, RubySymbol var2);

        public void block_macro(String var1, RubySymbol var2);

        public void inline_macro(RubyClass var1, RubySymbol var2);

        public void inline_macro(String var1, RubySymbol var2);
    }
}

