/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.DirectoryWalker;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.ast.ContentPart;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.DocumentHeader;
import org.asciidoctor.ast.NodeConverter;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.ast.StructuredDocument;
import org.asciidoctor.converter.JavaConverterRegistry;
import org.asciidoctor.converter.internal.ConverterRegistryExecutor;
import org.asciidoctor.extension.ExtensionGroup;
import org.asciidoctor.extension.JavaExtensionRegistry;
import org.asciidoctor.extension.RubyExtensionRegistry;
import org.asciidoctor.extension.internal.ExtensionRegistryExecutor;
import org.asciidoctor.internal.AsciidoctorCoreException;
import org.asciidoctor.internal.AsciidoctorModule;
import org.asciidoctor.internal.AsciidoctorUtils;
import org.asciidoctor.internal.EnvironmentInjector;
import org.asciidoctor.internal.ExtensionGroupImpl;
import org.asciidoctor.internal.IOUtils;
import org.asciidoctor.internal.JRubyAsciidoctorModuleFactory;
import org.asciidoctor.internal.RubyGemsPreloader;
import org.asciidoctor.internal.RubyHashUtil;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyAsciidoctor
implements Asciidoctor {
    private static final Logger logger = Logger.getLogger(JRubyAsciidoctor.class.getName());
    private static final String GEM_PATH = "GEM_PATH";
    private static final int DEFAULT_MAX_LEVEL = 1;
    private AsciidoctorModule asciidoctorModule;
    protected RubyGemsPreloader rubyGemsPreloader;
    protected Ruby rubyRuntime;

    private JRubyAsciidoctor(AsciidoctorModule asciidoctorModule, Ruby rubyRuntime) {
        this.asciidoctorModule = asciidoctorModule;
        this.rubyRuntime = rubyRuntime;
        this.rubyGemsPreloader = new RubyGemsPreloader(this.rubyRuntime);
    }

    public static JRubyAsciidoctor create() {
        return JRubyAsciidoctor.create((String)null);
    }

    public static JRubyAsciidoctor create(String gemPath) {
        return JRubyAsciidoctor.processRegistrations(JRubyAsciidoctor.createJRubyAsciidoctorInstance(Collections.singletonMap(GEM_PATH, gemPath), new ArrayList<String>(), null));
    }

    public static JRubyAsciidoctor create(List<String> loadPaths) {
        return JRubyAsciidoctor.processRegistrations(JRubyAsciidoctor.createJRubyAsciidoctorInstance(null, loadPaths, null));
    }

    public static JRubyAsciidoctor create(ClassLoader classloader) {
        return JRubyAsciidoctor.processRegistrations(JRubyAsciidoctor.createJRubyAsciidoctorInstance(null, new ArrayList<String>(), classloader));
    }

    public static JRubyAsciidoctor create(ClassLoader classloader, String gemPath) {
        return JRubyAsciidoctor.processRegistrations(JRubyAsciidoctor.createJRubyAsciidoctorInstance(Collections.singletonMap(GEM_PATH, gemPath), new ArrayList<String>(), classloader));
    }

    public static JRubyAsciidoctor create(List<String> loadPaths, String gemPath) {
        return JRubyAsciidoctor.processRegistrations(JRubyAsciidoctor.createJRubyAsciidoctorInstance(Collections.singletonMap(GEM_PATH, gemPath), loadPaths, null));
    }

    private static JRubyAsciidoctor processRegistrations(JRubyAsciidoctor asciidoctor) {
        JRubyAsciidoctor.registerExtensions(asciidoctor);
        JRubyAsciidoctor.registerConverters(asciidoctor);
        return asciidoctor;
    }

    private static void registerConverters(Asciidoctor asciidoctor) {
        new ConverterRegistryExecutor(asciidoctor).registerAllConverters();
    }

    private static void registerExtensions(Asciidoctor asciidoctor) {
        new ExtensionRegistryExecutor(asciidoctor).registerAllExtensions();
    }

    private static JRubyAsciidoctor createJRubyAsciidoctorInstance(Map<String, String> environmentVars, List<String> loadPaths, ClassLoader classloader) {
        HashMap<String, String> env = environmentVars != null ? new HashMap<String, String>(environmentVars) : new HashMap();
        RubyInstanceConfig config = JRubyAsciidoctor.createOptimizedConfiguration();
        if (classloader != null) {
            config.setLoader(classloader);
        }
        JRubyAsciidoctor.injectEnvironmentVariables(config, env);
        Ruby rubyRuntime = JavaEmbedUtils.initialize(loadPaths, config);
        JRubyAsciidoctorModuleFactory jRubyAsciidoctorModuleFactory = new JRubyAsciidoctorModuleFactory(rubyRuntime);
        AsciidoctorModule asciidoctorModule = jRubyAsciidoctorModuleFactory.createAsciidoctorModule();
        JRubyAsciidoctor jRubyAsciidoctor = new JRubyAsciidoctor(asciidoctorModule, rubyRuntime);
        return jRubyAsciidoctor;
    }

    private static void injectEnvironmentVariables(RubyInstanceConfig config, Map<String, String> environmentVars) {
        EnvironmentInjector environmentInjector = new EnvironmentInjector(config);
        environmentInjector.inject(environmentVars);
    }

    private static RubyInstanceConfig createOptimizedConfiguration() {
        RubyInstanceConfig config = new RubyInstanceConfig();
        return config;
    }

    public Ruby getRubyRuntime() {
        return this.rubyRuntime;
    }

    private DocumentHeader toDocumentHeader(Document document) {
        Document documentImpl = (Document)NodeConverter.createASTNode(document);
        return DocumentHeader.createDocumentHeader(documentImpl.getStructuredDoctitle(), documentImpl.getDoctitle(), documentImpl.getAttributes());
    }

    private StructuredDocument toDocument(Document document, Ruby rubyRuntime, int maxDeepLevel) {
        Document documentImpl = (Document)NodeConverter.createASTNode(document);
        List<ContentPart> contentParts = this.getContents(documentImpl.getBlocks(), 1, maxDeepLevel);
        return StructuredDocument.createStructuredDocument(this.toDocumentHeader(documentImpl), contentParts);
    }

    private List<ContentPart> getContents(List<StructuralNode> blocks2, int level2, int maxDeepLevel) {
        if (level2 > maxDeepLevel) {
            return null;
        }
        ArrayList<ContentPart> parts = new ArrayList<ContentPart>();
        for (StructuralNode block : blocks2) {
            parts.add(this.getContentPartFromBlock(block, level2, maxDeepLevel));
        }
        return parts;
    }

    private ContentPart getContentPartFromBlock(StructuralNode child, int level2, int maxDeepLevel) {
        Object content = child.content();
        String textContent = content instanceof String ? (String)content : child.convert();
        ContentPart contentPart = ContentPart.createContentPart(child.id(), level2, child.context(), child.title(), child.style(), child.role(), child.getAttributes(), textContent);
        contentPart.setParts(this.getContents(child.blocks(), level2 + 1, maxDeepLevel));
        return contentPart;
    }

    @Override
    public StructuredDocument readDocumentStructure(File filename2, Map<String, Object> options2) {
        this.rubyGemsPreloader.preloadRequiredLibraries(options2);
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options2);
        Document document = this.asciidoctorModule.load_file(filename2.getAbsolutePath(), rubyHash);
        int maxDeepLevel = options2.containsKey("STRUCTURE_MAX_LEVEL") ? (Integer)options2.get("STRUCTURE_MAX_LEVEL") : 1;
        return this.toDocument(document, this.rubyRuntime, maxDeepLevel);
    }

    @Override
    public StructuredDocument readDocumentStructure(String content, Map<String, Object> options2) {
        this.rubyGemsPreloader.preloadRequiredLibraries(options2);
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options2);
        Document document = this.asciidoctorModule.load(content, rubyHash);
        int maxDeepLevel = options2.containsKey("STRUCTURE_MAX_LEVEL") ? (Integer)options2.get("STRUCTURE_MAX_LEVEL") : 1;
        return this.toDocument(document, this.rubyRuntime, maxDeepLevel);
    }

    @Override
    public StructuredDocument readDocumentStructure(Reader contentReader, Map<String, Object> options2) {
        String content = IOUtils.readFull(contentReader);
        return this.readDocumentStructure(content, options2);
    }

    @Override
    public DocumentHeader readDocumentHeader(File filename2) {
        RubyHash rubyHash = this.getParseHeaderOnlyOption();
        Document document = this.asciidoctorModule.load_file(filename2.getAbsolutePath(), rubyHash);
        return this.toDocumentHeader(document);
    }

    @Override
    public DocumentHeader readDocumentHeader(String content) {
        RubyHash rubyHash = this.getParseHeaderOnlyOption();
        Document document = this.asciidoctorModule.load(content, rubyHash);
        return this.toDocumentHeader(document);
    }

    @Override
    public DocumentHeader readDocumentHeader(Reader contentReader) {
        String content = IOUtils.readFull(contentReader);
        return this.readDocumentHeader(content);
    }

    private RubyHash getParseHeaderOnlyOption() {
        HashMap<String, Object> options2 = new HashMap<String, Object>();
        options2.put("parse_header_only", true);
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options2);
        return rubyHash;
    }

    @Override
    @Deprecated
    public String render(String content, Map<String, Object> options2) {
        return this.convert(content, options2);
    }

    @Override
    @Deprecated
    public String renderFile(File filename2, Map<String, Object> options2) {
        return this.convertFile(filename2, options2);
    }

    private String returnExpectedValue(Object object) {
        if (object instanceof String) {
            return object.toString();
        }
        return null;
    }

    @Override
    @Deprecated
    public void render(Reader contentReader, Writer rendererWriter, Map<String, Object> options2) throws IOException {
        String content = IOUtils.readFull(contentReader);
        String renderedContent = this.render(content, options2);
        IOUtils.writeFull(rendererWriter, renderedContent);
    }

    @Override
    @Deprecated
    public String[] renderFiles(Collection<File> asciidoctorFiles, Map<String, Object> options2) {
        List<String> asciidoctorContent = this.renderAllFiles(options2, asciidoctorFiles);
        return asciidoctorContent.toArray(new String[asciidoctorContent.size()]);
    }

    @Override
    @Deprecated
    public String[] renderFiles(Collection<File> asciidoctorFiles, Options options2) {
        return this.renderFiles(asciidoctorFiles, options2.map());
    }

    @Override
    @Deprecated
    public String[] renderDirectory(DirectoryWalker directoryWalker, Map<String, Object> options2) {
        List<File> asciidoctorFiles = this.scanForAsciiDocFiles(directoryWalker);
        List<String> asciidoctorContent = this.renderAllFiles(options2, asciidoctorFiles);
        return asciidoctorContent.toArray(new String[asciidoctorContent.size()]);
    }

    private List<String> renderAllFiles(Map<String, Object> options2, Collection<File> asciidoctorFiles) {
        ArrayList<String> asciidoctorContent = new ArrayList<String>();
        for (File asciidoctorFile : asciidoctorFiles) {
            String renderedFile = this.renderFile(asciidoctorFile, options2);
            if (renderedFile == null) continue;
            asciidoctorContent.add(renderedFile);
        }
        return asciidoctorContent;
    }

    private List<File> scanForAsciiDocFiles(DirectoryWalker directoryWalker) {
        List<File> asciidoctorFiles = directoryWalker.scan();
        return asciidoctorFiles;
    }

    @Override
    @Deprecated
    public String render(String content, Options options2) {
        return this.render(content, options2.map());
    }

    @Override
    @Deprecated
    public void render(Reader contentReader, Writer rendererWriter, Options options2) throws IOException {
        this.render(contentReader, rendererWriter, options2.map());
    }

    @Override
    @Deprecated
    public String renderFile(File filename2, Options options2) {
        return this.renderFile(filename2, options2.map());
    }

    @Override
    @Deprecated
    public String[] renderDirectory(DirectoryWalker directoryWalker, Options options2) {
        return this.renderDirectory(directoryWalker, options2.map());
    }

    @Override
    @Deprecated
    public String render(String content, OptionsBuilder options2) {
        return this.render(content, options2.asMap());
    }

    @Override
    @Deprecated
    public void render(Reader contentReader, Writer rendererWriter, OptionsBuilder options2) throws IOException {
        this.render(contentReader, rendererWriter, options2.asMap());
    }

    @Override
    @Deprecated
    public String renderFile(File filename2, OptionsBuilder options2) {
        return this.renderFile(filename2, options2.asMap());
    }

    @Override
    @Deprecated
    public String[] renderDirectory(DirectoryWalker directoryWalker, OptionsBuilder options2) {
        return this.renderDirectory(directoryWalker, options2.asMap());
    }

    @Override
    @Deprecated
    public String[] renderFiles(Collection<File> asciidoctorFiles, OptionsBuilder options2) {
        return this.renderFiles(asciidoctorFiles, options2.asMap());
    }

    @Override
    public void requireLibrary(String ... library2) {
        this.requireLibraries(Arrays.asList(library2));
    }

    @Override
    public void requireLibraries(Collection<String> libraries) {
        if (libraries != null) {
            for (String library2 : libraries) {
                RubyUtils.requireLibrary(this.rubyRuntime, library2);
            }
        }
    }

    @Override
    public JavaExtensionRegistry javaExtensionRegistry() {
        return new JavaExtensionRegistry(this.asciidoctorModule, this.rubyRuntime);
    }

    @Override
    public RubyExtensionRegistry rubyExtensionRegistry() {
        return new RubyExtensionRegistry(this.asciidoctorModule, this.rubyRuntime);
    }

    @Override
    public JavaConverterRegistry javaConverterRegistry() {
        return new JavaConverterRegistry(this.asciidoctorModule, this.rubyRuntime);
    }

    @Override
    public void unregisterAllExtensions() {
        this.asciidoctorModule.unregister_all_extensions();
    }

    @Override
    public void shutdown() {
        this.rubyRuntime.tearDown();
    }

    @Override
    public String asciidoctorVersion() {
        return this.asciidoctorModule.asciidoctorRuntimeEnvironmentVersion();
    }

    @Override
    public String convert(String content, Map<String, Object> options2) {
        return this.convert(content, options2, String.class);
    }

    @Override
    public <T> T convert(String content, Map<String, Object> options2, Class<T> expectedResult) {
        this.rubyGemsPreloader.preloadRequiredLibraries(options2);
        logger.fine(AsciidoctorUtils.toAsciidoctorCommand(options2, "-"));
        if (AsciidoctorUtils.isOptionWithAttribute(options2, "source-highlighter", "pygments")) {
            logger.fine("In order to use Pygments with Asciidoctor, you need to install Pygments (and Python, if you don't have it yet). Read http://asciidoctor.org/news/#syntax-highlighting-with-pygments.");
        }
        String currentDirectory = this.rubyRuntime.getCurrentDirectory();
        if (options2.containsKey("base_dir")) {
            this.rubyRuntime.setCurrentDirectory((String)options2.get("base_dir"));
        }
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options2);
        try {
            Object object = this.asciidoctorModule.convert(content, rubyHash);
            if (object instanceof IRubyObject && NodeConverter.NodeType.DOCUMENT_CLASS.isInstance((IRubyObject)object)) {
                T t = null;
                return t;
            }
            Object object2 = object;
            return (T)object2;
        }
        catch (RaiseException e) {
            logger.severe(e.getException().getClass().getCanonicalName());
            throw new AsciidoctorCoreException(e);
        }
        finally {
            this.rubyRuntime.setCurrentDirectory(currentDirectory);
        }
    }

    @Override
    public String convert(String content, Options options2) {
        return this.convert(content, options2, String.class);
    }

    @Override
    public <T> T convert(String content, Options options2, Class<T> expectedResult) {
        return this.convert(content, options2.map(), expectedResult);
    }

    @Override
    public String convert(String content, OptionsBuilder options2) {
        return this.convert(content, options2, String.class);
    }

    @Override
    public <T> T convert(String content, OptionsBuilder options2, Class<T> expectedResult) {
        return this.convert(content, options2.asMap(), expectedResult);
    }

    @Override
    public void convert(Reader contentReader, Writer rendererWriter, Map<String, Object> options2) throws IOException {
        this.render(contentReader, rendererWriter, options2);
    }

    @Override
    public void convert(Reader contentReader, Writer rendererWriter, Options options2) throws IOException {
        this.render(contentReader, rendererWriter, options2);
    }

    @Override
    public void convert(Reader contentReader, Writer rendererWriter, OptionsBuilder options2) throws IOException {
        this.render(contentReader, rendererWriter, options2);
    }

    @Override
    public String convertFile(File filename2, Map<String, Object> options2) {
        return this.convertFile(filename2, options2, String.class);
    }

    @Override
    public <T> T convertFile(File filename2, Map<String, Object> options2, Class<T> expectedResult) {
        this.rubyGemsPreloader.preloadRequiredLibraries(options2);
        logger.fine(AsciidoctorUtils.toAsciidoctorCommand(options2, filename2.getAbsolutePath()));
        String currentDirectory = this.rubyRuntime.getCurrentDirectory();
        if (options2.containsKey("base_dir")) {
            this.rubyRuntime.setCurrentDirectory((String)options2.get("base_dir"));
        }
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options2);
        try {
            Object object = this.asciidoctorModule.convertFile(filename2.getAbsolutePath(), rubyHash);
            if (object instanceof IRubyObject && NodeConverter.NodeType.DOCUMENT_CLASS.isInstance((IRubyObject)object)) {
                T t = null;
                return t;
            }
            Object object2 = object;
            return (T)object2;
        }
        catch (RaiseException e) {
            logger.severe(e.getMessage());
            throw new AsciidoctorCoreException(e);
        }
        finally {
            this.rubyRuntime.setCurrentDirectory(currentDirectory);
        }
    }

    @Override
    public String convertFile(File filename2, Options options2) {
        return this.convertFile(filename2, options2, String.class);
    }

    @Override
    public <T> T convertFile(File filename2, Options options2, Class<T> expectedResult) {
        return this.convertFile(filename2, options2.map(), expectedResult);
    }

    @Override
    public String convertFile(File filename2, OptionsBuilder options2) {
        return this.convertFile(filename2, options2.asMap(), String.class);
    }

    @Override
    public <T> T convertFile(File filename2, OptionsBuilder options2, Class<T> expectedResult) {
        return this.convertFile(filename2, options2.asMap(), expectedResult);
    }

    @Override
    public String[] convertDirectory(DirectoryWalker directoryWalker, Map<String, Object> options2) {
        return this.renderDirectory(directoryWalker, options2);
    }

    @Override
    public String[] convertDirectory(DirectoryWalker directoryWalker, Options options2) {
        return this.renderDirectory(directoryWalker, options2);
    }

    @Override
    public String[] convertDirectory(DirectoryWalker directoryWalker, OptionsBuilder options2) {
        return this.renderDirectory(directoryWalker, options2);
    }

    @Override
    public String[] convertFiles(Collection<File> asciidoctorFiles, Map<String, Object> options2) {
        return this.renderFiles(asciidoctorFiles, options2);
    }

    @Override
    public String[] convertFiles(Collection<File> asciidoctorFiles, Options options2) {
        return this.renderFiles(asciidoctorFiles, options2);
    }

    @Override
    public String[] convertFiles(Collection<File> asciidoctorFiles, OptionsBuilder options2) {
        return this.renderFiles(asciidoctorFiles, options2);
    }

    @Override
    public Document load(String content, Map<String, Object> options2) {
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options2);
        return (Document)NodeConverter.createASTNode(this.asciidoctorModule.load(content, rubyHash));
    }

    @Override
    public Document loadFile(File file2, Map<String, Object> options2) {
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options2);
        return (Document)NodeConverter.createASTNode(this.asciidoctorModule.load_file(file2.getAbsolutePath(), rubyHash));
    }

    AsciidoctorModule getAsciidoctorModule() {
        return this.asciidoctorModule;
    }

    @Override
    public ExtensionGroup createGroup() {
        return new ExtensionGroupImpl(UUID.randomUUID().toString(), this);
    }

    @Override
    public ExtensionGroup createGroup(String groupName) {
        return new ExtensionGroupImpl(groupName, this);
    }
}

