/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyHashMapDecorator
implements Map<String, Object> {
    private final RubyHash rubyHash;
    private final Ruby rubyRuntime;

    public RubyHashMapDecorator(RubyHash rubyHash) {
        this.rubyRuntime = rubyHash.getRuntime();
        this.rubyHash = rubyHash;
    }

    @Override
    public int size() {
        return this.createJavaMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key2) {
        if (!(key2 instanceof String)) {
            return false;
        }
        RubySymbol symbol = this.rubyHash.getRuntime().getSymbolTable().getSymbol((String)key2);
        return this.rubyHash.containsKey(symbol);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.rubyHash.containsValue(value2);
    }

    @Override
    public Object get(Object key2) {
        if (!(key2 instanceof String)) {
            return false;
        }
        RubySymbol symbol = this.rubyHash.getRuntime().getSymbolTable().getSymbol((String)key2);
        Object value2 = this.rubyHash.get(symbol);
        return this.convertRubyValue(value2);
    }

    @Override
    public Object put(String key2, Object value2) {
        Object oldValue = this.get(key2);
        RubySymbol symbol = this.rubyHash.getRuntime().getSymbolTable().getSymbol(key2);
        this.rubyHash.put(symbol, this.convertJavaValue(value2));
        return oldValue;
    }

    @Override
    public Object remove(Object key2) {
        if (!(key2 instanceof String)) {
            return null;
        }
        Object oldValue = this.get(key2);
        RubySymbol symbol = this.rubyHash.getRuntime().getSymbolTable().getSymbol((String)key2);
        this.rubyHash.remove(symbol);
        return this.convertRubyValue(oldValue);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.rubyHash.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.createJavaMap().keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.createJavaMap().values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.createJavaMap().entrySet();
    }

    private Map<String, Object> createJavaMap() {
        HashMap<String, Object> copy = new HashMap<String, Object>();
        Set rubyEntrySet = this.rubyHash.entrySet();
        for (Map.Entry o : rubyEntrySet) {
            String key2 = null;
            Object rubyKey = o.getKey();
            Object rubyValue = o.getValue();
            if (rubyKey instanceof RubySymbol) {
                key2 = ((RubySymbol)rubyKey).asJavaString();
            } else if (rubyKey instanceof RubyString) {
                key2 = ((RubyString)rubyKey).asJavaString();
            } else if (rubyKey instanceof String) {
                key2 = (String)rubyKey;
            } else if (!(rubyKey instanceof Long)) {
                throw new IllegalStateException("Did not expect key " + rubyKey + " of type " + rubyKey.getClass());
            }
            if (key2 == null) continue;
            Object value2 = this.convertRubyValue(rubyValue);
            copy.put(key2, value2);
        }
        return copy;
    }

    private Object convertRubyValue(Object rubyValue) {
        if (rubyValue == null) {
            return null;
        }
        if (rubyValue instanceof IRubyObject) {
            return JavaEmbedUtils.rubyToJava((IRubyObject)rubyValue);
        }
        return rubyValue;
    }

    private IRubyObject convertJavaValue(Object value2) {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof String && ((String)value2).startsWith(":")) {
            return this.rubyHash.getRuntime().getSymbolTable().getSymbol(((String)value2).substring(1));
        }
        return JavaEmbedUtils.javaToRuby(this.rubyHash.getRuntime(), value2);
    }

    RubyHash getRubyHash() {
        return this.rubyHash;
    }
}

