/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import java.util.Iterator;
import org.jruby.IncludedModuleWrapper;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyGC;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.WeakValuedIdentityMap;
import org.jruby.util.func.Function1;

@JRubyModule(name={"ObjectSpace"})
public class RubyObjectSpace {
    public static RubyModule createObjectSpaceModule(Ruby runtime) {
        RubyModule objectSpaceModule = runtime.defineModule("ObjectSpace");
        runtime.setObjectSpaceModule(objectSpaceModule);
        objectSpaceModule.defineAnnotatedMethods(RubyObjectSpace.class);
        if (runtime.is2_0()) {
            WeakMap.createWeakMap(runtime);
        }
        return objectSpaceModule;
    }

    @JRubyMethod(required=1, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject define_finalizer(IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = recv2.getRuntime();
        IRubyObject finalizer = null;
        if (args2.length == 2) {
            finalizer = args2[1];
            if (!finalizer.respondsTo("call")) {
                throw runtime.newArgumentError("wrong type argument " + finalizer.getType() + " (should be callable)");
            }
        } else {
            finalizer = runtime.newProc(Block.Type.PROC, block);
        }
        IRubyObject obj = args2[0];
        runtime.getObjectSpace().addFinalizer(obj, finalizer);
        return runtime.newArray((IRubyObject)RubyFixnum.zero(runtime), finalizer);
    }

    @JRubyMethod(required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject undefine_finalizer(IRubyObject recv2, IRubyObject arg1, Block block) {
        recv2.getRuntime().getObjectSpace().removeFinalizers(RubyNumeric.fix2long(arg1.id()));
        return recv2;
    }

    @JRubyMethod(name={"_id2ref"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject id2ref(IRubyObject recv2, IRubyObject id2) {
        Ruby runtime = id2.getRuntime();
        if (!(id2 instanceof RubyFixnum)) {
            throw recv2.getRuntime().newTypeError(id2, recv2.getRuntime().getFixnum());
        }
        RubyFixnum idFixnum = (RubyFixnum)id2;
        long longId = idFixnum.getLongValue();
        if (longId == 0L) {
            return runtime.getFalse();
        }
        if (longId == 2L) {
            return runtime.getTrue();
        }
        if (longId == 4L) {
            return runtime.getNil();
        }
        if (longId % 2L != 0L) {
            return runtime.newFixnum((longId - 1L) / 2L);
        }
        if (runtime.isObjectSpaceEnabled()) {
            IRubyObject object = runtime.getObjectSpace().id2ref(longId);
            if (object == null) {
                return runtime.getNil();
            }
            return object;
        }
        runtime.getWarnings().warn("ObjectSpace is disabled; _id2ref only supports immediates, pass -X+O to enable");
        return runtime.getNil();
    }

    public static IRubyObject each_objectInternal(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyModule tmpClass;
        if (args2.length == 0) {
            tmpClass = recv2.getRuntime().getObject();
        } else {
            if (!(args2[0] instanceof RubyModule)) {
                throw recv2.getRuntime().newTypeError("class or module required");
            }
            tmpClass = (RubyModule)args2[0];
        }
        final RubyClass rubyClass = tmpClass;
        Ruby runtime = recv2.getRuntime();
        final int[] count2 = new int[]{0};
        if (rubyClass == runtime.getClassClass() || rubyClass == runtime.getModule()) {
            final ArrayList modules = new ArrayList();
            runtime.eachModule(new Function1<Object, IRubyObject>(){

                @Override
                public Object apply(IRubyObject arg1) {
                    if (!(!rubyClass.isInstance(arg1) || arg1 instanceof IncludedModuleWrapper || arg1 instanceof RubyClass && ((RubyClass)arg1).isSingleton())) {
                        count2[0] = count2[0] + 1;
                        modules.add(arg1);
                    }
                    return null;
                }
            });
            for (IRubyObject arg2 : modules) {
                block.yield(context, arg2);
            }
        } else {
            if (!runtime.isObjectSpaceEnabled()) {
                throw runtime.newRuntimeError("ObjectSpace is disabled; each_object will only work with Class, pass -X+O to enable");
            }
            Iterator iter = recv2.getRuntime().getObjectSpace().iterator(rubyClass);
            IRubyObject obj = null;
            while ((obj = (IRubyObject)iter.next()) != null) {
                count2[0] = count2[0] + 1;
                block.yield(context, obj);
            }
        }
        return recv2.getRuntime().newFixnum(count2[0]);
    }

    @JRubyMethod(name={"each_object"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject each_object(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyObjectSpace.each_objectInternal(context, recv2, args2, block) : RubyEnumerator.enumeratorize(context.runtime, recv2, "each_object", args2);
    }

    @JRubyMethod(name={"garbage_collect"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject garbage_collect(ThreadContext context, IRubyObject recv2) {
        return RubyGC.start(context, recv2);
    }

    public static class WeakMap
    extends RubyObject {
        private final WeakValuedIdentityMap<IRubyObject, IRubyObject> map = new WeakValuedIdentityMap();

        static void createWeakMap(Ruby runtime) {
            RubyClass weakMap = runtime.getObjectSpaceModule().defineClassUnder("WeakMap", runtime.getObject(), new ObjectAllocator(){

                @Override
                public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                    return new WeakMap(runtime, klazz);
                }
            });
            weakMap.defineAnnotatedMethods(WeakMap.class);
        }

        public WeakMap(Ruby runtime, RubyClass cls) {
            super(runtime, cls);
        }

        @JRubyMethod(name={"[]"})
        public IRubyObject op_aref(ThreadContext context, IRubyObject key2) {
            IRubyObject value2 = this.map.get(key2);
            if (value2 != null) {
                return value2;
            }
            return context.nil;
        }

        @JRubyMethod(name={"[]="})
        public IRubyObject op_aref(ThreadContext context, IRubyObject key2, IRubyObject value2) {
            this.map.put(key2, value2);
            return context.runtime.newFixnum(System.identityHashCode(value2));
        }
    }
}

