/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;

public class StrNode
extends Node
implements ILiteralNode {
    private final ByteList value;
    private final int codeRange;

    public StrNode(ISourcePosition position, ByteList value2) {
        this(position, value2, StringSupport.codeRangeScan(value2.getEncoding(), value2));
    }

    public StrNode(ISourcePosition position, ByteList value2, int codeRange) {
        super(position);
        this.value = value2;
        this.codeRange = codeRange;
    }

    public StrNode(ISourcePosition position, StrNode head, StrNode tail) {
        super(position);
        ByteList headBL = head.getValue();
        ByteList tailBL = tail.getValue();
        ByteList myValue = new ByteList(headBL.getRealSize() + tailBL.getRealSize());
        myValue.setEncoding(headBL.getEncoding());
        myValue.append(headBL);
        myValue.append(tailBL);
        this.value = myValue;
        this.codeRange = StringSupport.codeRangeScan(this.value.getEncoding(), this.value);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.STRNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitStrNode(this);
    }

    public ByteList getValue() {
        return this.value;
    }

    public int getCodeRange() {
        return this.codeRange;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        return RubyString.newStringShared(runtime, this.value, this.codeRange);
    }
}

