/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.management;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jruby.Ruby;
import org.jruby.compiler.JITCompilerMBean;
import org.jruby.management.BeanManager;
import org.jruby.management.ClassCacheMBean;
import org.jruby.management.ConfigMBean;
import org.jruby.management.MethodCacheMBean;
import org.jruby.management.ParserStatsMBean;
import org.jruby.management.Runtime;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;
import sun.management.Agent;

public class BeanManagerImpl
implements BeanManager {
    private static final Logger LOG = LoggerFactory.getLogger("BeanManagerImpl");
    public final String base;
    private final boolean managementEnabled;

    public BeanManagerImpl(Ruby ruby2, boolean managementEnabled) {
        this.managementEnabled = managementEnabled;
        this.base = "org.jruby:type=Runtime,name=" + ruby2.getRuntimeNumber() + ",";
    }

    @Override
    public void register(JITCompilerMBean jitCompiler) {
        if (this.managementEnabled) {
            this.register(this.base + "service=JITCompiler", jitCompiler);
        }
    }

    @Override
    public void register(ConfigMBean config) {
        if (this.managementEnabled) {
            this.register(this.base + "service=Config", config);
        }
    }

    @Override
    public void register(ParserStatsMBean parserStats) {
        if (this.managementEnabled) {
            this.register(this.base + "service=ParserStats", parserStats);
        }
    }

    @Override
    public void register(MethodCacheMBean methodCache) {
        if (this.managementEnabled) {
            this.register(this.base + "service=MethodCache", methodCache);
        }
    }

    @Override
    public void register(ClassCacheMBean classCache) {
        if (this.managementEnabled) {
            this.register(this.base + "service=ClassCache", classCache);
        }
    }

    @Override
    public void register(Runtime runtime) {
        if (this.managementEnabled) {
            this.register(this.base + "service=Runtime", runtime);
        }
    }

    @Override
    public void unregisterCompiler() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=JITCompiler");
        }
    }

    @Override
    public void unregisterConfig() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=Config");
        }
    }

    @Override
    public void unregisterParserStats() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=ParserStats");
        }
    }

    @Override
    public void unregisterClassCache() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=ClassCache");
        }
    }

    @Override
    public void unregisterMethodCache() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=MethodCache");
        }
    }

    @Override
    public void unregisterRuntime() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=Runtime");
        }
    }

    @Override
    public boolean tryShutdownAgent() {
        try {
            Class<?> agent = Class.forName("sun.management.Agent");
            Method shutdown2 = agent.getDeclaredMethod("stopRemoteManagementAgent", new Class[0]);
            shutdown2.setAccessible(true);
            shutdown2.invoke(null, new Object[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean tryRestartAgent() {
        try {
            Agent.startAgent();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void register(String name2, Object bean) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName beanName = new ObjectName(name2);
            mbs.registerMBean(bean, beanName);
        }
        catch (InstanceAlreadyExistsException ex) {
            LOG.warn("mbean already registered: {}", name2);
        }
        catch (MBeanRegistrationException ex) {
            LOG.error(ex);
        }
        catch (NotCompliantMBeanException ex) {
            LOG.error(ex);
        }
        catch (MalformedObjectNameException ex) {
            LOG.error(ex);
        }
        catch (NullPointerException ex) {
            LOG.error(ex);
        }
        catch (AccessControlException ex) {
        }
        catch (SecurityException ex) {
        }
        catch (Error e) {
            LOG.debug(e);
        }
    }

    private void unregister(String name2) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName beanName = new ObjectName(name2);
            mbs.unregisterMBean(beanName);
        }
        catch (InstanceNotFoundException ex) {
        }
        catch (MBeanRegistrationException ex) {
            LOG.error(ex);
        }
        catch (MalformedObjectNameException ex) {
            LOG.error(ex);
        }
        catch (NullPointerException ex) {
            LOG.error(ex);
        }
        catch (AccessControlException ex) {
        }
        catch (SecurityException ex) {
        }
        catch (Error e) {
            LOG.debug(e);
        }
    }
}

