/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jcodings.Encoding;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.specific.ASCIIEncoding;

public final class ByteList
implements Comparable,
CharSequence,
Serializable {
    private static final long serialVersionUID = -1286166947275543731L;
    public static final byte[] NULL_ARRAY = new byte[0];
    public static final ByteList EMPTY_BYTELIST = new ByteList(0);
    @Deprecated
    public byte[] bytes;
    @Deprecated
    public int begin;
    @Deprecated
    public int realSize;
    @Deprecated
    public Encoding encoding = ASCIIEncoding.INSTANCE;
    int hash;
    String stringValue;
    private static final int DEFAULT_SIZE = 4;
    private static final ConcurrentMap<String, Charset> charsetsByAlias = new ConcurrentHashMap<String, Charset>();

    public ByteList() {
        this(4);
    }

    public ByteList(int size2) {
        this.bytes = new byte[size2];
        this.realSize = 0;
    }

    public ByteList(byte[] bytes2, Encoding encoding2) {
        this.bytes = bytes2;
        this.realSize = bytes2.length;
        this.encoding = ByteList.safeEncoding(encoding2);
    }

    public ByteList(byte[] wrap2) {
        this(wrap2, true);
    }

    public ByteList(byte[] wrap2, boolean copy) {
        this(wrap2, ASCIIEncoding.INSTANCE, copy);
    }

    public ByteList(byte[] wrap2, Encoding encoding2, boolean copy) {
        assert (wrap2 != null);
        this.bytes = copy ? (byte[])wrap2.clone() : wrap2;
        this.realSize = wrap2.length;
        this.encoding = ByteList.safeEncoding(encoding2);
    }

    public ByteList(ByteList wrap2) {
        this(wrap2.bytes, wrap2.begin, wrap2.realSize, wrap2.encoding, true);
    }

    @Deprecated
    public ByteList(ByteList wrap2, boolean copy) {
        this(wrap2.bytes, wrap2.begin, wrap2.realSize, wrap2.encoding, false);
    }

    public ByteList(byte[] wrap2, int index2, int len) {
        this(wrap2, index2, len, true);
    }

    public ByteList(byte[] wrap2, int index2, int len, boolean copy) {
        this(wrap2, index2, len, ASCIIEncoding.INSTANCE, copy);
    }

    public ByteList(byte[] wrap2, int index2, int len, Encoding encoding2, boolean copy) {
        assert (wrap2 != null) : "'wrap' must not be null";
        assert (index2 >= 0 && index2 <= wrap2.length) : "'index' is not without bounds of 'wrap' array";
        assert (wrap2.length >= index2 + len) : "'index' + 'len' is longer than the 'wrap' array";
        if (copy) {
            this.bytes = new byte[len];
            System.arraycopy(wrap2, index2, this.bytes, 0, len);
        } else {
            this.begin = index2;
            this.bytes = wrap2;
        }
        this.realSize = len;
        this.encoding = ByteList.safeEncoding(encoding2);
    }

    public ByteList(ByteList wrap2, int index2, int len) {
        this(wrap2.bytes, wrap2.begin + index2, len);
    }

    public void delete(int start2, int len) {
        assert (start2 >= this.begin && start2 < this.realSize) : "'start' is at invalid index";
        assert (len >= 0) : "'len' must be positive";
        assert (start2 + len <= this.begin + this.realSize) : "too many bytes requested";
        this.realSize -= len;
        System.arraycopy(this.bytes, start2 + len, this.bytes, start2, this.realSize);
        this.invalidate();
    }

    public void fill(int b, int len) {
        while (--len >= 0) {
            this.append(b);
        }
        this.invalidate();
    }

    public Object clone() {
        return this.dup();
    }

    public ByteList dup() {
        ByteList dup2 = this.dup(this.realSize);
        dup2.hash = this.hash;
        dup2.stringValue = this.stringValue;
        return dup2;
    }

    public ByteList shallowDup() {
        ByteList dup2 = new ByteList(this.bytes, false);
        dup2.realSize = this.realSize;
        dup2.begin = this.begin;
        dup2.encoding = ByteList.safeEncoding(this.encoding);
        dup2.hash = this.hash;
        dup2.stringValue = this.stringValue;
        return dup2;
    }

    public ByteList dup(int length2) {
        ByteList dup2 = new ByteList(length2);
        dup2.append(this.bytes, this.begin, this.realSize);
        dup2.encoding = ByteList.safeEncoding(this.encoding);
        return dup2;
    }

    public void ensure(int length2) {
        if (this.begin + length2 > this.bytes.length) {
            byte[] tmp = new byte[length2 + (length2 >>> 1)];
            System.arraycopy(this.bytes, this.begin, tmp, 0, this.realSize);
            this.bytes = tmp;
            this.begin = 0;
            this.invalidate();
        }
    }

    public ByteList makeShared(int index2, int len) {
        ByteList shared = new ByteList(this.bytes, this.encoding);
        shared.realSize = len;
        shared.begin = this.begin + index2;
        return shared;
    }

    public void view(int index2, int len) {
        this.realSize = len;
        this.begin += index2;
        this.invalidate();
    }

    public void unshare() {
        this.unshare(this.realSize);
    }

    public void unshare(int length2) {
        byte[] tmp = new byte[length2];
        System.arraycopy(this.bytes, this.begin, tmp, 0, Math.min(this.realSize, length2));
        this.bytes = tmp;
        this.begin = 0;
    }

    public void invalidate() {
        this.hash = 0;
        this.stringValue = null;
    }

    public void prepend(byte b) {
        this.grow(1);
        System.arraycopy(this.bytes, this.begin + 0, this.bytes, this.begin + 1, this.realSize);
        this.bytes[this.begin + 0] = b;
        ++this.realSize;
        this.invalidate();
    }

    public ByteList append(byte b) {
        this.grow(1);
        this.bytes[this.begin + this.realSize] = b;
        ++this.realSize;
        this.invalidate();
        return this;
    }

    public ByteList append(int b) {
        this.append((byte)b);
        return this;
    }

    public ByteList append(InputStream input, int length2) throws IOException {
        int read2;
        int n;
        this.grow(length2);
        int start2 = this.begin + this.realSize;
        for (read2 = 0; read2 < length2; read2 += n) {
            n = input.read(this.bytes, start2 + read2, length2 - read2);
            if (n != -1) continue;
            if (read2 != 0) break;
            throw new EOFException();
        }
        this.realSize += read2;
        this.invalidate();
        return this;
    }

    public void append(ByteBuffer buffer, int len) {
        this.grow(len);
        buffer.get(this.bytes, this.begin + this.realSize, len);
        this.realSize += len;
        this.invalidate();
    }

    public void append(byte[] moreBytes) {
        assert (moreBytes != null) : "moreBytes is null";
        this.grow(moreBytes.length);
        System.arraycopy(moreBytes, 0, this.bytes, this.begin + this.realSize, moreBytes.length);
        this.realSize += moreBytes.length;
        this.invalidate();
    }

    public void append(ByteList moreBytes) {
        this.append(moreBytes.bytes, moreBytes.begin, moreBytes.realSize);
    }

    public void append(ByteList moreBytes, int index2, int len) {
        this.append(moreBytes.bytes, moreBytes.begin + index2, len);
    }

    public void append(byte[] moreBytes, int start2, int len) {
        assert (moreBytes != null) : "moreBytes is null";
        assert (len >= 0 && moreBytes.length - start2 >= len) : "Bad length";
        this.grow(len);
        System.arraycopy(moreBytes, start2, this.bytes, this.begin + this.realSize, len);
        this.realSize += len;
        this.invalidate();
    }

    public void realloc(int length2) {
        assert (length2 >= 0) : "Invalid length";
        assert (length2 >= this.realSize) : "length is too small";
        byte[] tmp = new byte[length2];
        System.arraycopy(this.bytes, 0, tmp, 0, this.realSize);
        this.bytes = tmp;
        this.invalidate();
    }

    public int length() {
        return this.realSize;
    }

    public void length(int newLength) {
        this.grow(newLength - this.realSize);
        this.realSize = newLength;
    }

    public int lengthEnc() {
        return this.encoding.strLength(this.bytes, this.begin, this.begin + this.realSize);
    }

    public int get(int index2) {
        assert (index2 >= 0) : "index must be positive";
        return this.bytes[this.begin + index2];
    }

    public int getEnc(int index2) {
        return this.encoding.strCodeAt(this.bytes, this.begin, this.begin + this.realSize, index2);
    }

    public void set(int index2, int b) {
        assert (index2 >= 0) : "index must be positive";
        assert (this.begin + index2 < this.begin + this.realSize) : "index is too large";
        this.bytes[this.begin + index2] = (byte)b;
        this.invalidate();
    }

    @Deprecated
    public void replace(byte[] newBytes) {
        assert (newBytes != null);
        this.bytes = newBytes;
        this.realSize = newBytes.length;
        this.invalidate();
    }

    public void unsafeReplace(int beg, int len, ByteList nbytes) {
        this.unsafeReplace(beg, len, nbytes.bytes, nbytes.begin, nbytes.realSize);
    }

    public void unsafeReplace(int beg, int len, byte[] buf) {
        this.unsafeReplace(beg, len, buf, 0, buf.length);
    }

    public void unsafeReplace(int beg, int len, byte[] nbytes, int index2, int count2) {
        this.grow(count2 - len);
        int newSize = this.realSize + count2 - len;
        System.arraycopy(this.bytes, beg + len, this.bytes, beg + count2, this.realSize - (len + beg));
        System.arraycopy(nbytes, index2, this.bytes, beg, count2);
        this.realSize = newSize;
        this.invalidate();
    }

    public void replace(int beg, int len, ByteList nbytes) {
        this.replace(beg, len, nbytes.bytes, nbytes.begin, nbytes.realSize);
    }

    public void replace(int beg, int len, byte[] buf) {
        this.replace(beg, len, buf, 0, buf.length);
    }

    public void replace(int beg, int len, byte[] nbytes, int index2, int count2) {
        this.unsafeReplace(beg, len, nbytes, index2, count2);
    }

    public void insert(int index2, int b) {
        this.grow(1);
        System.arraycopy(this.bytes, index2, this.bytes, index2 + 1, this.realSize - index2);
        this.bytes[index2] = (byte)b;
        ++this.realSize;
        this.invalidate();
    }

    public int indexOf(int c) {
        return this.indexOf(c, 0);
    }

    public int indexOf(int c, int pos2) {
        if (c > 255) {
            return -1;
        }
        byte b = (byte)(c & 0xFF);
        int size2 = this.begin + this.realSize;
        byte[] buf = this.bytes;
        pos2 += this.begin;
        while (pos2 < size2 && buf[pos2] != b) {
            ++pos2;
        }
        return pos2 < size2 ? pos2 - this.begin : -1;
    }

    public int indexOf(ByteList find2) {
        return this.indexOf(find2, 0);
    }

    public int indexOf(ByteList find2, int i2) {
        return ByteList.indexOf(this.bytes, this.begin, this.realSize, find2.bytes, find2.begin, find2.realSize, i2);
    }

    static int indexOf(byte[] source2, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first2 = target[targetOffset];
        int max2 = sourceOffset + (sourceCount - targetCount);
        for (int i2 = sourceOffset + fromIndex; i2 <= max2; ++i2) {
            if (source2[i2] != first2) {
                while (++i2 <= max2 && source2[i2] != first2) {
                }
            }
            if (i2 > max2) continue;
            int j = i2 + 1;
            int end2 = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end2 && source2[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end2) continue;
            return i2 - sourceOffset;
        }
        return -1;
    }

    public int lastIndexOf(int c) {
        return this.lastIndexOf(c, this.realSize - 1);
    }

    public int lastIndexOf(int c, int pos2) {
        if (c > 255) {
            return -1;
        }
        byte b = (byte)(c & 0xFF);
        int size2 = this.begin + this.realSize;
        byte[] buf = this.bytes;
        pos2 = (pos2 += this.begin) >= size2 ? size2 : ++pos2;
        while (--pos2 >= this.begin && buf[pos2] != b) {
        }
        return pos2 - this.begin;
    }

    public int lastIndexOf(ByteList find2) {
        return this.lastIndexOf(find2, this.realSize);
    }

    public int lastIndexOf(ByteList find2, int pos2) {
        return ByteList.lastIndexOf(this.bytes, this.begin, this.realSize, find2.bytes, find2.begin, find2.realSize, pos2);
    }

    static int lastIndexOf(byte[] source2, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        int start2;
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        byte strLastChar = target[strLastIndex];
        int min2 = sourceOffset + targetCount - 1;
        int i2 = min2 + fromIndex;
        block0: while (true) {
            if (i2 >= min2 && source2[i2] != strLastChar) {
                --i2;
                continue;
            }
            if (i2 < min2) {
                return -1;
            }
            int j = i2 - 1;
            start2 = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start2) {
                if (source2[j--] == target[k--]) continue;
                --i2;
                continue block0;
            }
            break;
        }
        return start2 - sourceOffset + 1;
    }

    public boolean startsWith(ByteList other, int toffset) {
        if (this.realSize == 0 || this.bytes().length < other.bytes().length) {
            return false;
        }
        byte[] ta = this.bytes;
        int to = this.begin + toffset;
        byte[] pa = other.bytes;
        int po = other.begin;
        int pc = other.realSize;
        while (--pc >= 0) {
            if (ta[to++] == pa[po++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(ByteList other) {
        return this.startsWith(other, 0);
    }

    public boolean endsWith(ByteList other) {
        return this.startsWith(other, this.realSize - other.realSize);
    }

    public boolean equals(Object other) {
        if (other instanceof ByteList) {
            return this.equal((ByteList)other);
        }
        return false;
    }

    public boolean equal(ByteList other) {
        if (other == this) {
            return true;
        }
        if (this.hash != 0 && other.hash != 0 && this.hash != other.hash) {
            return false;
        }
        int last2 = this.realSize;
        if (last2 == other.realSize) {
            byte[] buf = this.bytes;
            byte[] otherBuf = other.bytes;
            int first2 = -1;
            while (--last2 > first2 && buf[this.begin + last2] == otherBuf[other.begin + last2] && ++first2 < last2 && buf[this.begin + first2] == otherBuf[other.begin + first2]) {
            }
            return first2 >= last2;
        }
        return false;
    }

    public boolean sample_equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ByteList) {
            ByteList b = (ByteList)other;
            int size2 = this.realSize;
            if (size2 == b.realSize) {
                byte[] buf = this.bytes;
                int first2 = -1;
                int last2 = size2 + 1 & 0xFFFFFFFE;
                while ((last2 -= 2) >= 0 && buf[this.begin + last2] == b.bytes[b.begin + last2] && (first2 += 2) < size2 && buf[this.begin + first2] == b.bytes[b.begin + first2]) {
                }
                return last2 < 0 || first2 == size2;
            }
        }
        return false;
    }

    public int compareTo(Object other) {
        return this.cmp((ByteList)other);
    }

    public int cmp(ByteList other) {
        if (other == this) {
            return 0;
        }
        int size2 = this.realSize;
        int len = Math.min(size2, other.realSize);
        int offset2 = -1;
        while (++offset2 < len && this.bytes[this.begin + offset2] == other.bytes[other.begin + offset2]) {
        }
        if (offset2 < len) {
            return (this.bytes[this.begin + offset2] & 0xFF) > (other.bytes[other.begin + offset2] & 0xFF) ? 1 : -1;
        }
        return size2 == other.realSize ? 0 : (size2 == len ? -1 : 1);
    }

    public int caseInsensitiveCmp(ByteList other) {
        if (other == this) {
            return 0;
        }
        int size2 = this.realSize;
        int len = Math.min(size2, other.realSize);
        int other_begin = other.begin;
        byte[] other_bytes = other.bytes;
        int offset2 = -1;
        while (++offset2 < len) {
            byte myCharIgnoreCase = AsciiTables.ToLowerCaseTable[this.bytes[this.begin + offset2] & 0xFF];
            byte otherCharIgnoreCase = AsciiTables.ToLowerCaseTable[other_bytes[other_begin + offset2] & 0xFF];
            if (myCharIgnoreCase < otherCharIgnoreCase) {
                return -1;
            }
            if (myCharIgnoreCase <= otherCharIgnoreCase) continue;
            return 1;
        }
        return size2 == other.realSize ? 0 : (size2 == len ? -1 : 1);
    }

    public byte[] unsafeBytes() {
        return this.bytes;
    }

    public byte[] bytes() {
        byte[] newBytes = new byte[this.realSize];
        System.arraycopy(this.bytes, this.begin, newBytes, 0, this.realSize);
        return newBytes;
    }

    public int begin() {
        return this.begin;
    }

    private void grow(int increaseRequested) {
        if (increaseRequested < 0) {
            return;
        }
        int newSize = this.realSize + increaseRequested;
        if (newSize > this.bytes.length - this.begin) {
            byte[] newBytes = new byte[newSize + (newSize >> 1)];
            if (this.bytes.length != 0) {
                System.arraycopy(this.bytes, this.begin, newBytes, 0, this.realSize);
            }
            this.bytes = newBytes;
            this.begin = 0;
        }
    }

    public int hashCode() {
        int currentHash = this.hash;
        if (currentHash != 0) {
            return currentHash;
        }
        int key2 = 0;
        int begin2 = this.begin;
        int realSize = this.realSize;
        byte[] bytes2 = this.bytes;
        int index2 = begin2;
        int end2 = begin2 + realSize;
        while (index2 < end2) {
            key2 = (key2 << 16) + (key2 << 6) - key2 + bytes2[index2++];
        }
        key2 += key2 >> 5;
        this.hash = key2;
        return this.hash;
    }

    public String toString() {
        String decoded = this.stringValue;
        if (decoded == null) {
            this.stringValue = decoded = ByteList.decode(this.bytes, this.begin, this.realSize, "ISO-8859-1");
        }
        return decoded;
    }

    public static ByteList create(CharSequence s2) {
        return new ByteList(ByteList.plain(s2), false);
    }

    public static byte[] plain(CharSequence s2) {
        if (s2 instanceof String) {
            return ByteList.encode(s2, "ISO-8859-1");
        }
        byte[] bytes2 = new byte[s2.length()];
        for (int i2 = 0; i2 < bytes2.length; ++i2) {
            bytes2[i2] = (byte)s2.charAt(i2);
        }
        return bytes2;
    }

    public static byte[] plain(char[] s2) {
        byte[] bytes2 = new byte[s2.length];
        for (int i2 = 0; i2 < s2.length; ++i2) {
            bytes2[i2] = (byte)s2[i2];
        }
        return bytes2;
    }

    public static char[] plain(byte[] b, int start2, int length2) {
        assert (b != null) : "byte array cannot be null";
        assert (start2 >= 0 && start2 + length2 <= b.length) : "Invalid start or start+length too long";
        char[] chars2 = new char[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            chars2[i2] = (char)(b[start2 + i2] & 0xFF);
        }
        return chars2;
    }

    public static char[] plain(byte[] b) {
        assert (b != null) : "byte array cannot be null";
        char[] chars2 = new char[b.length];
        for (int i2 = 0; i2 < b.length; ++i2) {
            chars2[i2] = (char)(b[i2] & 0xFF);
        }
        return chars2;
    }

    public static String decode(byte[] data2, int offset2, int length2, String charsetName) {
        return ByteList.lookup(charsetName).decode(ByteBuffer.wrap(data2, offset2, length2)).toString();
    }

    public static String decode(byte[] data2, String charsetName) {
        return ByteList.lookup(charsetName).decode(ByteBuffer.wrap(data2)).toString();
    }

    public static byte[] encode(CharSequence data2, String charsetName) {
        return ByteList.lookup(charsetName).encode(CharBuffer.wrap(data2)).array();
    }

    private static Charset lookup(String alias2) {
        Charset cs = (Charset)charsetsByAlias.get(alias2);
        if (cs == null) {
            cs = Charset.forName(alias2);
            charsetsByAlias.putIfAbsent(alias2, cs);
        }
        return cs;
    }

    public char charAt(int ix) {
        return (char)(this.bytes[this.begin + ix] & 0xFF);
    }

    public CharSequence subSequence(int start2, int end2) {
        return new ByteList(this, start2, end2 - start2);
    }

    public static int memcmp(byte[] first2, int firstStart, int firstLen, byte[] second, int secondStart, int secondLen) {
        if (first2 == second) {
            return 0;
        }
        int len = Math.min(firstLen, secondLen);
        int offset2 = -1;
        while (++offset2 < len && first2[firstStart + offset2] == second[secondStart + offset2]) {
        }
        if (offset2 < len) {
            return (first2[firstStart + offset2] & 0xFF) > (second[secondStart + offset2] & 0xFF) ? 1 : -1;
        }
        return firstLen == secondLen ? 0 : (firstLen == len ? -1 : 1);
    }

    public static int memcmp(byte[] first2, int firstStart, byte[] second, int secondStart, int len) {
        if (first2 == second) {
            return 0;
        }
        int offset2 = -1;
        while (++offset2 < len && first2[firstStart + offset2] == second[secondStart + offset2]) {
        }
        if (offset2 < len) {
            return (first2[firstStart + offset2] & 0xFF) > (second[secondStart + offset2] & 0xFF) ? 1 : -1;
        }
        return 0;
    }

    public final byte[] getUnsafeBytes() {
        return this.bytes;
    }

    public final void setUnsafeBytes(byte[] bytes2) {
        assert (bytes2 != null);
        this.bytes = bytes2;
        this.invalidate();
    }

    public final int getBegin() {
        return this.begin;
    }

    public final void setBegin(int begin2) {
        assert (begin2 >= 0);
        this.begin = begin2;
        this.invalidate();
    }

    public final int getRealSize() {
        return this.realSize;
    }

    public final void setRealSize(int realSize) {
        assert (realSize >= 0);
        this.realSize = realSize;
        this.invalidate();
    }

    public final Encoding getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(Encoding encoding2) {
        assert (encoding2 != null);
        this.encoding = ByteList.safeEncoding(encoding2);
        this.invalidate();
    }

    public static Encoding safeEncoding(Encoding incoming) {
        if (incoming == null) {
            return ASCIIEncoding.INSTANCE;
        }
        return incoming;
    }
}

