/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.CompatVersion;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.java.codegen.RealClassGenerator;
import org.jruby.java.codegen.Reified;
import org.jruby.javasupport.Java;
import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.ClassWriter;
import org.jruby.org.objectweb.asm.FieldVisitor;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.runtime.ivars.VariableAccessorField;
import org.jruby.runtime.ivars.VariableTableManager;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.util.ClassCache;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.collections.WeakHashSet;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

@JRubyClass(name={"Class"}, parent="Module")
public class RubyClass
extends RubyModule {
    private static final Logger LOG = LoggerFactory.getLogger("RubyClass");
    public static final ObjectAllocator CLASS_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyClass clazz = new RubyClass(runtime);
            clazz.allocator = ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR;
            return clazz;
        }
    };
    protected static final ObjectMarshal DEFAULT_OBJECT_MARSHAL = new ObjectMarshal(){

        @Override
        public void marshalTo(Ruby runtime, Object obj, RubyClass type2, MarshalStream marshalStream) throws IOException {
            IRubyObject object = (IRubyObject)obj;
            marshalStream.registerLinkTarget(object);
            marshalStream.dumpVariables(object.getVariableList());
        }

        @Override
        public Object unmarshalFrom(Ruby runtime, RubyClass type2, UnmarshalStream unmarshalStream) throws IOException {
            IRubyObject result2 = type2.allocate();
            unmarshalStream.registerLinkTarget(result2);
            unmarshalStream.defaultVariablesUnmarshal(result2);
            return result2;
        }
    };
    private static final boolean DEBUG_REIFY = false;
    protected final Ruby runtime;
    private ObjectAllocator allocator;
    protected ObjectMarshal marshal;
    private Set<RubyClass> subclasses;
    public static final int CS_IDX_INITIALIZE = 0;
    public static final String[] CS_NAMES = new String[]{"initialize"};
    private final CallSite[] baseCallSites = new CallSite[CS_NAMES.length];
    private CallSite[] extraCallSites;
    private Class reifiedClass;
    private Map<String, List<Map<Class, Map<String, Object>>>> parameterAnnotations;
    private Map<String, Map<Class, Map<String, Object>>> methodAnnotations;
    private Map<String, Map<Class, Map<String, Object>>> fieldAnnotations;
    private Map<String, Class[]> methodSignatures;
    private Map<String, Class> fieldSignatures;
    private Map<Class, Map<String, Object>> classAnnotations;
    private MarshalTuple cachedDumpMarshal;
    private CacheEntry cachedLoad;
    private final RubyClass realClass;
    private final VariableTableManager variableTableManager;

    public static void createClassClass(Ruby runtime, RubyClass classClass) {
        classClass.index = 13;
        classClass.setReifiedClass(RubyClass.class);
        classClass.kindOf = new RubyModule.JavaClassKindOf(RubyClass.class);
        classClass.undefineMethod("module_function");
        classClass.undefineMethod("append_features");
        classClass.undefineMethod("extend_object");
        classClass.defineAnnotatedMethods(RubyClass.class);
    }

    public ObjectAllocator getAllocator() {
        return this.allocator;
    }

    public void setAllocator(ObjectAllocator allocator) {
        this.allocator = allocator;
    }

    public void setClassAllocator(final Class cls) {
        this.allocator = new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                try {
                    RubyBasicObject object = (RubyBasicObject)cls.newInstance();
                    object.setMetaClass(klazz);
                    return object;
                }
                catch (InstantiationException ie) {
                    throw runtime.newTypeError("could not allocate " + cls + " with default constructor:\n" + ie);
                }
                catch (IllegalAccessException iae) {
                    throw runtime.newSecurityError("could not allocate " + cls + " due to inaccessible default constructor:\n" + iae);
                }
            }
        };
        this.reifiedClass = cls;
    }

    public void setRubyClassAllocator(final Class cls) {
        try {
            final Constructor constructor2 = cls.getConstructor(Ruby.class, RubyClass.class);
            this.allocator = new ObjectAllocator(){

                @Override
                public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                    try {
                        return (IRubyObject)constructor2.newInstance(runtime, klazz);
                    }
                    catch (InvocationTargetException ite) {
                        throw runtime.newTypeError("could not allocate " + cls + " with (Ruby, RubyClass) constructor:\n" + ite);
                    }
                    catch (InstantiationException ie) {
                        throw runtime.newTypeError("could not allocate " + cls + " with (Ruby, RubyClass) constructor:\n" + ie);
                    }
                    catch (IllegalAccessException iae) {
                        throw runtime.newSecurityError("could not allocate " + cls + " due to inaccessible (Ruby, RubyClass) constructor:\n" + iae);
                    }
                }
            };
            this.reifiedClass = cls;
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
    }

    public void setRubyStaticAllocator(final Class cls) {
        try {
            final Method method2 = cls.getDeclaredMethod("__allocate__", Ruby.class, RubyClass.class);
            this.allocator = new ObjectAllocator(){

                @Override
                public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                    try {
                        return (IRubyObject)method2.invoke(null, runtime, klazz);
                    }
                    catch (InvocationTargetException ite) {
                        throw runtime.newTypeError("could not allocate " + cls + " with (Ruby, RubyClass) constructor:\n" + ite);
                    }
                    catch (IllegalAccessException iae) {
                        throw runtime.newSecurityError("could not allocate " + cls + " due to inaccessible (Ruby, RubyClass) constructor:\n" + iae);
                    }
                }
            };
            this.reifiedClass = cls;
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
    }

    @JRubyMethod(name={"allocate"})
    public IRubyObject allocate() {
        if (!(this.superClass != null || this.runtime.is1_9() && this == this.runtime.getBasicObject())) {
            throw this.runtime.newTypeError("can't instantiate uninitialized class");
        }
        IRubyObject obj = this.allocator.allocate(this.runtime, this);
        if (obj.getMetaClass().getRealClass() != this.getRealClass()) {
            throw this.runtime.newTypeError("wrong instance allocation");
        }
        return obj;
    }

    public CallSite getBaseCallSite(int idx) {
        return this.baseCallSites[idx];
    }

    public CallSite[] getBaseCallSites() {
        return this.baseCallSites;
    }

    public CallSite[] getExtraCallSites() {
        return this.extraCallSites;
    }

    public VariableTableManager getVariableTableManager() {
        return this.variableTableManager;
    }

    public boolean hasObjectID() {
        return this.variableTableManager.hasObjectID();
    }

    public Map<String, VariableAccessor> getVariableAccessorsForRead() {
        return this.variableTableManager.getVariableAccessorsForRead();
    }

    public VariableAccessor getVariableAccessorForWrite(String name2) {
        return this.variableTableManager.getVariableAccessorForWrite(name2);
    }

    public VariableAccessor getVariableAccessorForRead(String name2) {
        VariableAccessor accessor = this.getVariableAccessorsForRead().get(name2);
        if (accessor == null) {
            accessor = VariableAccessor.DUMMY_ACCESSOR;
        }
        return accessor;
    }

    public VariableAccessorField getObjectIdAccessorField() {
        return this.variableTableManager.getObjectIdAccessorField();
    }

    public VariableAccessorField getNativeHandleAccessorField() {
        return this.variableTableManager.getNativeHandleAccessorField();
    }

    public VariableAccessor getNativeHandleAccessorForWrite() {
        return this.variableTableManager.getNativeHandleAccessorForWrite();
    }

    public VariableAccessorField getFFIHandleAccessorField() {
        return this.variableTableManager.getFFIHandleAccessorField();
    }

    public VariableAccessor getFFIHandleAccessorForRead() {
        return this.variableTableManager.getFFIHandleAccessorForRead();
    }

    public VariableAccessor getFFIHandleAccessorForWrite() {
        return this.variableTableManager.getFFIHandleAccessorForWrite();
    }

    public VariableAccessorField getObjectGroupAccessorField() {
        return this.variableTableManager.getObjectGroupAccessorField();
    }

    public VariableAccessor getObjectGroupAccessorForRead() {
        return this.variableTableManager.getObjectGroupAccessorForRead();
    }

    public VariableAccessor getObjectGroupAccessorForWrite() {
        return this.variableTableManager.getObjectGroupAccessorForWrite();
    }

    public int getVariableTableSize() {
        return this.variableTableManager.getVariableTableSize();
    }

    public int getVariableTableSizeWithExtras() {
        return this.variableTableManager.getVariableTableSizeWithExtras();
    }

    public String[] getVariableNames() {
        return this.variableTableManager.getVariableNames();
    }

    public Map<String, VariableAccessor> getVariableTableCopy() {
        return new HashMap<String, VariableAccessor>(this.getVariableAccessorsForRead());
    }

    @Override
    public int getNativeTypeIndex() {
        return 13;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    public static RubyClass createBootstrapClass(Ruby runtime, String name2, RubyClass superClass, ObjectAllocator allocator) {
        RubyClass obj;
        if (superClass == null) {
            obj = new RubyClass(runtime);
            obj.marshal = DEFAULT_OBJECT_MARSHAL;
        } else {
            obj = new RubyClass(runtime, superClass);
        }
        obj.setAllocator(allocator);
        obj.setBaseName(name2);
        return obj;
    }

    protected RubyClass(Ruby runtime, RubyClass superClass, boolean objectSpace) {
        super(runtime, runtime.getClassClass(), objectSpace);
        for (int i2 = 0; i2 < CS_NAMES.length; ++i2) {
            this.baseCallSites[i2] = MethodIndex.getFunctionalCallSite(CS_NAMES[i2]);
        }
        this.cachedDumpMarshal = MarshalTuple.NULL_TUPLE;
        this.cachedLoad = CacheEntry.NULL_CACHE;
        this.runtime = runtime;
        if (superClass == null) {
            this.realClass = null;
            this.variableTableManager = new VariableTableManager(this);
        } else {
            this.realClass = superClass.realClass;
            this.variableTableManager = this.realClass != null ? this.realClass.variableTableManager : new VariableTableManager(this);
        }
        this.setSuperClass(superClass);
    }

    protected RubyClass(Ruby runtime) {
        super(runtime, runtime.getClassClass());
        for (int i2 = 0; i2 < CS_NAMES.length; ++i2) {
            this.baseCallSites[i2] = MethodIndex.getFunctionalCallSite(CS_NAMES[i2]);
        }
        this.cachedDumpMarshal = MarshalTuple.NULL_TUPLE;
        this.cachedLoad = CacheEntry.NULL_CACHE;
        this.runtime = runtime;
        this.realClass = this;
        this.variableTableManager = new VariableTableManager(this);
        this.index = 13;
    }

    protected RubyClass(Ruby runtime, RubyClass superClazz) {
        this(runtime);
        this.setSuperClass(superClazz);
        this.marshal = superClazz.marshal;
        superClazz.addSubclass(this);
        this.allocator = superClazz.allocator;
        this.infectBy(this.superClass);
    }

    protected RubyClass(Ruby runtime, RubyClass superClazz, CallSite[] extraCallSites) {
        this(runtime);
        this.setSuperClass(superClazz);
        this.marshal = superClazz.marshal;
        superClazz.addSubclass(this);
        this.extraCallSites = extraCallSites;
        this.infectBy(this.superClass);
    }

    public static RubyClass newClass(Ruby runtime, RubyClass superClass) {
        if (superClass == runtime.getClassClass()) {
            throw runtime.newTypeError("can't make subclass of Class");
        }
        if (superClass.isSingleton()) {
            throw runtime.newTypeError("can't make subclass of virtual class");
        }
        return new RubyClass(runtime, superClass);
    }

    public static RubyClass newClass(Ruby runtime, RubyClass superClass, CallSite[] extraCallSites) {
        if (superClass == runtime.getClassClass()) {
            throw runtime.newTypeError("can't make subclass of Class");
        }
        if (superClass.isSingleton()) {
            throw runtime.newTypeError("can't make subclass of virtual class");
        }
        return new RubyClass(runtime, superClass, extraCallSites);
    }

    public static RubyClass newClass(Ruby runtime, RubyClass superClass, String name2, ObjectAllocator allocator, RubyModule parent, boolean setParent) {
        RubyClass clazz = RubyClass.newClass(runtime, superClass);
        clazz.setBaseName(name2);
        clazz.setAllocator(allocator);
        clazz.makeMetaClass(superClass.getMetaClass());
        if (setParent) {
            clazz.setParent(parent);
        }
        parent.setConstant(name2, clazz);
        clazz.inherit(superClass);
        return clazz;
    }

    public static RubyClass newClass(Ruby runtime, RubyClass superClass, String name2, ObjectAllocator allocator, RubyModule parent, boolean setParent, CallSite[] extraCallSites) {
        RubyClass clazz = RubyClass.newClass(runtime, superClass, extraCallSites);
        clazz.setBaseName(name2);
        clazz.setAllocator(allocator);
        clazz.makeMetaClass(superClass.getMetaClass());
        if (setParent) {
            clazz.setParent(parent);
        }
        parent.setConstant(name2, clazz);
        clazz.inherit(superClass);
        return clazz;
    }

    @Override
    public RubyClass makeMetaClass(RubyClass superClass) {
        if (this.isSingleton()) {
            MetaClass klass = new MetaClass(this.runtime, superClass, this);
            this.setMetaClass(klass);
            klass.setMetaClass(klass);
            klass.setSuperClass(this.getSuperClass().getRealClass().getMetaClass());
            return klass;
        }
        return super.makeMetaClass(superClass);
    }

    @Deprecated
    public IRubyObject invoke(ThreadContext context, IRubyObject self2, int methodIndex, String name2, IRubyObject[] args2, CallType callType, Block block) {
        return this.invoke(context, self2, name2, args2, callType, block);
    }

    public boolean notVisibleAndNotMethodMissing(DynamicMethod method2, String name2, IRubyObject caller2, CallType callType) {
        return !method2.isCallableFrom(caller2, callType) && !name2.equals("method_missing");
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, CallType callType, Block block) {
        IRubyObject caller2;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, callType, block);
        }
        return method2.call(context, self2, (RubyModule)this, name2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, Block block) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, CallType.FUNCTIONAL, block);
        }
        return method2.call(context, self2, (RubyModule)this, name2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2, CallType callType, Block block) {
        IRubyObject caller2;
        assert (args2 != null);
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, callType, args2, block);
        }
        return method2.call(context, self2, (RubyModule)this, name2, args2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        assert (args2 != null);
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, CallType.FUNCTIONAL, args2, block);
        }
        return method2.call(context, self2, (RubyModule)this, name2, args2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2, CallType callType, Block block) {
        IRubyObject caller2;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, callType, arg2, block);
        }
        return method2.call(context, self2, (RubyModule)this, name2, arg2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2, Block block) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg2, block);
        }
        return method2.call(context, self2, (RubyModule)this, name2, arg2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, CallType callType, Block block) {
        IRubyObject caller2;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, callType, arg0, arg1, block);
        }
        return method2.call(context, self2, (RubyModule)this, name2, arg0, arg1, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg0, arg1, block);
        }
        return method2.call(context, self2, (RubyModule)this, name2, arg0, arg1, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, CallType callType, Block block) {
        IRubyObject caller2;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, callType, arg0, arg1, arg2, block);
        }
        return method2.call(context, self2, this, name2, arg0, arg1, arg2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg0, arg1, arg2, block);
        }
        return method2.call(context, self2, this, name2, arg0, arg1, arg2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, CallType callType) {
        IRubyObject caller2;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, callType, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, this, name2);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, this, name2);
    }

    public IRubyObject finvokeChecked(ThreadContext context, IRubyObject self2, String name2) {
        RubyClass klass = self2.getMetaClass();
        if (!RubyClass.checkFuncallRespondTo(context, self2.getMetaClass(), self2, name2)) {
            return null;
        }
        DynamicMethod me = this.searchMethod(name2);
        if (!RubyClass.checkFuncallCallable(context, me, CallType.FUNCTIONAL, self2)) {
            return RubyClass.checkFuncallMissing(context, klass, self2, name2, new IRubyObject[0]);
        }
        return me.call(context, self2, klass, name2);
    }

    private static IRubyObject checkFuncallExec(ThreadContext context, IRubyObject self2, String name2, IRubyObject ... args2) {
        IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 1, args2.length);
        newArgs[0] = context.runtime.newSymbol(name2);
        return self2.callMethod(context, "method_missing", newArgs);
    }

    private static IRubyObject checkFuncallFailed(ThreadContext context, IRubyObject self2, String name2, RubyClass expClass, IRubyObject ... args2) {
        if (self2.respondsTo(name2)) {
            throw context.runtime.newRaiseException(expClass, name2);
        }
        return null;
    }

    private static boolean checkFuncallRespondTo(ThreadContext context, RubyClass klass, IRubyObject recv2, String mid) {
        Ruby runtime = context.runtime;
        DynamicMethod me = klass.searchMethod("respond_to?");
        if (me != null && !me.isUndefined() && !me.isBuiltin()) {
            Arity arity2 = me.getArity();
            if (arity2.getValue() > 2) {
                throw runtime.newArgumentError("respond_to? must accept 1 or 2 arguments (requires " + arity2 + ")");
            }
            IRubyObject result2 = me.call(context, recv2, (RubyModule)klass, "respond_to?", (IRubyObject)runtime.newString(mid), runtime.getTrue());
            if (!result2.isTrue()) {
                return false;
            }
        }
        return true;
    }

    public static boolean checkFuncallCallable(ThreadContext context, DynamicMethod method2, CallType callType, IRubyObject self2) {
        return RubyClass.rbMethodCallStatus(context, method2, callType, self2);
    }

    public static boolean rbMethodCallStatus(ThreadContext context, DynamicMethod method2, CallType callType, IRubyObject self2) {
        return method2 != null && !method2.isUndefined() && method2.isCallableFrom(self2, callType);
    }

    private static IRubyObject checkFuncallMissing(ThreadContext context, RubyClass klass, IRubyObject self2, String method2, IRubyObject ... args2) {
        Ruby runtime = context.runtime;
        if (klass.isMethodBuiltin("method_missing")) {
            return null;
        }
        try {
            return RubyClass.checkFuncallExec(context, self2, method2, args2);
        }
        catch (RaiseException e) {
            context.setErrorInfo(context.nil);
            return RubyClass.checkFuncallFailed(context, self2, method2, runtime.getNoMethodError(), args2);
        }
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2, CallType callType) {
        IRubyObject caller2;
        assert (args2 != null);
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, callType, args2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, (RubyModule)this, name2, args2);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2) {
        assert (args2 != null);
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, CallType.FUNCTIONAL, args2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, (RubyModule)this, name2, args2);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2, CallType callType) {
        IRubyObject caller2;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, callType, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, (RubyModule)this, name2, arg2);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, (RubyModule)this, name2, arg2);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, CallType callType) {
        IRubyObject caller2;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, callType, arg0, arg1, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, (RubyModule)this, name2, arg0, arg1);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg0, arg1, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, (RubyModule)this, name2, arg0, arg1);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, CallType callType) {
        IRubyObject caller2;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, callType, arg0, arg1, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, (RubyModule)this, name2, arg0, arg1, arg2);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, CallType.FUNCTIONAL, arg0, arg1, arg2, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, (RubyModule)this, name2, arg0, arg1, arg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpReifiedClass(String dumpDir, String javaPath, byte[] classBytes) {
        if (dumpDir != null) {
            if (dumpDir.equals("")) {
                dumpDir = ".";
            }
            FileOutputStream classStream = null;
            try {
                File classFile = new File(dumpDir, javaPath + ".class");
                classFile.getParentFile().mkdirs();
                classStream = new FileOutputStream(classFile);
                classStream.write(classBytes);
            }
            catch (IOException io2) {
                this.getRuntime().getWarnings().warn("unable to dump class file: " + io2.getMessage());
            }
            finally {
                if (classStream != null) {
                    try {
                        classStream.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
    }

    private void generateMethodAnnotations(Map<Class, Map<String, Object>> methodAnnos, SkinnyMethodAdapter m, List<Map<Class, Map<String, Object>>> parameterAnnos) {
        if (methodAnnos != null && methodAnnos.size() != 0) {
            for (Map.Entry<Class, Map<String, Object>> entry : methodAnnos.entrySet()) {
                m.visitAnnotationWithFields(CodegenUtils.ci(entry.getKey()), true, entry.getValue());
            }
        }
        if (parameterAnnos != null && parameterAnnos.size() != 0) {
            for (int i2 = 0; i2 < parameterAnnos.size(); ++i2) {
                Map<Class, Map<String, Object>> annos = parameterAnnos.get(i2);
                if (annos == null || annos.size() == 0) continue;
                for (Map.Entry<Class, Map<String, Object>> entry : annos.entrySet()) {
                    m.visitParameterAnnotationWithFields(i2, CodegenUtils.ci(entry.getKey()), true, entry.getValue());
                }
            }
        }
    }

    private boolean shouldCallMethodMissing(DynamicMethod method2) {
        return method2.isUndefined();
    }

    private boolean shouldCallMethodMissing(DynamicMethod method2, String name2, IRubyObject caller2, CallType callType) {
        return method2.isUndefined() || this.notVisibleAndNotMethodMissing(method2, name2, caller2, callType);
    }

    public IRubyObject invokeInherited(ThreadContext context, IRubyObject self2, IRubyObject subclass) {
        DynamicMethod method2 = this.getMetaClass().searchMethod("inherited");
        if (method2.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), "inherited", CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method2.call(context, self2, (RubyModule)this.getMetaClass(), "inherited", subclass, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"new"}, omit=true)
    public IRubyObject newInstance(ThreadContext context, Block block) {
        IRubyObject obj = this.allocate();
        this.baseCallSites[0].call(context, obj, obj, block);
        return obj;
    }

    @JRubyMethod(name={"new"}, omit=true)
    public IRubyObject newInstance(ThreadContext context, IRubyObject arg0, Block block) {
        IRubyObject obj = this.allocate();
        this.baseCallSites[0].call(context, obj, obj, arg0, block);
        return obj;
    }

    @JRubyMethod(name={"new"}, omit=true)
    public IRubyObject newInstance(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        IRubyObject obj = this.allocate();
        this.baseCallSites[0].call(context, obj, obj, arg0, arg1, block);
        return obj;
    }

    @JRubyMethod(name={"new"}, omit=true)
    public IRubyObject newInstance(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        IRubyObject obj = this.allocate();
        this.baseCallSites[0].call(context, obj, obj, arg0, arg1, arg2, block);
        return obj;
    }

    @JRubyMethod(name={"new"}, rest=true, omit=true)
    public IRubyObject newInstance(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject obj = this.allocate();
        this.baseCallSites[0].call(context, obj, obj, args2, block);
        return obj;
    }

    @Override
    @JRubyMethod(compat=CompatVersion.RUBY1_8, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        this.checkNotInitialized();
        return this.initializeCommon(context, this.runtime.getObject(), block, false);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject superObject, Block block) {
        this.checkNotInitialized();
        RubyClass.checkInheritable(superObject);
        return this.initializeCommon(context, (RubyClass)superObject, block, false);
    }

    @JRubyMethod(name={"initialize"}, compat=CompatVersion.RUBY1_9, visibility=Visibility.PRIVATE)
    public IRubyObject initialize19(ThreadContext context, Block block) {
        this.checkNotInitialized();
        return this.initializeCommon(context, this.runtime.getObject(), block, true);
    }

    @JRubyMethod(name={"initialize"}, compat=CompatVersion.RUBY1_9, visibility=Visibility.PRIVATE)
    public IRubyObject initialize19(ThreadContext context, IRubyObject superObject, Block block) {
        this.checkNotInitialized();
        RubyClass.checkInheritable(superObject);
        return this.initializeCommon(context, (RubyClass)superObject, block, true);
    }

    private IRubyObject initializeCommon(ThreadContext context, RubyClass superClazz, Block block, boolean ruby1_9) {
        this.setSuperClass(superClazz);
        this.allocator = superClazz.allocator;
        this.makeMetaClass(superClazz.getMetaClass());
        this.marshal = superClazz.marshal;
        superClazz.addSubclass(this);
        if (ruby1_9) {
            this.inherit(superClazz);
            super.initialize(context, block);
        } else {
            super.initialize(context, block);
            this.inherit(superClazz);
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        this.checkNotInitialized();
        if (original instanceof MetaClass) {
            throw this.runtime.newTypeError("can't copy singleton class");
        }
        super.initialize_copy(original);
        this.allocator = ((RubyClass)original).allocator;
        return this;
    }

    protected void setModuleSuperClass(RubyClass superClass) {
        if (this.superClass != null) {
            this.superClass.removeSubclass(this);
        }
        superClass.addSubclass(this);
        this.setSuperClass(superClass);
    }

    public Collection<RubyClass> subclasses(boolean includeDescendants) {
        Set<RubyClass> mySubclasses = this.subclasses;
        if (mySubclasses != null) {
            ArrayList<RubyClass> mine = new ArrayList<RubyClass>(mySubclasses);
            if (includeDescendants) {
                for (RubyClass i2 : mySubclasses) {
                    mine.addAll(i2.subclasses(includeDescendants));
                }
            }
            return mine;
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addSubclass(RubyClass subclass) {
        Object object = this.runtime.getHierarchyLock();
        synchronized (object) {
            Set<RubyClass> oldSubclasses = this.subclasses;
            if (oldSubclasses == null) {
                this.subclasses = oldSubclasses = new WeakHashSet<RubyClass>(4);
            }
            oldSubclasses.add(subclass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeSubclass(RubyClass subclass) {
        Object object = this.runtime.getHierarchyLock();
        synchronized (object) {
            Set<RubyClass> oldSubclasses = this.subclasses;
            if (oldSubclasses == null) {
                return;
            }
            oldSubclasses.remove(subclass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void replaceSubclass(RubyClass subclass, RubyClass newSubclass) {
        Object object = this.runtime.getHierarchyLock();
        synchronized (object) {
            Set<RubyClass> oldSubclasses = this.subclasses;
            if (oldSubclasses == null) {
                return;
            }
            oldSubclasses.remove(subclass);
            oldSubclasses.add(newSubclass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void becomeSynchronized() {
        Object object = this.getRuntime().getHierarchyLock();
        synchronized (object) {
            super.becomeSynchronized();
            Set<RubyClass> mySubclasses = this.subclasses;
            if (mySubclasses != null) {
                for (RubyClass subclass : mySubclasses) {
                    subclass.becomeSynchronized();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateCacheDescendants() {
        super.invalidateCacheDescendants();
        Object object = this.runtime.getHierarchyLock();
        synchronized (object) {
            Set<RubyClass> mySubclasses = this.subclasses;
            if (mySubclasses != null) {
                for (RubyClass subclass : mySubclasses) {
                    subclass.invalidateCacheDescendants();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvalidatorsAndFlush(List<Invalidator> invalidators) {
        invalidators.add(this.methodInvalidator);
        if (!this.runtime.isBooting()) {
            this.cachedMethods.clear();
        }
        if (this.subclasses == null || this.subclasses.isEmpty()) {
            return;
        }
        Object object = this.runtime.getHierarchyLock();
        synchronized (object) {
            Set<RubyClass> mySubclasses = this.subclasses;
            if (mySubclasses != null) {
                for (RubyClass subclass : mySubclasses) {
                    subclass.addInvalidatorsAndFlush(invalidators);
                }
            }
        }
    }

    public Ruby getClassRuntime() {
        return this.runtime;
    }

    public final RubyClass getRealClass() {
        return this.realClass;
    }

    @JRubyMethod(name={"inherited"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject inherited(ThreadContext context, IRubyObject arg2) {
        return this.runtime.getNil();
    }

    public void inherit(RubyClass superClazz) {
        if (superClazz == null) {
            superClazz = this.runtime.getObject();
        }
        if (this.getRuntime().getNil() != null) {
            superClazz.invokeInherited(this.runtime.getCurrentContext(), superClazz, this);
        }
    }

    @JRubyMethod(name={"superclass"})
    public IRubyObject superclass(ThreadContext context) {
        RubyClass superClazz = this.superClass;
        if (superClazz == null) {
            if (this.runtime.is1_9() && this.metaClass == this.runtime.getBasicObject().getMetaClass()) {
                return this.runtime.getNil();
            }
            throw this.runtime.newTypeError("uninitialized class");
        }
        while (superClazz != null && superClazz.isIncluded()) {
            superClazz = superClazz.superClass;
        }
        return superClazz != null ? superClazz : this.runtime.getNil();
    }

    private void checkNotInitialized() {
        if (this.superClass != null || this.runtime.is1_9() && this == this.runtime.getBasicObject()) {
            throw this.runtime.newTypeError("already initialized class");
        }
    }

    public static void checkInheritable(IRubyObject superClass) {
        if (!(superClass instanceof RubyClass)) {
            throw superClass.getRuntime().newTypeError("superclass must be a Class (" + superClass.getMetaClass() + " given)");
        }
        if (((RubyClass)superClass).isSingleton()) {
            throw superClass.getRuntime().newTypeError("can't make subclass of virtual class");
        }
    }

    public final ObjectMarshal getMarshal() {
        return this.marshal;
    }

    public final void setMarshal(ObjectMarshal marshal) {
        this.marshal = marshal;
    }

    public final void marshal(Object obj, MarshalStream marshalStream) throws IOException {
        this.getMarshal().marshalTo(this.runtime, obj, this, marshalStream);
    }

    public final Object unmarshal(UnmarshalStream unmarshalStream) throws IOException {
        return this.getMarshal().unmarshalFrom(this.runtime, this, unmarshalStream);
    }

    public static void marshalTo(RubyClass clazz, MarshalStream output) throws IOException {
        output.registerLinkTarget(clazz);
        output.writeString(MarshalStream.getPathFromClass(clazz));
    }

    public static RubyClass unmarshalFrom(UnmarshalStream input) throws IOException {
        String name2 = RubyString.byteListToString(input.unmarshalString());
        RubyClass result2 = UnmarshalStream.getClassFromPath(input.getRuntime(), name2);
        input.registerLinkTarget(result2);
        return result2;
    }

    public boolean isReifiable() {
        RubyClass realSuper = null;
        if (this.reifiedClass != null) {
            return false;
        }
        if (this.superClass == null || (realSuper = this.superClass.getRealClass()) == null) {
            return false;
        }
        Class reifiedSuper = realSuper.reifiedClass;
        if (reifiedSuper != null) {
            return reifiedSuper == RubyObject.class || reifiedSuper == RubyBasicObject.class || Reified.class.isAssignableFrom(reifiedSuper);
        }
        return realSuper.isReifiable();
    }

    public void reifyWithAncestors() {
        this.reifyWithAncestors(null, true);
    }

    public void reifyWithAncestors(String classDumpDir) {
        this.reifyWithAncestors(classDumpDir, true);
    }

    public void reifyWithAncestors(boolean useChildLoader) {
        this.reifyWithAncestors(null, useChildLoader);
    }

    public void reifyWithAncestors(String classDumpDir, boolean useChildLoader) {
        if (this.isReifiable()) {
            RubyClass realSuper = this.getSuperClass().getRealClass();
            if (realSuper.reifiedClass == null) {
                realSuper.reifyWithAncestors(classDumpDir, useChildLoader);
            }
            this.reify(classDumpDir, useChildLoader);
        }
    }

    public synchronized void reify() {
        this.reify(null, true);
    }

    public synchronized void reify(String classDumpDir) {
        this.reify(classDumpDir, true);
    }

    public synchronized void reify(boolean useChildLoader) {
        this.reify(null, useChildLoader);
    }

    public synchronized void reify(String classDumpDir, boolean useChildLoader) {
        int rubyIndex;
        int baseIndex;
        Class[] params2;
        String signature;
        Class[] methodSignature;
        List<Map<Class, Map<String, Object>>> parameterAnnos;
        Map<Class, Map<String, Object>> methodAnnos;
        String javaMethodName;
        String methodName;
        if (!this.isReifiable()) {
            return;
        }
        Class reifiedParent = RubyObject.class;
        String name2 = this.getBaseName() == null ? "AnonymousRubyClass__" + this.id : this.getName();
        String javaName = "rubyobj." + name2.replaceAll("::", ".");
        String javaPath = "rubyobj/" + name2.replaceAll("::", "/");
        Class parentReified = this.superClass.getRealClass().getReifiedClass();
        if (parentReified == null) {
            throw this.getClassRuntime().newTypeError("class " + this.getName() + " parent class is not yet reified");
        }
        ClassLoader parentCL = parentReified.getClassLoader() instanceof ClassCache.OneShotClassLoader ? (ClassCache.OneShotClassLoader)this.superClass.getRealClass().getReifiedClass().getClassLoader() : (useChildLoader ? new ClassCache.OneShotClassLoader(this.runtime.getJRubyClassLoader()) : this.runtime.getJRubyClassLoader());
        if (this.superClass.reifiedClass != null) {
            reifiedParent = this.superClass.reifiedClass;
        }
        Class[] interfaces2 = Java.getInterfacesFromRubyClass(this);
        String[] interfaceNames = new String[interfaces2.length + 1];
        interfaceNames[0] = CodegenUtils.p(Reified.class);
        for (int i2 = 0; i2 < interfaces2.length; ++i2) {
            interfaceNames[i2 + 1] = CodegenUtils.p(interfaces2[i2]);
        }
        ClassWriter cw = new ClassWriter(3);
        cw.visit(RubyInstanceConfig.JAVA_VERSION, 33, javaPath, null, CodegenUtils.p(reifiedParent), interfaceNames);
        if (this.classAnnotations != null && this.classAnnotations.size() != 0) {
            for (Map.Entry<Class, Map<String, Object>> entry : this.classAnnotations.entrySet()) {
                Class annoType = entry.getKey();
                Map<String, Object> fields2 = entry.getValue();
                AnnotationVisitor av = cw.visitAnnotation(CodegenUtils.ci(annoType), true);
                CodegenUtils.visitAnnotationFields(av, fields2);
                av.visitEnd();
            }
        }
        cw.visitField(10, "ruby", CodegenUtils.ci(Ruby.class), null, null);
        cw.visitField(10, "rubyClass", CodegenUtils.ci(RubyClass.class), null, null);
        SkinnyMethodAdapter m = new SkinnyMethodAdapter(cw, 9, "clinit", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class), null, null);
        m.start();
        m.aload(0);
        m.putstatic(javaPath, "ruby", CodegenUtils.ci(Ruby.class));
        m.aload(1);
        m.putstatic(javaPath, "rubyClass", CodegenUtils.ci(RubyClass.class));
        m.voidreturn();
        m.end();
        m = new SkinnyMethodAdapter(cw, 1, "<init>", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class), null, null);
        m.aload(0);
        m.aload(1);
        m.aload(2);
        m.invokespecial(CodegenUtils.p(reifiedParent), "<init>", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class));
        m.voidreturn();
        m.end();
        m = new SkinnyMethodAdapter(cw, 1, "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null);
        m.aload(0);
        m.getstatic(javaPath, "ruby", CodegenUtils.ci(Ruby.class));
        m.getstatic(javaPath, "rubyClass", CodegenUtils.ci(RubyClass.class));
        m.invokespecial(CodegenUtils.p(reifiedParent), "<init>", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class));
        m.voidreturn();
        m.end();
        for (Map.Entry<String, Class> fieldSignature : this.getFieldSignatures().entrySet()) {
            String fieldName = fieldSignature.getKey();
            Class type2 = fieldSignature.getValue();
            Map<Class, Map<String, Object>> fieldAnnos = this.getFieldAnnotations().get(fieldName);
            FieldVisitor fieldVisitor = cw.visitField(1, fieldName, CodegenUtils.ci(type2), null, null);
            if (fieldAnnos == null) continue;
            for (Map.Entry<Class, Map<String, Object>> fieldAnno : fieldAnnos.entrySet()) {
                Class annoType = fieldAnno.getKey();
                AnnotationVisitor av = fieldVisitor.visitAnnotation(CodegenUtils.ci(annoType), true);
                CodegenUtils.visitAnnotationFields(av, fieldAnno.getValue());
            }
            fieldVisitor.visitEnd();
        }
        HashSet<String> instanceMethods = new HashSet<String>();
        for (Map.Entry<String, DynamicMethod> methodEntry : this.getMethods().entrySet()) {
            methodName = methodEntry.getKey();
            if (!JavaNameMangler.willMethodMangleOk(methodName)) continue;
            javaMethodName = JavaNameMangler.mangleMethodName(methodName);
            methodAnnos = this.getMethodAnnotations().get(methodName);
            parameterAnnos = this.getParameterAnnotations().get(methodName);
            methodSignature = this.getMethodSignatures().get(methodName);
            if (methodSignature == null) {
                switch (methodEntry.getValue().getArity().getValue()) {
                    case 0: {
                        signature = CodegenUtils.sig(IRubyObject.class, new Class[0]);
                        m = new SkinnyMethodAdapter(cw, 129, javaMethodName, signature, null, null);
                        this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                        m.aload(0);
                        m.ldc(methodName);
                        m.invokevirtual(javaPath, "callMethod", CodegenUtils.sig(IRubyObject.class, String.class));
                        break;
                    }
                    default: {
                        signature = CodegenUtils.sig(IRubyObject.class, IRubyObject[].class);
                        m = new SkinnyMethodAdapter(cw, 129, javaMethodName, signature, null, null);
                        this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                        m.aload(0);
                        m.ldc(methodName);
                        m.aload(1);
                        m.invokevirtual(javaPath, "callMethod", CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject[].class));
                    }
                }
                m.areturn();
            } else {
                params2 = new Class[methodSignature.length - 1];
                System.arraycopy(methodSignature, 1, params2, 0, params2.length);
                baseIndex = 1;
                for (Class paramType : params2) {
                    if (paramType == Double.TYPE || paramType == Long.TYPE) {
                        baseIndex += 2;
                        continue;
                    }
                    ++baseIndex;
                }
                rubyIndex = baseIndex;
                signature = CodegenUtils.sig(methodSignature[0], params2);
                m = new SkinnyMethodAdapter(cw, 129, javaMethodName, signature, null, null);
                this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                m.getstatic(javaPath, "ruby", CodegenUtils.ci(Ruby.class));
                m.astore(rubyIndex);
                m.aload(0);
                m.ldc(methodName);
                RealClassGenerator.coerceArgumentsToRuby(m, params2, rubyIndex);
                m.invokevirtual(javaPath, "callMethod", CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject[].class));
                RealClassGenerator.coerceResultAndReturn(m, methodSignature[0]);
            }
            instanceMethods.add(javaMethodName + signature);
            m.end();
        }
        block15: for (Map.Entry<String, DynamicMethod> methodEntry : this.getMetaClass().getMethods().entrySet()) {
            methodName = methodEntry.getKey();
            if (!JavaNameMangler.willMethodMangleOk(methodName)) continue;
            javaMethodName = JavaNameMangler.mangleMethodName(methodName);
            methodAnnos = this.getMetaClass().getMethodAnnotations().get(methodName);
            parameterAnnos = this.getMetaClass().getParameterAnnotations().get(methodName);
            methodSignature = this.getMetaClass().getMethodSignatures().get(methodName);
            if (methodSignature == null) {
                switch (methodEntry.getValue().getArity().getValue()) {
                    case 0: {
                        signature = CodegenUtils.sig(IRubyObject.class, new Class[0]);
                        if (instanceMethods.contains(javaMethodName + signature)) continue block15;
                        m = new SkinnyMethodAdapter(cw, 137, javaMethodName, signature, null, null);
                        this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                        m.getstatic(javaPath, "rubyClass", CodegenUtils.ci(RubyClass.class));
                        m.ldc(methodName);
                        m.invokevirtual("org/jruby/RubyClass", "callMethod", CodegenUtils.sig(IRubyObject.class, String.class));
                        break;
                    }
                    default: {
                        signature = CodegenUtils.sig(IRubyObject.class, IRubyObject[].class);
                        if (instanceMethods.contains(javaMethodName + signature)) continue block15;
                        m = new SkinnyMethodAdapter(cw, 137, javaMethodName, signature, null, null);
                        this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                        m.getstatic(javaPath, "rubyClass", CodegenUtils.ci(RubyClass.class));
                        m.ldc(methodName);
                        m.aload(0);
                        m.invokevirtual("org/jruby/RubyClass", "callMethod", CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject[].class));
                    }
                }
                m.areturn();
            } else {
                params2 = new Class[methodSignature.length - 1];
                System.arraycopy(methodSignature, 1, params2, 0, params2.length);
                baseIndex = 0;
                for (Class paramType : params2) {
                    if (paramType == Double.TYPE || paramType == Long.TYPE) {
                        baseIndex += 2;
                        continue;
                    }
                    ++baseIndex;
                }
                rubyIndex = baseIndex;
                signature = CodegenUtils.sig(methodSignature[0], params2);
                if (instanceMethods.contains(javaMethodName + signature)) continue;
                m = new SkinnyMethodAdapter(cw, 137, javaMethodName, signature, null, null);
                this.generateMethodAnnotations(methodAnnos, m, parameterAnnos);
                m.getstatic(javaPath, "ruby", CodegenUtils.ci(Ruby.class));
                m.astore(rubyIndex);
                m.getstatic(javaPath, "rubyClass", CodegenUtils.ci(RubyClass.class));
                m.ldc(methodName);
                RealClassGenerator.coerceArgumentsToRuby(m, params2, rubyIndex);
                m.invokevirtual("org/jruby/RubyClass", "callMethod", CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject[].class));
                RealClassGenerator.coerceResultAndReturn(m, methodSignature[0]);
            }
            m.end();
        }
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        Throwable failure = null;
        try {
            Class<?> result2 = parentCL.defineClass(javaName, classBytes);
            this.dumpReifiedClass(classDumpDir, javaPath, classBytes);
            Method clinit = result2.getDeclaredMethod("clinit", Ruby.class, RubyClass.class);
            clinit.invoke(null, this.runtime, this);
            this.setClassAllocator(result2);
            this.reifiedClass = result2;
            return;
        }
        catch (LinkageError le) {
            failure = le;
        }
        catch (Exception e) {
            failure = e;
        }
        if (RubyInstanceConfig.REIFY_LOG_ERRORS) {
            LOG.error("failed to reify class " + this.getName() + " due to:", new Object[0]);
            LOG.error(failure);
        }
        if (this.superClass.reifiedClass != null) {
            this.reifiedClass = this.superClass.reifiedClass;
            this.allocator = this.superClass.allocator;
        }
    }

    public void setReifiedClass(Class newReifiedClass) {
        this.reifiedClass = newReifiedClass;
    }

    public Class getReifiedClass() {
        return this.reifiedClass;
    }

    public Map<String, List<Map<Class, Map<String, Object>>>> getParameterAnnotations() {
        if (this.parameterAnnotations == null) {
            return Collections.EMPTY_MAP;
        }
        return this.parameterAnnotations;
    }

    public synchronized void addParameterAnnotation(String method2, int i2, Class annoClass, Map<String, Object> value2) {
        List<Map<Class, Map<String, Object>>> paramList;
        if (this.parameterAnnotations == null) {
            this.parameterAnnotations = new Hashtable<String, List<Map<Class, Map<String, Object>>>>();
        }
        if ((paramList = this.parameterAnnotations.get(method2)) == null) {
            paramList = new ArrayList<Map<Class, Map<String, Object>>>(i2 + 1);
            this.parameterAnnotations.put(method2, paramList);
        }
        if (paramList.size() < i2 + 1) {
            for (int j = paramList.size(); j < i2 + 1; ++j) {
                paramList.add(null);
            }
        }
        if (annoClass != null && value2 != null) {
            Map<Class, Map<String, Object>> annos = paramList.get(i2);
            if (annos == null) {
                annos = new HashMap<Class, Map<String, Object>>();
                paramList.set(i2, annos);
            }
            annos.put(annoClass, value2);
        } else {
            paramList.set(i2, null);
        }
    }

    public Map<String, Map<Class, Map<String, Object>>> getMethodAnnotations() {
        if (this.methodAnnotations == null) {
            return Collections.EMPTY_MAP;
        }
        return this.methodAnnotations;
    }

    public Map<String, Map<Class, Map<String, Object>>> getFieldAnnotations() {
        if (this.fieldAnnotations == null) {
            return Collections.EMPTY_MAP;
        }
        return this.fieldAnnotations;
    }

    public synchronized void addMethodAnnotation(String methodName, Class annotation2, Map fields2) {
        Map<Class, Map<String, Object>> annos;
        if (this.methodAnnotations == null) {
            this.methodAnnotations = new Hashtable<String, Map<Class, Map<String, Object>>>();
        }
        if ((annos = this.methodAnnotations.get(methodName)) == null) {
            annos = new Hashtable<Class, Map<String, Object>>();
            this.methodAnnotations.put(methodName, annos);
        }
        annos.put(annotation2, fields2);
    }

    public synchronized void addFieldAnnotation(String fieldName, Class annotation2, Map fields2) {
        Map<Class, Map<String, Object>> annos;
        if (this.fieldAnnotations == null) {
            this.fieldAnnotations = new Hashtable<String, Map<Class, Map<String, Object>>>();
        }
        if ((annos = this.fieldAnnotations.get(fieldName)) == null) {
            annos = new Hashtable<Class, Map<String, Object>>();
            this.fieldAnnotations.put(fieldName, annos);
        }
        annos.put(annotation2, fields2);
    }

    public Map<String, Class[]> getMethodSignatures() {
        if (this.methodSignatures == null) {
            return Collections.EMPTY_MAP;
        }
        return this.methodSignatures;
    }

    public Map<String, Class> getFieldSignatures() {
        if (this.fieldSignatures == null) {
            return Collections.EMPTY_MAP;
        }
        return this.fieldSignatures;
    }

    public synchronized void addMethodSignature(String methodName, Class[] types) {
        if (this.methodSignatures == null) {
            this.methodSignatures = new Hashtable<String, Class[]>();
        }
        this.methodSignatures.put(methodName, types);
    }

    public synchronized void addFieldSignature(String fieldName, Class type2) {
        if (this.fieldSignatures == null) {
            this.fieldSignatures = new LinkedHashMap<String, Class>();
        }
        this.fieldSignatures.put(fieldName, type2);
    }

    public Map<Class, Map<String, Object>> getClassAnnotations() {
        if (this.classAnnotations == null) {
            return Collections.EMPTY_MAP;
        }
        return this.classAnnotations;
    }

    public synchronized void addClassAnnotation(Class annotation2, Map fields2) {
        if (this.classAnnotations == null) {
            this.classAnnotations = new Hashtable<Class, Map<String, Object>>();
        }
        this.classAnnotations.put(annotation2, fields2);
    }

    @Override
    public Object toJava(Class klass) {
        Class returnClass = null;
        if (klass == Class.class) {
            if (this.respondsTo("java_class")) {
                return this.callMethod("java_class").toJava(klass);
            }
            for (RubyClass current2 = this; current2 != null; current2 = current2.getSuperClass()) {
                returnClass = current2.getReifiedClass();
                if (returnClass == null) continue;
                return returnClass;
            }
        }
        if (klass.isAssignableFrom(RubyClass.class)) {
            return this;
        }
        return super.toJava(klass);
    }

    public void smartDump(MarshalStream stream, IRubyObject target) throws IOException {
        MarshalTuple tuple = this.cachedDumpMarshal;
        if (tuple.generation != this.generation) {
            DynamicMethod method2 = this.searchMethod("respond_to?");
            tuple = !method2.equals(this.runtime.getRespondToMethod()) && !method2.isUndefined() ? (this.cachedDumpMarshal = new MarshalTuple(null, MarshalType.DEFAULT_SLOW, this.generation)) : (!(method2 = this.searchMethod("marshal_dump")).isUndefined() ? (this.cachedDumpMarshal = new MarshalTuple(method2, MarshalType.NEW_USER, this.generation)) : (!(method2 = this.searchMethod("_dump")).isUndefined() ? (this.cachedDumpMarshal = new MarshalTuple(method2, MarshalType.OLD_USER, this.generation)) : (this.cachedDumpMarshal = new MarshalTuple(null, MarshalType.DEFAULT, this.generation))));
        }
        tuple.dump(stream, target);
    }

    public IRubyObject smartLoadNewUser(IRubyObject target, IRubyObject data2) {
        ThreadContext context = this.runtime.getCurrentContext();
        CacheEntry cache = this.cachedLoad;
        if (cache.token == this.generation) {
            cache.method.call(context, target, (RubyModule)this, "marshal_load", data2);
            return target;
        }
        DynamicMethod method2 = this.searchMethod("respond_to?");
        if (!method2.equals(this.runtime.getRespondToMethod()) && !method2.isUndefined()) {
            if (method2.call(context, target, (RubyModule)this, "respond_to?", this.runtime.newSymbol("marshal_load")).isTrue()) {
                target.callMethod(context, "marshal_load", data2);
                return target;
            }
            throw this.runtime.newTypeError("class " + this.getName() + " needs to have method `marshal_load'");
        }
        cache = this.searchWithCache("marshal_load");
        if (!cache.method.isUndefined()) {
            this.cachedLoad = cache;
            cache.method.call(context, target, (RubyModule)this, "marshal_load", data2);
            return target;
        }
        target.callMethod(context, "marshal_load", data2);
        return target;
    }

    public IRubyObject smartLoadOldUser(IRubyObject data2) {
        ThreadContext context = this.runtime.getCurrentContext();
        CacheEntry cache = this.getSingletonClass().cachedLoad;
        if (cache.token == this.getSingletonClass().generation) {
            return cache.method.call(context, (IRubyObject)this, (RubyModule)this.getSingletonClass(), "_load", data2);
        }
        DynamicMethod method2 = this.getSingletonClass().searchMethod("respond_to?");
        if (!method2.equals(this.runtime.getRespondToMethod()) && !method2.isUndefined()) {
            if (method2.call(context, (IRubyObject)this, (RubyModule)this.getSingletonClass(), "respond_to?", this.runtime.newSymbol("_load")).isTrue()) {
                return this.callMethod(context, "_load", data2);
            }
            throw this.runtime.newTypeError("class " + this.getName() + " needs to have method `_load'");
        }
        cache = this.getSingletonClass().searchWithCache("_load");
        if (!cache.method.isUndefined()) {
            this.getSingletonClass().cachedLoad = cache;
            return cache.method.call(context, (IRubyObject)this, (RubyModule)this.getSingletonClass(), "_load", data2);
        }
        throw this.runtime.newTypeError("class " + this.getName() + " needs to have method `_load'");
    }

    private static class MarshalTuple {
        public static final MarshalTuple NULL_TUPLE = new MarshalTuple(null, null, 0);
        public final DynamicMethod method;
        public final MarshalType type;
        public final int generation;

        public MarshalTuple(DynamicMethod method2, MarshalType type2, int generation) {
            this.method = method2;
            this.type = type2;
            this.generation = generation;
        }

        public void dump(MarshalStream stream, IRubyObject object) throws IOException {
            switch (this.type) {
                case DEFAULT: {
                    stream.writeDirectly(object);
                    return;
                }
                case NEW_USER: {
                    stream.userNewMarshal(object, this.method);
                    return;
                }
                case OLD_USER: {
                    stream.userMarshal(object, this.method);
                    return;
                }
                case DEFAULT_SLOW: {
                    if (object.respondsTo("marshal_dump")) {
                        stream.userNewMarshal(object);
                    } else if (object.respondsTo("_dump")) {
                        stream.userMarshal(object);
                    } else {
                        stream.writeDirectly(object);
                    }
                    return;
                }
            }
        }
    }

    private static enum MarshalType {
        DEFAULT,
        NEW_USER,
        OLD_USER,
        DEFAULT_SLOW,
        NEW_USER_SLOW,
        USER_SLOW;

    }
}

