/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.thread;

import java.util.concurrent.locks.ReentrantLock;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Mutex"})
public class Mutex
extends RubyObject {
    ReentrantLock lock = new ReentrantLock();

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static Mutex newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Mutex result2 = new Mutex(context.runtime, (RubyClass)recv2);
        result2.callInit(context, args2, block);
        return result2;
    }

    public Mutex(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    public static void setup(Ruby runtime) {
        RubyClass cMutex = runtime.defineClass("Mutex", runtime.getObject(), new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new Mutex(runtime, klass);
            }
        });
        cMutex.setReifiedClass(Mutex.class);
        cMutex.defineAnnotatedMethods(Mutex.class);
    }

    @JRubyMethod(name={"locked?"})
    public synchronized RubyBoolean locked_p(ThreadContext context) {
        return context.runtime.newBoolean(this.lock.isLocked());
    }

    @JRubyMethod
    public RubyBoolean try_lock(ThreadContext context) {
        if (this.lock.isHeldByCurrentThread()) {
            return context.runtime.getFalse();
        }
        return context.runtime.newBoolean(context.getThread().tryLock(this.lock));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject lock(ThreadContext context) {
        try {
            context.getThread().enterSleep();
            try {
                this.checkRelocking(context);
                context.getThread().lockInterruptibly(this.lock);
            }
            catch (InterruptedException ex) {
                context.pollThreadEvents();
                throw context.runtime.newConcurrencyError("interrupted waiting for mutex: " + ex.getMessage());
            }
        }
        finally {
            context.getThread().exitSleep();
        }
        return this;
    }

    @JRubyMethod
    public synchronized IRubyObject unlock(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (!this.lock.isLocked()) {
            throw runtime.newThreadError("Mutex is not locked");
        }
        if (!this.lock.isHeldByCurrentThread()) {
            throw runtime.newThreadError("Mutex is not owned by calling thread");
        }
        boolean hasQueued = this.lock.hasQueuedThreads();
        context.getThread().unlock(this.lock);
        return hasQueued ? context.nil : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject sleep(ThreadContext context) {
        long beg = System.currentTimeMillis();
        try {
            this.unlock(context);
            context.getThread().sleep(-1L);
        }
        catch (InterruptedException ex) {
        }
        finally {
            this.lock(context);
        }
        return context.runtime.newFixnum((System.currentTimeMillis() - beg) / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject sleep(ThreadContext context, IRubyObject timeout2) {
        long beg = System.currentTimeMillis();
        try {
            this.unlock(context);
            context.getThread().sleep((long)(timeout2.convertToFloat().getDoubleValue() * 1000.0));
        }
        catch (InterruptedException ex) {
        }
        finally {
            this.lock(context);
        }
        return context.runtime.newFixnum((System.currentTimeMillis() - beg) / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject synchronize(ThreadContext context, Block block) {
        this.lock(context);
        try {
            IRubyObject iRubyObject = block.yield(context, null);
            return iRubyObject;
        }
        finally {
            this.unlock(context);
        }
    }

    private void checkRelocking(ThreadContext context) {
        if (this.lock.isHeldByCurrentThread()) {
            throw context.runtime.newThreadError("Mutex relocking by same thread");
        }
    }
}

