/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.util.ArrayList;
import java.util.List;
import org.jruby.RubyModule;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.IRStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class IREvalScript
extends IRClosure {
    private static final Logger LOG = LoggerFactory.getLogger("IREvalScript");
    private IRScope nearestNonEvalScope;
    private int nearestNonEvalScopeDepth;
    private List<IRClosure> beginBlocks;
    private List<IRClosure> endBlocks;

    public IREvalScript(IRManager manager, IRScope lexicalParent, String fileName, int lineNumber, StaticScope staticScope) {
        super(manager, lexicalParent, fileName, lineNumber, staticScope, "EVAL_");
        int n = 0;
        IRScope s2 = lexicalParent;
        while (s2 instanceof IREvalScript) {
            ++n;
            s2 = s2.getLexicalParent();
        }
        this.nearestNonEvalScope = s2;
        this.nearestNonEvalScopeDepth = n;
        this.nearestNonEvalScope.initEvalScopeVariableAllocator(false);
    }

    @Override
    public Label getNewLabel() {
        return this.getNewLabel("EV" + this.closureId + "_LBL");
    }

    @Override
    public String getScopeName() {
        return "EvalScript";
    }

    @Override
    public Operand[] getBlockArgs() {
        return new Operand[0];
    }

    @Override
    public void recordBeginBlock(IRClosure beginBlockClosure) {
        if (this.beginBlocks == null) {
            this.beginBlocks = new ArrayList<IRClosure>();
        }
        this.beginBlocks.add(beginBlockClosure);
    }

    @Override
    public void recordEndBlock(IRClosure endBlockClosure) {
        if (this.endBlocks == null) {
            this.endBlocks = new ArrayList<IRClosure>();
        }
        this.endBlocks.add(endBlockClosure);
    }

    public List<IRClosure> getBeginBlocks() {
        return this.beginBlocks;
    }

    public List<IRClosure> getEndBlocks() {
        return this.endBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, DynamicScope evalScope, Block block, String backtraceName) {
        if (IRRuntimeHelpers.isDebug()) {
            LOG.info("CFG:\n" + this.cfg(), new Object[0]);
        }
        try {
            context.pushScope(evalScope);
            ((IRStaticScope)this.getStaticScope()).setIRScope(this);
            evalScope.growIfNeeded();
            IRubyObject iRubyObject = Interpreter.INTERPRET_EVAL(context, self2, this, clazz, new IRubyObject[0], backtraceName, block, null);
            return iRubyObject;
        }
        finally {
            context.popScope();
        }
    }

    @Override
    public LocalVariable findExistingLocalVariable(String name2, int scopeDepth) {
        LocalVariable lvar = this.nearestNonEvalScope.evalScopeVars.getVariable(name2);
        if (lvar != null || scopeDepth == 0) {
            return lvar;
        }
        return this.nearestNonEvalScope.findExistingLocalVariable(name2, scopeDepth - this.nearestNonEvalScopeDepth - 1);
    }

    @Override
    public LocalVariable getNewLocalVariable(String name2, int depth) {
        assert (depth == this.nearestNonEvalScopeDepth) : "Local variable depth in IREvalScript:getNewLocalVariable must be " + this.nearestNonEvalScopeDepth + ".  Got " + depth;
        ClosureLocalVariable lvar = new ClosureLocalVariable(this, name2, 0, this.nearestNonEvalScope.evalScopeVars.nextSlot);
        this.nearestNonEvalScope.evalScopeVars.putVariable(name2, lvar);
        return lvar;
    }

    @Override
    public LocalVariable getNewFlipStateVariable() {
        return this.getLocalVariable("%flip_" + this.allocateNextPrefixedName("%flip"), 0);
    }

    @Override
    public int getUsedVariablesCount() {
        return 1 + this.nearestNonEvalScope.evalScopeVars.nextSlot + this.getPrefixCountSize("%flip");
    }

    @Override
    public boolean isScriptScope() {
        return true;
    }

    @Override
    public boolean isTopLocalVariableScope() {
        return false;
    }

    @Override
    public boolean isFlipScope() {
        return true;
    }
}

