/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.opto;

import java.lang.invoke.SwitchPoint;
import java.util.List;
import org.jruby.RubyModule;
import org.jruby.runtime.opto.GenerationInvalidator;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.runtime.opto.SwitchPointInvalidator;

public class GenerationAndSwitchPointInvalidator
implements Invalidator {
    private final GenerationInvalidator generationInvalidator;
    private final SwitchPointInvalidator switchPointInvalidator;

    public GenerationAndSwitchPointInvalidator(RubyModule module) {
        this.generationInvalidator = new GenerationInvalidator(module);
        this.switchPointInvalidator = new SwitchPointInvalidator();
    }

    @Override
    public void invalidate() {
        this.generationInvalidator.invalidate();
        this.switchPointInvalidator.invalidate();
    }

    @Override
    public void invalidateAll(List<Invalidator> invalidators) {
        SwitchPoint[] switchPoints = new SwitchPoint[invalidators.size()];
        for (int i2 = 0; i2 < invalidators.size(); ++i2) {
            Invalidator invalidator = invalidators.get(i2);
            assert (invalidator instanceof GenerationAndSwitchPointInvalidator);
            GenerationAndSwitchPointInvalidator gsInvalidator = (GenerationAndSwitchPointInvalidator)invalidator;
            gsInvalidator.generationInvalidator.invalidate();
            switchPoints[i2] = gsInvalidator.switchPointInvalidator.replaceSwitchPoint();
        }
        SwitchPoint.invalidateAll(switchPoints);
    }

    @Override
    public Object getData() {
        return this.switchPointInvalidator.getData();
    }
}

