/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.InputStream;
import org.jruby.util.JarResource;
import org.jruby.util.ResourceException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ModeFlags;

class JarDirectoryResource
extends JarResource {
    private final String path;
    private final String[] contents;

    JarDirectoryResource(String jarPath, boolean rootSlashPrefix, String path2, String[] contents) {
        super(jarPath, rootSlashPrefix);
        this.path = path2;
        this.contents = contents;
    }

    @Override
    public String entryName() {
        return this.path;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public String[] list() {
        return this.contents;
    }

    public boolean isRoot() {
        return "/".equals(this.path);
    }

    @Override
    InputStream openInputStream() throws IOException {
        throw new ResourceException.FileIsDirectory(this.path);
    }

    @Override
    public ChannelDescriptor openDescriptor(ModeFlags flags, int perm) throws ResourceException {
        throw new ResourceException.PermissionDenied(this.absolutePath());
    }
}

