/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import org.jruby.util.cli.Options;
import org.jruby.util.collections.ClassValueCalculator;
import org.jruby.util.collections.Java7ClassValue;
import org.jruby.util.collections.MapBasedClassValue;

public abstract class ClassValue<T> {
    protected final ClassValueCalculator<T> calculator;
    private static final boolean JAVA7_CLASS_VALUE;

    public ClassValue(ClassValueCalculator<T> calculator) {
        this.calculator = calculator;
    }

    public abstract T get(Class var1);

    public static <T> ClassValue<T> newInstance(ClassValueCalculator<T> calculator) {
        if (JAVA7_CLASS_VALUE) {
            return ClassValue.newJava7Instance(calculator);
        }
        return new MapBasedClassValue<T>(calculator);
    }

    private static <T> ClassValue<T> newJava7Instance(ClassValueCalculator<T> calculator) {
        return new Java7ClassValue<T>(calculator);
    }

    static {
        boolean java7ClassValue = false;
        if (Options.INVOKEDYNAMIC_CLASS_VALUES.load().booleanValue()) {
            try {
                Class.forName("java.lang.ClassValue");
                Class.forName("org.jruby.util.collections.Java7ClassValue");
                java7ClassValue = true;
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        JAVA7_CLASS_VALUE = java7ClassValue;
    }
}

