/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import java.util.Map;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.DepthCloneable;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Splat
extends Operand
implements DepthCloneable {
    private final Operand array;

    public Splat(Operand array) {
        this.array = array;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.SPLAT;
    }

    public String toString() {
        return "*(unsplat)" + this.array;
    }

    @Override
    public boolean hasKnownValue() {
        return false;
    }

    public Operand getArray() {
        return this.array;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        Operand newArray = this.array.getSimplifiedOperand(valueMap, force);
        return newArray == this.array ? this : new Splat(newArray);
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        this.array.addUsedVariables(l);
    }

    @Override
    public Operand cloneForDepth(int n) {
        return this.array instanceof LocalVariable ? new Splat(((LocalVariable)this.array).cloneForDepth(n)) : this;
    }

    @Override
    public Operand cloneForInlining(CloneInfo ii) {
        return this.hasKnownValue() ? this : new Splat(this.array.cloneForInlining(ii));
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        return this.array.retrieve(context, self2, currScope, currDynScope, temp);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getArray());
    }

    public static Splat decode(IRReaderDecoder d) {
        return new Splat(d.decodeOperand());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Splat(this);
    }
}

