/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyHashMapDecorator
implements Map<String, Object> {
    private final RubyHash rubyHash;
    private final Ruby rubyRuntime;

    public RubyHashMapDecorator(RubyHash rubyHash) {
        this.rubyRuntime = rubyHash.getRuntime();
        this.rubyHash = rubyHash;
    }

    @Override
    public int size() {
        return this.rubyHash.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rubyHash.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        RubySymbol symbol = this.rubyHash.getRuntime().getSymbolTable().getSymbol((String)key);
        return this.rubyHash.containsKey((Object)symbol);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.rubyHash.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        RubySymbol symbol = this.rubyHash.getRuntime().getSymbolTable().getSymbol((String)key);
        Object value = this.rubyHash.get((Object)symbol);
        return this.convertRubyValue(value);
    }

    @Override
    public Object put(String key, Object value) {
        Object oldValue = this.get(key);
        RubySymbol symbol = this.rubyHash.getRuntime().getSymbolTable().getSymbol(key);
        this.rubyHash.put((Object)symbol, (Object)this.convertJavaValue(value));
        return oldValue;
    }

    @Override
    public Object remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        Object oldValue = this.get(key);
        RubySymbol symbol = this.rubyHash.getRuntime().getSymbolTable().getSymbol((String)key);
        this.rubyHash.remove((Object)symbol);
        return this.convertRubyValue(oldValue);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.rubyHash.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.createJavaMap().keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.createJavaMap().values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.createJavaMap().entrySet();
    }

    private Map<String, Object> createJavaMap() {
        HashMap<String, Object> copy = new HashMap<String, Object>();
        Set rubyEntrySet = this.rubyHash.entrySet();
        for (Map.Entry o : rubyEntrySet) {
            String key;
            Object rubyKey = o.getKey();
            Object rubyValue = o.getValue();
            if (rubyKey instanceof RubySymbol) {
                key = ((RubySymbol)rubyKey).asJavaString();
            } else if (rubyKey instanceof RubyString) {
                key = ((RubyString)rubyKey).asJavaString();
            } else if (rubyKey instanceof String) {
                key = (String)rubyKey;
            } else {
                throw new IllegalStateException("Did not expect key " + rubyKey + " of type " + rubyKey.getClass());
            }
            Object value = this.convertRubyValue(rubyValue);
            copy.put(key, value);
        }
        return copy;
    }

    private Object convertRubyValue(Object rubyValue) {
        if (rubyValue == null) {
            return null;
        }
        if (rubyValue instanceof IRubyObject) {
            return JavaEmbedUtils.rubyToJava((IRubyObject)((IRubyObject)rubyValue));
        }
        return rubyValue;
    }

    private IRubyObject convertJavaValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String && ((String)value).startsWith(":")) {
            return this.rubyHash.getRuntime().getSymbolTable().getSymbol(((String)value).substring(1));
        }
        return JavaEmbedUtils.javaToRuby((Ruby)this.rubyHash.getRuntime(), (Object)value);
    }

    RubyHash getRubyHash() {
        return this.rubyHash;
    }
}

