/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.util.ArrayList;
import java.util.List;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyObjectWrapper {
    protected Ruby runtime;
    protected IRubyObject rubyNode;

    public RubyObjectWrapper(IRubyObject rubyNode) {
        this.rubyNode = rubyNode;
        this.runtime = rubyNode.getRuntime();
    }

    public IRubyObject getRubyObject() {
        return this.rubyNode;
    }

    protected Ruby getRuntime() {
        return this.runtime;
    }

    protected String getString(String propertyName, Object ... args) {
        IRubyObject result = this.getRubyProperty(propertyName, args);
        if (result instanceof RubyNil) {
            return null;
        }
        if (result instanceof RubySymbol) {
            return ((RubySymbol)result).asJavaString();
        }
        return ((RubyString)result).asJavaString();
    }

    protected void setString(String propertyName, String value) {
        if (value == null) {
            this.setRubyProperty(propertyName, this.runtime.getNil());
        } else {
            this.setRubyProperty(propertyName, (IRubyObject)this.runtime.newString(value));
        }
    }

    protected String getSymbol(String propertyName, Object ... args) {
        IRubyObject result = this.getRubyProperty(propertyName, args);
        if (result instanceof RubyNil) {
            return null;
        }
        return ((RubySymbol)result).asJavaString();
    }

    protected void setSymbol(String propertyName, String value) {
        if (value == null) {
            this.setRubyProperty(propertyName, this.runtime.getNil());
        } else {
            this.setRubyProperty(propertyName, (IRubyObject)this.runtime.newSymbol(value));
        }
    }

    protected boolean getBoolean(String propertyName, Object ... args) {
        IRubyObject result = this.getRubyProperty(propertyName, args);
        if (result instanceof RubyNil) {
            return false;
        }
        return ((RubyBoolean)result).isTrue();
    }

    protected int getInt(String propertyName, Object ... args) {
        IRubyObject result = this.getRubyProperty(propertyName, args);
        if (result instanceof RubyNil) {
            return 0;
        }
        return (int)((RubyNumeric)result).getLongValue();
    }

    protected <T> List<T> getList(String propertyName, Class<T> elementClass, Object ... args) {
        IRubyObject result = this.getRubyProperty(propertyName, args);
        if (result instanceof RubyNil) {
            return null;
        }
        ArrayList<T> ret = new ArrayList<T>();
        RubyArray array = (RubyArray)result;
        for (int i = 0; i < array.size(); ++i) {
            ret.add(RubyUtils.rubyToJava(this.runtime, array.at((IRubyObject)RubyFixnum.newFixnum((Ruby)this.runtime, (long)i)), elementClass));
        }
        return ret;
    }

    protected IRubyObject getRubyProperty(String propertyName, Object ... args) {
        ThreadContext threadContext = this.runtime.getThreadService().getCurrentContext();
        IRubyObject result = null;
        if (propertyName.startsWith("@")) {
            if (args != null) {
                throw new IllegalArgumentException("No args allowed for direct field access");
            }
            result = this.rubyNode.getInstanceVariables().getInstanceVariable(propertyName);
        } else if (args == null) {
            result = this.rubyNode.callMethod(threadContext, propertyName);
        } else {
            IRubyObject[] rubyArgs = new IRubyObject[args.length];
            for (int i = 0; i < args.length; ++i) {
                rubyArgs[i] = args[i] instanceof RubyObjectWrapper ? ((RubyObjectWrapper)args[i]).getRubyObject() : JavaEmbedUtils.javaToRuby((Ruby)this.runtime, (Object)args[i]);
            }
            result = this.rubyNode.callMethod(threadContext, propertyName, rubyArgs);
        }
        return result;
    }

    protected void setRubyProperty(String propertyName, IRubyObject arg) {
        ThreadContext threadContext = this.runtime.getThreadService().getCurrentContext();
        Object result = null;
        if (propertyName.startsWith("@")) {
            this.rubyNode.getInstanceVariables().setInstanceVariable(propertyName, arg);
        } else if (arg == null) {
            this.rubyNode.callMethod(threadContext, propertyName + "=", this.runtime.getNil());
        } else {
            this.rubyNode.callMethod(threadContext, propertyName + "=", arg);
        }
    }

    protected Object getProperty(String propertyName, Object ... args) {
        return this.toJava(this.getRubyProperty(propertyName, args));
    }

    protected Object toJava(IRubyObject rubyObject) {
        return JavaEmbedUtils.rubyToJava((IRubyObject)rubyObject);
    }

    protected <T> T toJava(IRubyObject rubyObject, Class<T> targetClass) {
        return (T)JavaEmbedUtils.rubyToJava((Ruby)this.runtime, (IRubyObject)rubyObject, targetClass);
    }
}

