/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Arrays;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerable;
import org.jruby.RubyException;
import org.jruby.RubyFloat;
import org.jruby.RubyGenerator;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyYielder;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.cli.Options;

@JRubyModule(name={"Enumerable::Enumerator"}, include={"Enumerable"})
public class RubyEnumerator
extends RubyObject {
    private IRubyObject object;
    private String method;
    private IRubyObject[] methodArgs;
    private IRubyObject size;
    private SizeFn sizeFn;
    private IRubyObject feedValue;
    private static ObjectAllocator ENUMERATOR_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyEnumerator(runtime, klass);
        }
    };
    private volatile Nexter nexter = null;

    public static void defineEnumerator(Ruby runtime) {
        RubyModule enm = runtime.getClassFromPath("Enumerable");
        RubyClass enmr = runtime.defineClass("Enumerator", runtime.getObject(), ENUMERATOR_ALLOCATOR);
        enmr.includeModule(enm);
        enmr.defineAnnotatedMethods(RubyEnumerator.class);
        runtime.setEnumerator(enmr);
        RubyGenerator.createGeneratorClass(runtime);
        RubyYielder.createYielderClass(runtime);
    }

    private RubyEnumerator(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
        this.object = runtime.getNil();
        this.initialize(runtime, runtime.getNil(), (IRubyObject)RubyString.newEmptyString(runtime), IRubyObject.NULL_ARRAY);
    }

    private RubyEnumerator(Ruby runtime, RubyClass type2, IRubyObject object, IRubyObject method, IRubyObject[] args2, IRubyObject size2) {
        super(runtime, type2);
        this.initialize20(runtime, object, method, args2, size2, null);
    }

    private RubyEnumerator(Ruby runtime, RubyClass type2, IRubyObject object, IRubyObject method, IRubyObject[] args2, SizeFn sizeFn) {
        super(runtime, type2);
        this.initialize20(runtime, object, method, args2, null, sizeFn);
    }

    private RubyEnumerator(Ruby runtime, RubyClass type2, IRubyObject object, IRubyObject method, IRubyObject[] args2) {
        super(runtime, type2);
        this.initialize(runtime, object, method, args2);
    }

    public static IRubyObject enumeratorizeWithSize(ThreadContext context, IRubyObject object, String method, IRubyObject[] args2, SizeFn sizeFn) {
        Ruby runtime = context.runtime;
        return new RubyEnumerator(runtime, runtime.getEnumerator(), object, (IRubyObject)runtime.fastNewSymbol(method), args2, sizeFn);
    }

    public static IRubyObject enumeratorizeWithSize(ThreadContext context, IRubyObject object, String method, SizeFn sizeFn) {
        return RubyEnumerator.enumeratorizeWithSize(context, object, method, NULL_ARRAY, sizeFn);
    }

    public static IRubyObject enumeratorizeWithSize(ThreadContext context, IRubyObject object, String method, IRubyObject arg2, IRubyObject size2) {
        Ruby runtime = context.runtime;
        return new RubyEnumerator(runtime, runtime.getEnumerator(), object, (IRubyObject)runtime.fastNewSymbol(method), new IRubyObject[]{arg2}, size2);
    }

    public static IRubyObject enumeratorize(Ruby runtime, IRubyObject object, String method) {
        return new RubyEnumerator(runtime, runtime.getEnumerator(), object, runtime.fastNewSymbol(method), IRubyObject.NULL_ARRAY);
    }

    public static IRubyObject enumeratorize(Ruby runtime, IRubyObject object, String method, IRubyObject arg2) {
        return new RubyEnumerator(runtime, runtime.getEnumerator(), object, runtime.fastNewSymbol(method), new IRubyObject[]{arg2});
    }

    public static IRubyObject enumeratorize(Ruby runtime, IRubyObject object, String method, IRubyObject[] args2) {
        return new RubyEnumerator(runtime, runtime.getEnumerator(), object, runtime.fastNewSymbol(method), args2);
    }

    public static IRubyObject enumeratorize(Ruby runtime, RubyClass type2, IRubyObject object, String method) {
        return new RubyEnumerator(runtime, type2, object, runtime.fastNewSymbol(method), IRubyObject.NULL_ARRAY);
    }

    public static IRubyObject enumeratorize(Ruby runtime, RubyClass type2, IRubyObject object, String method, IRubyObject arg2) {
        return new RubyEnumerator(runtime, type2, object, runtime.fastNewSymbol(method), new IRubyObject[]{arg2});
    }

    public static IRubyObject enumeratorize(Ruby runtime, RubyClass type2, IRubyObject object, String method, IRubyObject[] args2) {
        return new RubyEnumerator(runtime, type2, object, runtime.fastNewSymbol(method), args2);
    }

    @Override
    public IRubyObject initialize(ThreadContext context) {
        return this.initialize20(context, Block.NULL_BLOCK);
    }

    public IRubyObject initialize19(ThreadContext context, Block block) {
        return this.initialize20(context, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize20(ThreadContext context, Block block) {
        return this.initialize20(context, NULL_ARRAY, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize20(ThreadContext context, IRubyObject object, Block block) {
        return this.initialize20(context, new IRubyObject[]{object}, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, rest=true)
    public IRubyObject initialize20(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject object;
        Ruby runtime = context.runtime;
        IRubyObject method = runtime.newSymbol("each");
        IRubyObject size2 = null;
        if (block.isGiven()) {
            Arity.checkArgumentCount(runtime, args2, 0, 1);
            if (args2.length > 0) {
                size2 = args2[0];
                args2 = Arrays.copyOfRange(args2, 1, args2.length);
                if (!(size2.isNil() || size2.respondsTo("call") || runtime.getFloat().isInstance(size2) && ((RubyFloat)size2).getDoubleValue() == Double.POSITIVE_INFINITY || size2 instanceof RubyInteger)) {
                    throw runtime.newTypeError(size2, runtime.getInteger());
                }
            }
            object = runtime.getGenerator().newInstance(context, IRubyObject.NULL_ARRAY, block);
        } else {
            Arity.checkArgumentCount(runtime, args2, 1, -1);
            object = args2[0];
            args2 = Arrays.copyOfRange(args2, 1, args2.length);
            if (args2.length > 0) {
                method = args2[0];
                args2 = Arrays.copyOfRange(args2, 1, args2.length);
            }
        }
        return this.initialize20(runtime, object, method, args2, size2, null);
    }

    public IRubyObject initialize(ThreadContext context, IRubyObject object, IRubyObject method) {
        return this.initialize20(context, object, method, Block.NULL_BLOCK);
    }

    public IRubyObject initialize19(ThreadContext context, IRubyObject object, IRubyObject method, Block block) {
        return this.initialize20(context, object, method, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize20(ThreadContext context, IRubyObject object, IRubyObject method, Block block) {
        if (block.isGiven()) {
            throw context.runtime.newArgumentError(2, 1);
        }
        return this.initialize(context.runtime, object, method, NULL_ARRAY);
    }

    public IRubyObject initialize(ThreadContext context, IRubyObject object, IRubyObject method, IRubyObject methodArg) {
        return this.initialize20(context, object, method, methodArg, Block.NULL_BLOCK);
    }

    public IRubyObject initialize19(ThreadContext context, IRubyObject object, IRubyObject method, IRubyObject methodArg, Block block) {
        return this.initialize20(context, object, method, methodArg, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize20(ThreadContext context, IRubyObject object, IRubyObject method, IRubyObject methodArg, Block block) {
        if (block.isGiven()) {
            throw context.runtime.newArgumentError(3, 1);
        }
        return this.initialize(context.runtime, object, method, new IRubyObject[]{methodArg});
    }

    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        return this.initialize20(context, args2, Block.NULL_BLOCK);
    }

    public IRubyObject initialize19(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.initialize20(context, args2, block);
    }

    private IRubyObject initialize(Ruby runtime, IRubyObject object, IRubyObject method, IRubyObject[] methodArgs) {
        return this.initialize20(runtime, object, method, methodArgs, null, null);
    }

    private IRubyObject initialize20(Ruby runtime, IRubyObject object, IRubyObject method, IRubyObject[] methodArgs, IRubyObject size2, SizeFn sizeFn) {
        this.object = object;
        this.method = method.asJavaString();
        this.methodArgs = methodArgs;
        this.size = size2;
        this.sizeFn = sizeFn;
        this.feedValue = runtime.getNil();
        this.setInstanceVariable("@__object__", object);
        this.setInstanceVariable("@__method__", method);
        this.setInstanceVariable("@__args__", RubyArray.newArrayNoCopyLight(runtime, methodArgs));
        return this;
    }

    @Override
    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        RubyEnumerator copy = (RubyEnumerator)super.dup();
        copy.object = this.object;
        copy.method = this.method;
        copy.methodArgs = this.methodArgs;
        copy.size = this.size;
        copy.sizeFn = this.sizeFn;
        copy.feedValue = this.getRuntime().getNil();
        return copy;
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return this;
        }
        return this.object.callMethod(context, this.method, this.methodArgs, block);
    }

    @JRubyMethod(rest=true)
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        if (args2.length == 0) {
            return this.each(context, block);
        }
        IRubyObject[] newArgs = new IRubyObject[this.methodArgs.length + args2.length];
        System.arraycopy(this.methodArgs, 0, newArgs, 0, this.methodArgs.length);
        System.arraycopy(args2, 0, newArgs, this.methodArgs.length, args2.length);
        return new RubyEnumerator(context.runtime, this.getType(), this.object, context.runtime.newSymbol("each"), newArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect19(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (runtime.isInspecting(this)) {
            return this.inspect(context, true);
        }
        try {
            runtime.registerInspecting(this);
            IRubyObject iRubyObject = this.inspect(context, false);
            return iRubyObject;
        }
        finally {
            runtime.unregisterInspecting(this);
        }
    }

    private IRubyObject inspect(ThreadContext context, boolean recurse) {
        Ruby runtime = context.runtime;
        ByteList bytes2 = new ByteList();
        bytes2.append((byte)35).append((byte)60);
        bytes2.append(this.getMetaClass().getName().getBytes());
        bytes2.append((byte)58).append((byte)32);
        if (recurse) {
            bytes2.append("...>".getBytes());
            return RubyString.newStringNoCopy(runtime, bytes2).taint(context);
        }
        boolean tainted = this.isTaint();
        bytes2.append(RubyObject.inspect(context, this.object).getByteList());
        bytes2.append((byte)58);
        bytes2.append(this.method.getBytes());
        if (this.methodArgs.length > 0) {
            bytes2.append((byte)40);
            for (int i2 = 0; i2 < this.methodArgs.length; ++i2) {
                bytes2.append(RubyObject.inspect(context, this.methodArgs[i2]).getByteList());
                if (i2 < this.methodArgs.length - 1) {
                    bytes2.append((byte)44).append((byte)32);
                } else {
                    bytes2.append((byte)41);
                }
                if (!this.methodArgs[i2].isTaint()) continue;
                tainted = true;
            }
        }
        bytes2.append((byte)62);
        RubyString result2 = RubyString.newStringNoCopy(runtime, bytes2);
        if (tainted) {
            result2.setTaint(true);
        }
        return result2;
    }

    protected static IRubyObject newEnumerator(ThreadContext context, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        return new RubyEnumerator(runtime, runtime.getEnumerator(), arg2, runtime.newSymbol("each"), IRubyObject.NULL_ARRAY);
    }

    protected static IRubyObject newEnumerator(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        return new RubyEnumerator(runtime, runtime.getEnumerator(), arg1, arg2, IRubyObject.NULL_ARRAY);
    }

    protected static IRubyObject newEnumerator(ThreadContext context, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        Ruby runtime = context.runtime;
        return new RubyEnumerator(runtime, runtime.getEnumerator(), arg1, arg2, new IRubyObject[]{arg3});
    }

    @JRubyMethod(required=1)
    public IRubyObject each_with_object(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_objectCommon19(context, this, block, arg2) : RubyEnumerator.enumeratorizeWithSize(context, (IRubyObject)this, "each_with_object", new IRubyObject[]{arg2}, this.enumSizeFn(context));
    }

    @JRubyMethod
    public IRubyObject with_object(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_objectCommon19(context, this, block, arg2) : RubyEnumerator.enumeratorizeWithSize(context, (IRubyObject)this, "with_object", new IRubyObject[]{arg2}, this.enumSizeFn(context));
    }

    @JRubyMethod(rest=true)
    public IRubyObject each_entry(ThreadContext context, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_entryCommon(context, this, args2, block) : RubyEnumerator.enumeratorize(context.runtime, this.getType(), (IRubyObject)this, "each_entry", args2);
    }

    @JRubyMethod(name={"each_slice"})
    public IRubyObject each_slice19(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_slice(context, this, arg2, block) : RubyEnumerator.enumeratorize(context.runtime, this.getType(), (IRubyObject)this, "each_slice", arg2);
    }

    @JRubyMethod(name={"each_cons"})
    public IRubyObject each_cons19(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_cons(context, this, arg2, block) : RubyEnumerator.enumeratorize(context.runtime, this.getType(), (IRubyObject)this, "each_cons", arg2);
    }

    @JRubyMethod
    public IRubyObject size(ThreadContext context) {
        if (this.sizeFn != null) {
            return this.sizeFn.size(this.methodArgs);
        }
        if (this.size != null) {
            if (this.size.respondsTo("call")) {
                return this.size.callMethod(context, "call");
            }
            return this.size;
        }
        return context.nil;
    }

    private SizeFn enumSizeFn(final ThreadContext context) {
        final RubyEnumerator self2 = this;
        return new SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                return self2.size(context);
            }
        };
    }

    private IRubyObject with_index_common(ThreadContext context, Block block, String rubyMethodName, IRubyObject arg2) {
        int index2;
        Ruby runtime = context.runtime;
        int n = index2 = arg2.isNil() ? 0 : RubyNumeric.num2int(arg2);
        if (!block.isGiven()) {
            return arg2.isNil() ? RubyEnumerator.enumeratorizeWithSize(context, this, rubyMethodName, this.enumSizeFn(context)) : RubyEnumerator.enumeratorizeWithSize(context, (IRubyObject)this, rubyMethodName, new IRubyObject[]{runtime.newFixnum(index2)}, this.enumSizeFn(context));
        }
        return RubyEnumerable.callEach(runtime, context, this, new RubyEnumerable.EachWithIndex(block, index2));
    }

    @JRubyMethod
    public IRubyObject each_with_index(ThreadContext context, Block block) {
        return this.with_index_common(context, block, "each_with_index", context.nil);
    }

    public IRubyObject with_index(ThreadContext context, Block block) {
        return this.with_index19(context, block);
    }

    @JRubyMethod(name={"with_index"})
    public IRubyObject with_index19(ThreadContext context, Block block) {
        return this.with_index_common(context, block, "with_index", context.nil);
    }

    @JRubyMethod(name={"with_index"})
    public IRubyObject with_index19(ThreadContext context, IRubyObject arg2, Block block) {
        return this.with_index_common(context, block, "with_index", arg2);
    }

    @JRubyMethod
    public synchronized IRubyObject next(ThreadContext context) {
        this.ensureNexter(context);
        if (!this.feedValue.isNil()) {
            this.feedValue = context.nil;
        }
        return this.nexter.next();
    }

    @JRubyMethod
    public synchronized IRubyObject rewind(ThreadContext context) {
        if (this.object.respondsTo("rewind")) {
            this.object.callMethod(context, "rewind");
        }
        if (this.nexter != null) {
            this.nexter.shutdown();
            this.nexter = null;
        }
        return this;
    }

    @JRubyMethod
    public synchronized IRubyObject peek(ThreadContext context) {
        this.ensureNexter(context);
        return this.nexter.peek();
    }

    @JRubyMethod(name={"peek_values"})
    public synchronized IRubyObject peekValues(ThreadContext context) {
        this.ensureNexter(context);
        return RubyArray.newArray(context.runtime, this.nexter.peek());
    }

    @JRubyMethod(name={"next_values"})
    public synchronized IRubyObject nextValues(ThreadContext context) {
        this.ensureNexter(context);
        if (!this.feedValue.isNil()) {
            this.feedValue = context.nil;
        }
        return RubyArray.newArray(context.runtime, this.nexter.next());
    }

    @JRubyMethod
    public IRubyObject feed(ThreadContext context, IRubyObject val) {
        this.ensureNexter(context);
        if (!this.feedValue.isNil()) {
            throw context.runtime.newTypeError("feed value already set");
        }
        this.feedValue = val;
        this.nexter.setFeedValue(val);
        return context.nil;
    }

    private void ensureNexter(ThreadContext context) {
        if (this.nexter == null) {
            this.nexter = ((Boolean)Options.ENUMERATOR_LIGHTWEIGHT.load()).booleanValue() ? (this.object instanceof RubyArray && this.method.equals("each") && this.methodArgs.length == 0 ? new ArrayNexter(context.runtime, this.object, this.method, this.methodArgs) : new ThreadedNexter(context.runtime, this.object, this.method, this.methodArgs)) : new ThreadedNexter(context.runtime, this.object, this.method, this.methodArgs);
        }
    }

    protected void finalize() throws Throwable {
        try {
            Nexter nexter = this.nexter;
            if (nexter != null) {
                nexter.shutdown();
                Object var1_1 = null;
            }
        }
        finally {
            super.finalize();
        }
    }

    private static class ThreadedNexter
    extends Nexter
    implements Runnable {
        private static final boolean DEBUG = false;
        final SynchronousQueue<IRubyObject> out = new SynchronousQueue();
        private volatile Thread thread;
        private IRubyObject doneObject;
        private Future future;
        protected volatile boolean die = false;
        private IRubyObject lastValue;
        private volatile IRubyObject stopValue;

        public ThreadedNexter(Ruby runtime, IRubyObject object, String method, IRubyObject[] methodArgs) {
            super(runtime, object, method, methodArgs);
            this.setFeedValue(runtime.getNil());
        }

        @Override
        public synchronized IRubyObject next() {
            if (this.doneObject != null) {
                return this.returnValue(this.doneObject);
            }
            this.ensureStarted();
            return this.returnValue(this.take());
        }

        @Override
        public synchronized void shutdown() {
            this.future.cancel(true);
            this.die = true;
            Thread myThread = this.thread;
            if (myThread != null) {
                myThread.interrupt();
                myThread.interrupt();
                this.thread = null;
                this.doneObject = null;
            }
        }

        @Override
        public synchronized IRubyObject peek() {
            if (this.doneObject != null) {
                return this.returnValue(this.doneObject);
            }
            this.ensureStarted();
            if (this.lastValue != null) {
                return this.lastValue;
            }
            this.peekTake();
            return this.returnValue(this.lastValue);
        }

        private void ensureStarted() {
            try {
                if (this.thread == null) {
                    this.future = this.runtime.getFiberExecutor().submit(this);
                }
            }
            catch (OutOfMemoryError oome) {
                String oomeMessage = oome.getMessage();
                if (oomeMessage != null && oomeMessage.contains("unable to create new native thread")) {
                    System.gc();
                    this.future = this.runtime.getFiberExecutor().submit(this);
                }
                throw oome;
            }
        }

        private IRubyObject peekTake() {
            try {
                this.lastValue = this.out.take();
                return this.lastValue;
            }
            catch (InterruptedException ie) {
                throw this.runtime.newThreadError("interrupted during iteration");
            }
        }

        private IRubyObject take() {
            try {
                if (this.lastValue != null) {
                    IRubyObject iRubyObject = this.lastValue;
                    return iRubyObject;
                }
                IRubyObject iRubyObject = this.out.take();
                return iRubyObject;
            }
            catch (InterruptedException ie) {
                throw this.runtime.newThreadError("interrupted during iteration");
            }
            finally {
                this.lastValue = null;
            }
        }

        private IRubyObject returnValue(IRubyObject value2) {
            if (value2 == RubyBasicObject.NEVER) {
                this.doneObject = value2;
                throw this.runtime.newStopIteration(this.stopValue, "iteration reached an end");
            }
            if (value2 instanceof RubyException) {
                this.doneObject = value2;
                throw new RaiseException((RubyException)value2);
            }
            return value2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.die) {
                return;
            }
            this.thread = Thread.currentThread();
            ThreadContext context = this.runtime.getCurrentContext();
            IRubyObject finalObject = RubyBasicObject.NEVER;
            try {
                IRubyObject oldExc = this.runtime.getGlobalVariables().get("$!");
                final TerminateEnumeration terminateEnumeration = new TerminateEnumeration();
                Block generatorClosure = CallBlock.newCallClosure(this.object, (RubyModule)this.object.getMetaClass(), Signature.OPTIONAL, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
                        try {
                            if (ThreadedNexter.this.die) {
                                throw terminateEnumeration;
                            }
                            ThreadedNexter.this.out.put(RubyEnumerable.packEnumValues(context, args2));
                            if (ThreadedNexter.this.die) {
                                throw terminateEnumeration;
                            }
                        }
                        catch (InterruptedException ie) {
                            throw terminateEnumeration;
                        }
                        IRubyObject feedValue = ThreadedNexter.this.getFeedValue();
                        ThreadedNexter.this.setFeedValue(context.nil);
                        return feedValue;
                    }
                }, context);
                try {
                    this.stopValue = this.object.callMethod(context, this.method, this.methodArgs, generatorClosure);
                }
                catch (TerminateEnumeration te) {
                    if (te != terminateEnumeration) {
                        throw te;
                    }
                }
                catch (RaiseException re) {
                    finalObject = re.getException();
                    this.runtime.getGlobalVariables().set("$!", oldExc);
                }
                catch (Throwable t) {
                    Helpers.throwException(t);
                }
                try {
                    if (!this.die) {
                        this.out.put(finalObject);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.thread = null;
            }
        }

        private static class TerminateEnumeration
        extends RuntimeException
        implements Unrescuable {
            private TerminateEnumeration() {
            }
        }
    }

    private static class ArrayNexter
    extends Nexter {
        private final RubyArray array;
        private int index = 0;

        public ArrayNexter(Ruby runtime, IRubyObject object, String method, IRubyObject[] methodArgs) {
            super(runtime, object, method, methodArgs);
            this.array = (RubyArray)object;
        }

        @Override
        public IRubyObject next() {
            IRubyObject obj = this.peek();
            ++this.index;
            return obj;
        }

        @Override
        public void shutdown() {
            this.index = 0;
        }

        @Override
        public IRubyObject peek() {
            this.checkIndex();
            return this.get();
        }

        protected IRubyObject get() {
            return this.array.eltOk(this.index);
        }

        private void checkIndex() throws RaiseException {
            if (this.index >= this.array.size()) {
                throw this.runtime.newStopIteration(this.array, null);
            }
        }
    }

    private static abstract class Nexter {
        protected final Ruby runtime;
        protected final IRubyObject object;
        protected final String method;
        protected final IRubyObject[] methodArgs;
        private IRubyObject feedValue;

        public Nexter(Ruby runtime, IRubyObject object, String method, IRubyObject[] methodArgs) {
            this.object = object;
            this.method = method;
            this.methodArgs = methodArgs;
            this.runtime = runtime;
        }

        public void setFeedValue(IRubyObject feedValue) {
            this.feedValue = feedValue;
        }

        public IRubyObject getFeedValue() {
            return this.feedValue;
        }

        public abstract IRubyObject next();

        public abstract void shutdown();

        public abstract IRubyObject peek();
    }

    public static interface SizeFn {
        public IRubyObject size(IRubyObject[] var1);
    }
}

